/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.TriPredicate;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;

public interface BreakPredicate
extends TriPredicate<LivingEntity, ItemStack, ItemStack> {
    public static final BreakPredicate NEVER = (pl, in, ou) -> false;
    public static final BreakPredicate ALWAYS = (pl, in, ou) -> true;

    public static final class ByChanceWithLuck
    implements BreakPredicate {
        private final float _break_chance;
        private final float _luck_multiplier;

        public ByChanceWithLuck(float chance, float multiplier) {
            this._break_chance = chance;
            this._luck_multiplier = Math.abs(multiplier);
        }

        public boolean test(LivingEntity user, ItemStack held, ItemStack leftover) {
            boolean brk = ItemSupport.canApplyDamage(held, 1, user.func_70681_au());
            if (!brk) {
                return false;
            }
            float luck = (float)MathHelper.func_151237_a((double)user.func_233637_b_(Attributes.field_233828_k_), (double)-10.0, (double)10.0);
            return user.func_70681_au().nextFloat() < this._break_chance - luck * this._luck_multiplier;
        }
    }

    public static final class ByChance
    implements BreakPredicate {
        private final float _break_chance;

        public ByChance(float chance) {
            this._break_chance = chance;
        }

        public boolean test(LivingEntity user, ItemStack held, ItemStack leftover) {
            boolean brk = ItemSupport.canApplyDamage(held, 1, user.func_70681_au());
            return !brk ? false : user.func_70681_au().nextFloat() < this._break_chance;
        }
    }
}

