/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IDrink;
import org.jwaresoftware.mcmods.lib.api.IDrinkableFluid;
import org.jwaresoftware.mcmods.lib.api.INutritionSource;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalBucketItem;
import org.jwaresoftware.mcmods.lib.impl.item.BucketItemBase;

public class DrinkableBucketItem
extends BucketItemBase
implements IDrink,
INutritionSource.Wrap {
    public DrinkableBucketItem(String oid, @Nonnull Supplier<? extends Fluid> supplier, @Nonnull Item.Properties builder) {
        super(oid, supplier, builder);
    }

    private IDrinkableFluid toDrinkableFluidImpl() {
        return (IDrinkableFluid)this.getFluid();
    }

    protected final boolean isDrinkableFluid() {
        return this.getFluid() instanceof IDrinkableFluid;
    }

    @Nonnull
    protected final IDrink getDrink() {
        return this.isDrinkableFluid() ? this.toDrinkableFluidImpl().getDrinkValues() : LiquidType.NONE;
    }

    @Nonnull
    protected final IDrinkableFluid getDrinkable() {
        return this.isDrinkableFluid() ? this.toDrinkableFluidImpl() : IDrinkableFluid.NONE;
    }

    @Override
    public float getThirstQuenched(ItemStack consumed) {
        return this.getDrink().getThirstQuenched(consumed);
    }

    @Override
    public float getHydrationAdded(ItemStack consumed) {
        return this.getDrink().getHydrationAdded(consumed);
    }

    @Override
    public float getThirstTriggerChance(ItemStack consumed, LivingEntity drinker) {
        return this.getDrink().getThirstTriggerChance(consumed, drinker);
    }

    @Override
    public float getDamageChanceIfDrunk(ItemStack consumed, LivingEntity drinker) {
        return this.getDrink().getDamageChanceIfDrunk(consumed, drinker);
    }

    public int func_77626_a(ItemStack bucket) {
        IDrinkableFluid drink = this.getDrinkable();
        return drink.includeCooldown() ? SharedGlue.HEARTY_FOOD_CONSUME_DURATION() : SharedGlue.DEFAULT_LIQUID_USE_DURATION();
    }

    public UseAction func_77661_b(ItemStack bucket) {
        return UseAction.DRINK;
    }

    private ActionResult<ItemStack> startDrinking(IDrinkableFluid drink, ItemStack bucket, PlayerEntity player, Hand hand) {
        ActionResultType result = ActionResultType.FAIL;
        player.func_184598_c(hand);
        if (drink.isConsumableAlways() || player.func_71043_e(false)) {
            result = ActionResultType.CONSUME;
        }
        return new ActionResult(result, (Object)bucket);
    }

    protected void onBucketDrunk(ItemStack held, World world, PlayerEntity player) {
        this.getDrinkable().onDrunk(ItemStacks.copy1(held), (LivingEntity)player);
    }

    public ItemStack func_77654_b(ItemStack held, World world, LivingEntity entity) {
        if (SharedGlue.isaPlayer((Entity)entity)) {
            PlayerEntity player = SharedGlue.getPlayerOrNull((Entity)entity);
            Effects.playFoodConsumed(world, player);
            ItemStack copy = ItemStacks.copy1(held);
            IFluidHandlerItem fspi = UniversalBucketItem.getFluidHandler(copy);
            FluidStack consumed = fspi.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            if (consumed.getAmount() == 1000) {
                this.onBucketDrunk(held, world, player);
                if (SharedGlue.getPlayerInSurvival(player)) {
                    held.func_190918_g(1);
                    if (!copy.func_77973_b().getContainerItem(copy).func_190926_b()) {
                        if (held.func_190926_b()) {
                            return fspi.getContainer();
                        }
                        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)fspi.getContainer());
                    }
                }
            }
        }
        return held;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        IDrinkableFluid drink;
        ActionResult<ItemStack> r;
        BlockRayTraceResult rtr;
        if (!(!this.isDrinkableFluid() || (rtr = DrinkableBucketItem.func_219968_a((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.ANY)) != null && rtr.func_216346_c() == RayTraceResult.Type.BLOCK || (r = this.startDrinking(drink = this.getDrinkable(), player.func_184586_b(hand), player, hand)).func_188397_a() != ActionResultType.CONSUME && SharedGlue.isEntitySneaking((Entity)player))) {
            return r;
        }
        return super.func_77659_a(world, player, hand);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack bucket, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        super.func_77624_a(bucket, world, tooltip, flags);
        if (this.isDrinkableFluid()) {
            IDrinkableFluid drink = this.getDrinkable();
            drink.addConsumeTip(bucket, tooltip, true);
        }
    }

    @Override
    public final INutritionSource get() {
        return this.getDrinkable();
    }
}

