/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.api.IDrinkableFluid;

public final class DrinkableFluid {

    public static final class WaterFlowing
    extends Flowing {
        public WaterFlowing(@Nonnull Supplier<IDrinkableFluid> drinkImpl, ForgeFlowingFluid.Properties fp) {
            super(drinkImpl, fp);
        }

        @OnlyIn(value=Dist.CLIENT)
        public IParticleData func_204521_c() {
            return ParticleTypes.field_197618_k;
        }
    }

    public static final class WaterSource
    extends Source {
        public WaterSource(@Nonnull Supplier<IDrinkableFluid> drinkImpl, ForgeFlowingFluid.Properties fp) {
            super(drinkImpl, fp);
        }

        @OnlyIn(value=Dist.CLIENT)
        public IParticleData func_204521_c() {
            return ParticleTypes.field_197618_k;
        }
    }

    public static class Flowing
    extends ForgeFlowingFluid.Flowing
    implements IDrinkableFluid {
        @Nonnull
        protected final Supplier<IDrinkableFluid> _d;

        public Flowing(@Nonnull Supplier<IDrinkableFluid> drinkImpl, ForgeFlowingFluid.Properties fp) {
            super(fp);
            this._d = drinkImpl;
        }

        @Override
        @Nonnull
        public LiquidType getDrinkValues() {
            return this._d.get().getDrinkValues();
        }

        @Override
        public boolean isConsumable(ItemStack unused) {
            return false;
        }

        @Override
        @Nullable
        public IDrinkableFluid getDrinkableSip() {
            return this._d.get().getDrinkableSip();
        }
    }

    public static class Source
    extends ForgeFlowingFluid.Source
    implements IDrinkableFluid {
        @Nonnull
        protected final Supplier<IDrinkableFluid> _d;

        public Source(@Nonnull Supplier<IDrinkableFluid> drinkImpl, ForgeFlowingFluid.Properties fp) {
            super(fp);
            this._d = drinkImpl;
        }

        @Override
        public boolean isConsumableAlways() {
            return this._d.get().isConsumableAlways();
        }

        @Override
        public boolean includeCooldown() {
            return this._d.get().includeCooldown();
        }

        @Override
        @Nonnull
        public LiquidType getDrinkValues() {
            return this._d.get().getDrinkValues();
        }

        @Override
        public float getNNHealAmount() {
            return this._d.get().getNNHealAmount();
        }

        @Override
        public float getNNSaturationModifier() {
            return this._d.get().getNNSaturationModifier();
        }

        @Override
        public long getNNCheckList(ItemStack source) {
            return this._d.get().getNNCheckList(source);
        }

        @Override
        public void onDrunk(ItemStack what, @Nonnull LivingEntity drinker) {
            this._d.get().onDrunk(what, drinker);
        }

        @Override
        @Nullable
        public IDrinkableFluid getDrinkableSip() {
            return this._d.get().getDrinkableSip();
        }

        @Override
        public boolean addConsumeTip(ItemStack rep, List<ITextComponent> tooltip, boolean detailed) {
            return this._d.get().addConsumeTip(rep, tooltip, detailed);
        }
    }
}

