/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IBucketful;

public class PortionedItemStackFluidHandler
extends FluidHandlerItemStackSimple {
    protected static final int _1BUCKET = 1000;
    public static final int TOO_HOT = 573;
    public static final Predicate<FluidStack> IS_WLM = new Predicate<FluidStack>(){

        @Override
        public boolean test(FluidStack subject) {
            return Fluids.isWater(subject) || subject.getFluid() == Fluids.lava() || Fluids.isMilkLike(subject);
        }
    };
    public static final Predicate<FluidStack> IS_WaM = new Predicate<FluidStack>(){

        @Override
        public boolean test(FluidStack subject) {
            return Fluids.isWater(subject) || Fluids.isMilkLike(subject);
        }
    };
    public static final Predicate<FluidStack> IS_COMMON_FLUID = new Predicate<FluidStack>(){

        @Override
        public boolean test(FluidStack subject) {
            return IS_WLM.test(subject) || RID.isIn(subject.getFluid(), "common");
        }
    };
    public static final Predicate<FluidStack> IS_COOL_FLUID = new Predicate<FluidStack>(){

        @Override
        public boolean test(FluidStack subject) {
            FluidAttributes f = subject.getFluid().getAttributes();
            return !f.isGaseous() && f.getTemperature() > 0 && f.getTemperature() <= 573;
        }
    };
    public static final Predicate<FluidStack> IS_JARABLE_FLUID = IS_COOL_FLUID.and(IS_COMMON_FLUID);
    private final Item _fullemptyHolder;
    private Predicate<ItemStack> _is_empty;
    private final int _1USE_mB;
    private final Predicate<FluidStack> _is_allowed;

    public PortionedItemStackFluidHandler(ItemStack holder, Item flipHolder, int capacity_mB, int perUse_mB, Predicate<ItemStack> empty, @Nonnull Predicate<FluidStack> allowed) {
        super(holder, capacity_mB);
        this._fullemptyHolder = flipHolder;
        this._is_empty = empty;
        this._1USE_mB = perUse_mB;
        this._is_allowed = allowed;
    }

    public PortionedItemStackFluidHandler(ItemStack holder, Item flipHolder, boolean emptyFlag) {
        this(holder, flipHolder, 1000, 1000, stk -> emptyFlag, IS_JARABLE_FLUID);
    }

    protected final boolean isEmpty() {
        return this._is_empty.test(this.getContainer());
    }

    @Nonnull
    public FluidStack getFluid() {
        return Fluids.getBucketFluid(this.getContainer());
    }

    protected void setFluid(@Nonnull FluidStack fluid) {
        Fluids.setBucketFluid(this.getContainer(), fluid, true);
        if (this.container.func_77973_b() instanceof IBucketful) {
            ((IBucketful)this.container.func_77973_b()).onFluidChanged(this.container);
        }
    }

    public boolean isFluidValid(int tank, @Nonnull FluidStack fluid) {
        return fluid != null && this._is_allowed.test(fluid);
    }

    public boolean canFillFluidType(@Nonnull FluidStack supply) {
        return this.isFluidValid(0, supply);
    }

    public boolean canDrainFluidType(@Nonnull FluidStack wanted) {
        return !this.isEmpty() && !this.container.func_190926_b();
    }

    protected void setContainerToEmpty() {
        if (!this.getContainer().func_190926_b()) {
            boolean wasEmpty = this.isEmpty();
            Fluids.removeBucketData(this.container);
            if (!wasEmpty) {
                this.container = SharedGlue.isDefined(this._fullemptyHolder) ? ItemStacks.create(this._fullemptyHolder) : ItemStack.field_190927_a;
            }
        }
    }

    protected void setContainerFillable() {
        if (!this.getContainer().func_190926_b() && this.isEmpty()) {
            ItemStack fillable = ItemStacks.create(this._fullemptyHolder);
            ItemStacks.getOrCreateData(fillable);
            this.container = fillable;
        }
    }

    @Nonnull
    public FluidStack drain(FluidStack wanted, IFluidHandler.FluidAction action) {
        int drainAmount;
        FluidStack have;
        FluidStack presentFluid;
        FluidStack drained = FluidStack.EMPTY;
        if (wanted != null && wanted.getAmount() >= this._1USE_mB && !(presentFluid = this.getFluid()).isEmpty() && wanted.containsFluid(have = Fluids.copy(presentFluid, drainAmount = Math.min(presentFluid.getAmount(), wanted.getAmount())))) {
            drained = this.drain(wanted.getAmount(), action);
        }
        return drained;
    }

    @Nonnull
    public FluidStack drain(int wantedAmount, IFluidHandler.FluidAction action) {
        if (wantedAmount >= this._1USE_mB) {
            FluidStack presentFluid = this.getFluid();
            wantedAmount = wantedAmount / this._1USE_mB * this._1USE_mB;
            if (!presentFluid.isEmpty() && this.canDrainFluidType(presentFluid)) {
                int drainedAmount = Math.min(presentFluid.getAmount(), wantedAmount);
                FluidStack drained = Fluids.copy(presentFluid, drainedAmount);
                if (action.execute()) {
                    if (drainedAmount == presentFluid.getAmount()) {
                        this.setContainerToEmpty();
                    } else {
                        this.setFluid(Fluids.copy(presentFluid, presentFluid.getAmount() - drainedAmount));
                    }
                }
                return drained;
            }
        }
        return FluidStack.EMPTY;
    }

    public int fill(FluidStack supplied, IFluidHandler.FluidAction action) {
        int acceptedAmount = 0;
        if (supplied != null && supplied.getAmount() >= this._1USE_mB && this.canFillFluidType(supplied)) {
            FluidStack presentFluid = this.getFluid();
            int fillAmount = this.capacity;
            if (!presentFluid.isEmpty()) {
                if (!presentFluid.isFluidEqual(supplied)) {
                    return 0;
                }
                if ((fillAmount -= presentFluid.getAmount()) == 0) {
                    return 0;
                }
            }
            int suppliedAmount = supplied.getAmount() / this._1USE_mB * this._1USE_mB;
            fillAmount = Math.min(fillAmount, suppliedAmount);
            if (supplied.getAmount() >= fillAmount) {
                if (action.execute()) {
                    this.setContainerFillable();
                    int newAmount = fillAmount + (presentFluid.isEmpty() ? 0 : presentFluid.getAmount());
                    this.setFluid(Fluids.copy(supplied, newAmount));
                }
                acceptedAmount = fillAmount;
            }
        }
        return acceptedAmount;
    }
}

