/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.fluid;

import java.util.ArrayList;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.thirdparty.silentchaos512.utils.Color;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.IniRegistries;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Materials;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IDrinkableFluid;
import org.jwaresoftware.mcmods.lib.impl.fluid.ContainerFluidAttributes;
import org.jwaresoftware.mcmods.lib.impl.fluid.DrinkableBucketItem;
import org.jwaresoftware.mcmods.lib.impl.fluid.DrinkableFluid;
import org.jwaresoftware.mcmods.lib.impl.fluid.FlowingFluidEffectBlock;
import org.jwaresoftware.mcmods.lib.impl.fluid.WarmableBucketItem;

public class UniversalFluids {
    @Nullable
    public static WarmableBucketItem POTABLE_WATER_BUCKET;
    static FlowingFluidBlock POTABLE_WATER_BLOCK;
    @Nullable
    public static WarmableBucketItem COWMILK_BUCKET;
    static FlowingFluidBlock COWMILK_BLOCK;
    @Nullable
    public static WarmableBucketItem OATMILK_BUCKET;
    static FlowingFluidBlock OATMILK_BLOCK;
    @Nullable
    public static DrinkableBucketItem LIQUID_XP_BUCKET;
    static FlowingFluidBlock LIQUID_XP_BLOCK;
    @Nullable
    public static WarmableBucketItem HONEY_BUCKET;
    static FlowingFluidBlock LIQUID_HONEY_BLOCK;
    @Nullable
    public static BucketItem SEEDOIL_BUCKET;
    static FlowingFluidBlock SEEDOIL_BLOCK;
    @Nullable
    public static BucketItem INK_BUCKET;
    static FlowingFluidBlock INK_BLOCK;

    static final Item.Properties bucketproperties() {
        return new Item.Properties().func_200917_a(1).func_200919_a(Items.field_151133_ar).func_200916_a(SharedGlue.CreativeTabs_misc);
    }

    static final Item.Properties bucketproperties(int n) {
        return new Item.Properties().func_200917_a(n).func_200919_a(Items.field_151133_ar).func_200916_a(SharedGlue.CreativeTabs_misc);
    }

    public static final ForgeFlowingFluid.Properties thick_fluid(ForgeFlowingFluid.Properties fluidproperties) {
        return fluidproperties.slopeFindDistance(2).levelDecreasePerBlock(2).tickRate(20);
    }

    private static final void makePotableWater() {
        ResourceLocation still = new ResourceLocation("block/water_still");
        ResourceLocation flowing = new ResourceLocation("block/water_flow");
        POTABLE_WATER_BUCKET = new WarmableBucketItem("potable_water_bucket", () -> Fluids.POTABLE_WATER, UniversalFluids.bucketproperties(4));
        UniversalFluids.POTABLE_WATER_BUCKET._natural_coolant = true;
        IniRegistries.autoregisterItem(LibInfo.MOD_ID(), (Item)POTABLE_WATER_BUCKET, POTABLE_WATER_BUCKET.oid());
        POTABLE_WATER_BLOCK = new FlowingFluidBlock(() -> Fluids.POTABLE_WATER, AbstractBlock.Properties.func_200945_a((Material)SharedGlue.Material_water).func_200942_a().func_200943_b(100.0f).func_222380_e());
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), POTABLE_WATER_BLOCK, LibInfo.rstring("liquid_potable_water_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.POTABLE_WATER, () -> Fluids.FLOWING_POTABLE_WATER, ContainerFluidAttributes.builder(still, flowing).flatColor(Color.fluidColor(4159204)).biomeTint().overlay(new ResourceLocation("block/water_overlay")).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K)).block(() -> POTABLE_WATER_BLOCK).bucket(() -> POTABLE_WATER_BUCKET);
        Fluids.POTABLE_WATER = new DrinkableFluid.WaterSource(() -> IDrinkableFluid.CLEANWATER_BUCKET, fluidproperties);
        Fluids.FLOWING_POTABLE_WATER = new DrinkableFluid.WaterFlowing(() -> IDrinkableFluid.CLEANWATER_BUCKET, fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.POTABLE_WATER, "potable_water");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_POTABLE_WATER, "flowing_potable_water");
    }

    private static final void makeMilk() {
        ResourceLocation still = LibInfo.r("fluids/fluid_milk_still");
        ResourceLocation flowing = LibInfo.r("fluids/fluid_milk_flowing");
        COWMILK_BUCKET = new WarmableBucketItem("cowmilk_bucket", () -> Fluids.MILK, UniversalFluids.bucketproperties(4));
        IniRegistries.autoregisterItem(LibInfo.MOD_ID(), (Item)COWMILK_BUCKET, COWMILK_BUCKET.oid());
        COWMILK_BLOCK = new FlowingFluidBlock(() -> Fluids.MILK, AbstractBlock.Properties.func_200945_a((Material)Materials.milk).func_200942_a().func_200943_b(100.0f).func_222380_e());
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), COWMILK_BLOCK, LibInfo.rstring("liquid_milk_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.MILK, () -> Fluids.FLOWING_MILK, FluidAttributes.builder((ResourceLocation)still, (ResourceLocation)flowing).viscosity(1200).density(1200).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K)).block(() -> COWMILK_BLOCK).bucket(() -> COWMILK_BUCKET);
        Fluids.MILK = new DrinkableFluid.Source(() -> IDrinkableFluid.MILKMILK_BUCKET, fluidproperties);
        Fluids.FLOWING_MILK = new DrinkableFluid.Flowing(() -> IDrinkableFluid.MILKMILK_BUCKET, fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.MILK, "milk");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_MILK, "flowing_milk");
    }

    private static final void makeOatMilk() {
        ResourceLocation still = LibInfo.r("fluids/fluid_plantmilk_still");
        ResourceLocation flowing = LibInfo.r("fluids/fluid_plantmilk_flowing");
        OATMILK_BUCKET = new WarmableBucketItem("oatmilk_bucket", () -> Fluids.OATMILK, UniversalFluids.bucketproperties(4));
        IniRegistries.autoregisterItem(LibInfo.MOD_ID(), (Item)OATMILK_BUCKET, OATMILK_BUCKET.oid());
        OATMILK_BLOCK = new FlowingFluidBlock(() -> Fluids.OATMILK, AbstractBlock.Properties.func_200945_a((Material)Materials.milk).func_200942_a().func_200943_b(100.0f).func_222380_e());
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), OATMILK_BLOCK, LibInfo.rstring("liquid_oatmilk_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.OATMILK, () -> Fluids.FLOWING_OATMILK, FluidAttributes.builder((ResourceLocation)still, (ResourceLocation)flowing).viscosity(1200).density(1200).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K)).block(() -> OATMILK_BLOCK).bucket(() -> OATMILK_BUCKET);
        Fluids.OATMILK = new DrinkableFluid.Source(() -> IDrinkableFluid.PLANTMILK_BUCKET, fluidproperties);
        Fluids.FLOWING_OATMILK = new DrinkableFluid.Flowing(() -> IDrinkableFluid.PLANTMILK_BUCKET, fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.OATMILK, "oatmilk");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_OATMILK, "flowing_oatmilk");
    }

    private static final void makeLiquidXp() {
        ResourceLocation still = LibInfo.r("fluids/fluid_xp_still");
        ResourceLocation flowing = LibInfo.r("fluids/fluid_xp_flowing");
        LIQUID_XP_BUCKET = new DrinkableBucketItem("experience_bucket", () -> Fluids.EXPERIENCE, UniversalFluids.bucketproperties());
        IniRegistries.autoregisterItem(LibInfo.MOD_ID(), (Item)LIQUID_XP_BUCKET, LIQUID_XP_BUCKET.oid());
        LIQUID_XP_BLOCK = new FlowingFluidBlock(() -> Fluids.EXPERIENCE, AbstractBlock.Properties.func_200945_a((Material)Materials.liquid_xp).func_200942_a().func_200943_b(100.0f).func_222380_e());
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), LIQUID_XP_BLOCK, LibInfo.rstring("liquid_xp_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.EXPERIENCE, () -> Fluids.FLOWING_EXPERIENCE, ContainerFluidAttributes.builder(still, flowing).flatColor(Color.fluidColor(11665166)).viscosity(1400).density(1250).luminosity(8).sound(SoundEvents.field_187633_N, SoundEvents.field_187627_L)).block(() -> LIQUID_XP_BLOCK).bucket(() -> LIQUID_XP_BUCKET);
        Fluids.EXPERIENCE = new DrinkableFluid.Source(() -> IDrinkableFluid.XP_BUCKET, fluidproperties);
        Fluids.FLOWING_EXPERIENCE = new DrinkableFluid.Flowing(() -> IDrinkableFluid.XP_BUCKET, fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.EXPERIENCE, "experience");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_EXPERIENCE, "flowing_experience");
    }

    private static final void makeHoney() {
        ResourceLocation still = LibInfo.r("fluids/fluid_honey_still");
        ResourceLocation flowing = LibInfo.r("fluids/fluid_honey_flowing");
        HONEY_BUCKET = new WarmableBucketItem("honey_bucket", () -> Fluids.HONEY, UniversalFluids.bucketproperties());
        IniRegistries.autoregisterItem(LibInfo.MOD_ID(), (Item)HONEY_BUCKET, HONEY_BUCKET.oid());
        LIQUID_HONEY_BLOCK = new FlowingFluidEffectBlock(() -> Fluids.HONEY, AbstractBlock.Properties.func_200945_a((Material)Materials.sticky_goo).func_200942_a().func_200943_b(100.0f).func_222380_e(), (xyz, ent) -> {
            FlowingFluidEffectBlock.slowMovementEffect(ent);
            if (SharedGlue.isaPlayerOrFriendly(ent)) {
                FlowingFluidEffectBlock.addPotionEffect((LivingEntity)ent, SharedGlue.Potion_regeneration, 0, 15, false);
            }
        });
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), LIQUID_HONEY_BLOCK, LibInfo.rstring("liquid_honey_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.HONEY, () -> Fluids.FLOWING_HONEY, ContainerFluidAttributes.builder(still, flowing).flatColor(Color.fluidColor(13607429)).viscosity(1400).density(1400).luminosity(1).sound(SoundEvents.field_187633_N, SoundEvents.field_187627_L)).block(() -> LIQUID_HONEY_BLOCK).bucket(() -> HONEY_BUCKET);
        fluidproperties = UniversalFluids.thick_fluid(fluidproperties);
        Fluids.HONEY = new DrinkableFluid.Source(() -> IDrinkableFluid.HONEY_BUCKET, fluidproperties);
        Fluids.FLOWING_HONEY = new DrinkableFluid.Flowing(() -> IDrinkableFluid.HONEY_BUCKET, fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.HONEY, "honey");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_HONEY, "flowing_honey");
    }

    private static final void makeSeedoil() {
        ResourceLocation still = LibInfo.r("fluids/fluid_seedoil_still");
        ResourceLocation flowing = LibInfo.r("fluids/fluid_seedoil_flowing");
        SEEDOIL_BUCKET = new BucketItem(() -> Fluids.SEEDOIL, UniversalFluids.bucketproperties(4));
        IniRegistries.autoregisterItem(LibInfo.MOD_ID(), (Item)SEEDOIL_BUCKET, "seedoil_bucket");
        SEEDOIL_BLOCK = new FlowingFluidBlock(() -> Fluids.SEEDOIL, AbstractBlock.Properties.func_200945_a((Material)Materials.sticky_goo).func_200942_a().func_200943_b(100.0f).func_222380_e());
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), SEEDOIL_BLOCK, LibInfo.rstring("liquid_seedoil_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.SEEDOIL, () -> Fluids.FLOWING_SEEDOIL, ContainerFluidAttributes.builder(still, flowing).flatColor(Color.fluidColor(11708802)).viscosity(1250).density(1250).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K)).block(() -> SEEDOIL_BLOCK).bucket(() -> SEEDOIL_BUCKET);
        Fluids.SEEDOIL = new ForgeFlowingFluid.Source(fluidproperties);
        Fluids.FLOWING_SEEDOIL = new ForgeFlowingFluid.Flowing(fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.SEEDOIL, "seedoil");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_SEEDOIL, "flowing_seedoil");
    }

    private static final void makeInk() {
        ResourceLocation still = LibInfo.r("fluids/fluid_squidink_still");
        ResourceLocation flowing = LibInfo.r("fluids/fluid_squidink_flowing");
        INK_BUCKET = new BucketItem(() -> Fluids.SQUIDINK, UniversalFluids.bucketproperties());
        IniRegistries.autoregisterItem(LibInfo.MOD_ID(), (Item)INK_BUCKET, "squidink_bucket");
        INK_BLOCK = new FlowingFluidEffectBlock(() -> Fluids.SQUIDINK, AbstractBlock.Properties.func_200945_a((Material)Materials.squid_ink).func_200942_a().func_200943_b(100.0f).func_222380_e(), (xyz, ent) -> {
            FlowingFluidEffectBlock.slowMovementEffect(ent);
            if (ent instanceof LivingEntity) {
                FlowingFluidEffectBlock.addPotionEffect((LivingEntity)ent, SharedGlue.Potion_blindness, 0, 15, false);
            }
        });
        IniRegistries.autoregisterFluidBlock(LibInfo.MOD_ID(), INK_BLOCK, LibInfo.rstring("liquid_squidink_block"));
        ForgeFlowingFluid.Properties fluidproperties = new ForgeFlowingFluid.Properties(() -> Fluids.SQUIDINK, () -> Fluids.FLOWING_SQUIDINK, ContainerFluidAttributes.builder(still, flowing).flatColor(Color.fluidColor(196881)).viscosity(1200).density(1200).sound(SoundEvents.field_187630_M, SoundEvents.field_187624_K)).block(() -> INK_BLOCK).bucket(() -> INK_BUCKET);
        Fluids.SQUIDINK = new ForgeFlowingFluid.Source(fluidproperties);
        Fluids.FLOWING_SQUIDINK = new ForgeFlowingFluid.Flowing(fluidproperties);
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.SQUIDINK, "squidink");
        IniRegistries.autoregisterFluid(LibInfo.MOD_ID(), (Fluid)Fluids.FLOWING_SQUIDINK, "flowing_squidink");
    }

    public static final void makeFluids() {
        UniversalFluids.makePotableWater();
        UniversalFluids.makeMilk();
        UniversalFluids.makeOatMilk();
        UniversalFluids.makeHoney();
        UniversalFluids.makeSeedoil();
        UniversalFluids.makeLiquidXp();
        UniversalFluids.makeInk();
    }

    public static final Stream<WarmableBucketItem> warmableBuckets() {
        ArrayList<WarmableBucketItem> buckets = new ArrayList<WarmableBucketItem>();
        if (POTABLE_WATER_BUCKET != null) {
            buckets.add(POTABLE_WATER_BUCKET);
        }
        if (COWMILK_BUCKET != null) {
            buckets.add(COWMILK_BUCKET);
        }
        if (OATMILK_BUCKET != null) {
            buckets.add(OATMILK_BUCKET);
        }
        if (HONEY_BUCKET != null) {
            buckets.add(HONEY_BUCKET);
        }
        return buckets.stream();
    }

    public static final ArrayList<ItemStack> milkBuckets() {
        ArrayList<ItemStack> buckets = new ArrayList<ItemStack>(6);
        buckets.add(new ItemStack((IItemProvider)Items.field_151117_aB));
        if (COWMILK_BUCKET != null) {
            buckets.add(new ItemStack((IItemProvider)COWMILK_BUCKET));
        }
        if (OATMILK_BUCKET != null) {
            buckets.add(new ItemStack((IItemProvider)OATMILK_BUCKET));
        }
        return buckets;
    }

    public static final Stream<Fluid> translucentBlocks() {
        ArrayList<FlowingFluid> blocks = new ArrayList<FlowingFluid>();
        if (POTABLE_WATER_BUCKET != null) {
            blocks.add(Fluids.POTABLE_WATER);
            blocks.add(Fluids.FLOWING_POTABLE_WATER);
        }
        if (COWMILK_BUCKET != null) {
            blocks.add(Fluids.MILK);
            blocks.add(Fluids.FLOWING_MILK);
        }
        if (OATMILK_BUCKET != null) {
            blocks.add(Fluids.OATMILK);
            blocks.add(Fluids.FLOWING_OATMILK);
        }
        if (SEEDOIL_BUCKET != null) {
            blocks.add(Fluids.SEEDOIL);
            blocks.add(Fluids.FLOWING_SEEDOIL);
        }
        return blocks.stream();
    }

    public static enum Selector {
        MILK(100),
        LAVA(99),
        WATER(98),
        EXP(97),
        HONEY(96),
        INK(95),
        RESIN(94),
        SLIME(93),
        SLURRY(92),
        SEEDOIL(91),
        CUSTOM0(90);

        private final int _value;

        private Selector(int i) {
            this._value = i;
        }

        public final int value() {
            return this._value;
        }
    }
}

