/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.item;

import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.IModItem;

public class BucketItemBase
extends BucketItem
implements IModItem {
    @Nonnull
    protected final String _oid;
    protected boolean _hidden = false;

    public BucketItemBase(String oid, @Nonnull Supplier<? extends Fluid> supplier, @Nonnull Item.Properties builder) {
        super(supplier, builder);
        this._oid = Objects.requireNonNull(oid, "Non-null oid required");
    }

    @Override
    public final String oid() {
        return this._oid;
    }

    @Nullable
    public final Food getBaseFood() {
        return super.func_219967_s();
    }

    @Override
    public int getBurnTime(ItemStack bucket) {
        return IModItem.super.getBurnTime(bucket);
    }

    public void func_77622_d(ItemStack bucket, @Nullable World unused0, @Nullable PlayerEntity player) {
        this.onCookedOrCrafted(bucket);
    }

    public ICapabilityProvider initCapabilities(ItemStack bucket, CompoundNBT nbt) {
        return new FluidBucketWrapper(bucket);
    }

    protected void addUsedStat(@Nonnull PlayerEntity player) {
        player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
    }

    @Override
    public boolean isHiddenByDefault() {
        return this._hidden;
    }

    @Override
    public void setHiddenByDefault(boolean flag) {
        this._hidden = flag;
    }

    public void func_150895_a(ItemGroup tab, NonNullList<ItemStack> items) {
        if (!this.isHiddenByDefault() && this.func_194125_a(tab)) {
            items.add((Object)this.createInstance((Item)this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack bucket, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (this.isShowingUiTips(bucket)) {
            Tooltips.addDocTipDefault(bucket, tooltip);
        }
        super.func_77624_a(bucket, world, tooltip, flags);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || !oldStack.func_77969_a(newStack);
    }
}

