/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.item;

import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.Enchants;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.impl.ItemBase;

public class UnenchantableItemBase
extends ItemBase {
    protected UnenchantableItemBase(String gid, String oid, boolean hidden, Item.Properties ip) {
        super(gid, oid, hidden, ip);
    }

    protected UnenchantableItemBase(String oid, boolean hidden, Item.Properties ip) {
        super(oid, hidden, ip);
    }

    protected UnenchantableItemBase(String oid, Item.Properties ip) {
        this(oid, false, ip);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int getItemEnchantability(ItemStack stack) {
        return 0;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment e) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    protected void addEndemicEnchantments(ItemStack stack) {
    }

    @Override
    public ItemStack createInstance(Item item, int amount) {
        ItemStack out = super.createInstance(item, amount);
        this.addEndemicEnchantments(out);
        return out;
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        Item item = stack.func_77973_b();
        if (item == this) {
            if (!stack.func_77948_v()) {
                this.addEndemicEnchantments(stack);
            }
            if (this.enforceNoEnchantments(stack)) {
                Enchants.removeEnchantments(stack);
            }
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this._glimmer != null ? this._glimmer : false;
    }

    @Override
    public Rarity func_77613_e(ItemStack stack) {
        return this._rarity != null && this._rarity.ordinal() > Rarity.COMMON.ordinal() ? this._rarity : Rarity.COMMON;
    }

    protected boolean enforceNoEnchantments(ItemStack stack) {
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity holder, int slot, boolean selected) {
        if (SharedGlue.isaServerWorld((IWorldReader)world) && this.enforceNoEnchantments(stack)) {
            Enchants.removeEnchantments(stack);
        }
    }
}

