/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.impl.network;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.impl.network.XyzMessage;

@ParametersAreNonnullByDefault
public class ParticleAtMessage
extends XyzMessage {
    private static final int _MAX_COUNT = 100;
    protected IParticleData _pData;
    protected int _count = 0;

    public ParticleAtMessage() {
    }

    public ParticleAtMessage(IParticleData p, double x, double y, double z, int count) {
        super(x, y, z);
        this._pData = p;
        this._count = Math.max(0, Math.min(100, count));
    }

    public ParticleAtMessage(IParticleData p, BlockPos at, int count) {
        this(p, at.func_177958_n(), at.func_177956_o(), at.func_177952_p(), count);
    }

    public ParticleAtMessage(IParticleData p, Vector3d at, int count) {
        this(p, at.func_82615_a(), at.func_82617_b(), at.func_82616_c(), count);
    }

    public ParticleAtMessage(PacketBuffer from) {
        super(from);
        this.deserialize_par(from);
    }

    public final IParticleData particle() {
        return this._pData;
    }

    public final int count() {
        return this._count;
    }

    protected void reset_par() {
        this._pData = ParticleTypes.field_197609_b;
        this._count = 0;
    }

    @Override
    protected void reset() {
        super.reset();
        this.reset_par();
    }

    public final <T extends ParticleAtMessage> T serialize_par(PacketBuffer to) {
        String idstring = "";
        if (this._pData != null && ForgeRegistries.PARTICLE_TYPES.containsValue((IForgeRegistryEntry)this._pData.func_197554_b())) {
            idstring = this._pData.func_197554_b().getRegistryName().toString();
        }
        to.func_180714_a(idstring);
        to.func_150787_b(Math.min(100, this._count));
        if (!idstring.isEmpty()) {
            this._pData.func_197553_a(to);
        }
        return (T)this;
    }

    public final void serialize_msg(PacketBuffer to) {
        this.serialize_xyz(to);
        this.serialize_par(to);
    }

    private <D extends IParticleData> D readParticle(PacketBuffer from, ParticleType<D> pT) {
        return (D)pT.func_197571_g().func_197543_b(pT, from);
    }

    public final <T extends ParticleAtMessage, D extends IParticleData> T deserialize_par(PacketBuffer from) {
        boolean reset = true;
        if (from != null) {
            String idstring = from.func_150789_c(Short.MAX_VALUE);
            this._count = Math.min(100, from.func_150792_a());
            if (!idstring.isEmpty()) {
                ResourceLocation rid = ResourceLocation.func_208304_a((String)idstring);
                if (rid != null && ForgeRegistries.PARTICLE_TYPES.containsKey(rid)) {
                    ParticleType pT = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(rid);
                    this._pData = this.readParticle(from, pT);
                    reset = false;
                } else {
                    throw new UnsupportedOperationException("Unregistered particle type: " + idstring);
                }
            }
        }
        if (reset) {
            this.reset_par();
        }
        return (T)this;
    }

    public static final ParticleAtMessage deserialize_msg(PacketBuffer from) {
        return new ParticleAtMessage(from);
    }
}

