/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.LivingEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.DayNightState;
import org.jwaresoftware.mcmods.lib.api.TimeFrame;
import org.jwaresoftware.mcmods.lib.api.WorldSeason;
import org.jwaresoftware.mcmods.lib.impl.almanac.AlmanacRolloverEventHandler;
import org.jwaresoftware.mcmods.lib.impl.almanac.DayOfWeek;
import org.jwaresoftware.mcmods.lib.impl.almanac.TimeSensitivity;
import org.jwaresoftware.mcmods.lib.impl.client.CarrotsLibClient;
import org.jwaresoftware.mcmods.lib.integration.DayNightHelper;
import org.jwaresoftware.mcmods.lib.integration.SeasonsHelper;

@ParametersAreNonnullByDefault
public final class AlmanacHelper {
    static SPILink _spiInstance = new SPILink(){};
    static boolean _LISTENER_INITED = false;

    public static final void initDefaults() {
        SeasonsHelper.initDefaults();
        DayNightHelper.initDefaults();
        LibInfo.LOG.debug("carrots/lib environ helper initialized(1/2)");
    }

    public static final void initConfigured(MinecraftServer minecraft) {
        boolean sumfin = SeasonsHelper.initConfigured(minecraft);
        if (sumfin && LibConfig.includeAlmanacTracking() && !_LISTENER_INITED) {
            MinecraftForge.EVENT_BUS.register((Object)new AlmanacRolloverEventHandler());
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> CarrotsLibClient::initConfigured);
            _LISTENER_INITED = true;
            LibInfo.LOG.debug("carrots/lib environ helper initialized(2/2)");
        }
    }

    public static final BlockPos safeLocation(World w) {
        return _spiInstance.seasonProvider().positionZero(w);
    }

    public static final BlockPos safeLocationOrSpawn(World w) {
        WorldSeason.Provider provider = _spiInstance.seasonProvider();
        return provider.locationSensitive(w) ? AlmanacHelper.safeLocation(w) : Locations.getSpawnPoint(w);
    }

    public static final WorldSeason getSeason(World w, BlockPos at) {
        return _spiInstance.seasonProvider().apply(w, at);
    }

    public static final WorldSeason getSeasonConservatively(World w, BlockPos at) {
        return Locations.isBlockLoaded((IBlockReader)w, at) ? _spiInstance.seasonProvider().apply(w, at) : WorldSeason.UNKNOWN;
    }

    public static final WorldSeason getSeason(World w) {
        return AlmanacHelper.getSeason(w, AlmanacHelper.safeLocation(w));
    }

    public static final boolean isNetherOrEnd(World w) {
        RegistryKey wk = w == null ? null : w.func_234923_W_();
        return wk == World.field_234919_h_ || wk == World.field_234920_i_;
    }

    public static final WorldSeason.Detailed getDetailedSeason(World w, BlockPos at, boolean conservatively) {
        WorldSeason.Detailed season;
        WorldSeason.Provider provider = _spiInstance.seasonProvider();
        if (at == null) {
            at = AlmanacHelper.safeLocation(w);
        }
        if (provider.hasDetailedSeasons() || AlmanacHelper.isNetherOrEnd(w) || provider.getSeasonCount(w) == 1) {
            season = provider.getDetailedSeason(w, at);
        } else if (conservatively && !Locations.isBlockLoaded((IBlockReader)w, at)) {
            season = WorldSeason.Detailed.UNKNOWN;
        } else {
            int sub_season_days;
            WorldSeason general = AlmanacHelper.getSeason(w, at);
            int day = AlmanacHelper.getSeasonDay(w);
            TimeFrame when = day <= (sub_season_days = AlmanacHelper.daysPerSeason(w) / 3) ? TimeFrame.EARLY : (day <= 2 * sub_season_days ? TimeFrame.MID : TimeFrame.LATE);
            season = new WorldSeason.Detailed(general, when);
        }
        return season;
    }

    public static final WorldSeason.Detailed getDetailedSeason(World w, BlockPos at) {
        return AlmanacHelper.getDetailedSeason(w, at, true);
    }

    public static final int daysPerSeason(World w) {
        return _spiInstance.seasonProvider().getSeasonDaysOrDefault(w);
    }

    public static final int getSeasonDay(World w) {
        return AlmanacHelper.getElapsedDays(w) % AlmanacHelper.daysPerSeason(w) + 1;
    }

    public static final int getSeasonDay(int currentDay, int daysPerSeason) {
        return currentDay <= 0 || daysPerSeason <= 0 ? 1 : (currentDay - 1) % daysPerSeason + 1;
    }

    public static final String getTranslationKey(World w, WorldSeason s) {
        return _spiInstance.seasonProvider().translationKey(w, s);
    }

    public static final IFormattableTextComponent getSeasonDisplayName(World w, WorldSeason s) {
        return new TranslationTextComponent(AlmanacHelper.getTranslationKey(w, s), new Object[]{s});
    }

    public static final int maxDaysPerFullYear() {
        return 1008;
    }

    public static final int daysPerFullYear(@Nullable World w) {
        return _spiInstance.seasonProvider().getFullYearDays(w);
    }

    public static final int getCurrentYear(World w) {
        long ticksperyear = AlmanacHelper.daysPerFullYear(w) * AlmanacHelper.ticksPerFullDay(w);
        int y = (int)Math.ceil((double)AlmanacHelper.__almanacNowTicks(w) / (double)ticksperyear);
        return y == 0 ? 1 : y;
    }

    public static final int getYearDay(World w) {
        return AlmanacHelper.getElapsedDays(w) % AlmanacHelper.daysPerFullYear(w) + 1;
    }

    public static final DayNightState getDayNightState(World w) {
        return AlmanacHelper.getDayNightState(w, AlmanacHelper.safeLocation(w));
    }

    public static final DayNightState getDayNightState(World w, BlockPos at) {
        return _spiInstance.daynightOracle().apply(w, at);
    }

    public static final DayNightState getDayNightStateConservatively(World w, BlockPos at) {
        return Locations.isBlockLoaded((IBlockReader)w, at) ? _spiInstance.daynightOracle().apply(w, at) : DayNightState.UNKNOWN;
    }

    public static final DayNightState.Detailed geDetailedDayNightState(World w, BlockPos at) {
        return _spiInstance.daynightOracle().getDetailedTimeOfDay(w, at);
    }

    static final long __almanacNowTicks(World w) {
        return _spiInstance.seasonProvider().nowTicks(w);
    }

    public static final int ticksPerFullDay(@Nullable World w) {
        return AlmanacHelper.ticksPerFullDay(_spiInstance.seasonProvider().bestID(w));
    }

    public static final int ticksPerFullDay(@Nonnull RegistryKey<World> w) {
        return _spiInstance.seasonProvider().ticksPerFullDay(w);
    }

    public static final int ticksPerFullDay() {
        return AlmanacHelper.ticksPerFullDay((RegistryKey<World>)World.field_234918_g_);
    }

    public static final int getDayElapsedTicks(World w, BlockPos at, int shift) {
        return (int)((AlmanacHelper.__almanacNowTicks(w) + (long)shift) % (long)AlmanacHelper.ticksPerFullDay(w) % Integer.MAX_VALUE);
    }

    public static final boolean isTimeOfDay(World w, BlockPos at, @Nonnull DayNightState state) {
        return _spiInstance.daynightOracle().matches(w, at, state);
    }

    public static final boolean isTimeOfDay(World w, @Nonnull DayNightState state) {
        return _spiInstance.daynightOracle().matches(w, AlmanacHelper.safeLocation(w), state);
    }

    public static final boolean isTimeOfDay(DayNightState have, @Nonnull DayNightState wanted) {
        return _spiInstance.daynightOracle().matches(have, wanted);
    }

    public static final int getElapsedDays(World w) {
        return AlmanacHelper.getElapsedDays(w, AlmanacHelper.__almanacNowTicks(w));
    }

    public static final int getCurrentDay(World w) {
        int d = (int)(Math.ceil((double)AlmanacHelper.__almanacNowTicks(w) / (double)AlmanacHelper.ticksPerFullDay(w)) % 2.147483647E9);
        return d == 0 ? 1 : d;
    }

    public static final int getOverworldCurrentDay(@Nullable MinecraftServer mc) {
        if (mc == null) {
            mc = SharedGlue.getMCServer();
        }
        return AlmanacHelper.getCurrentDay((World)Locations.getOverworld(mc));
    }

    public static final int getElapsedDays(World w, long ticks) {
        return (int)(ticks / (long)AlmanacHelper.ticksPerFullDay(w) % Integer.MAX_VALUE);
    }

    public static final int getElapsedAgeInDays(@Nonnull LivingEntity e, long ticksExisted) {
        if (!e.func_70089_S()) {
            return 999999;
        }
        ServerWorld wrt = Locations.getOverworld(e.func_184102_h());
        if (ticksExisted < 0L) {
            ticksExisted = e.field_70173_aa;
        }
        return AlmanacHelper.getElapsedDays((World)wrt, ticksExisted);
    }

    public static final long getOverworldNowTime(@Nullable MinecraftServer mc) {
        long now = 999999999L;
        if (mc == null) {
            mc = SharedGlue.getMCServer();
        }
        if (mc != null) {
            now = AlmanacHelper.getNowTime((World)mc.func_241755_D_());
        }
        return now;
    }

    public static final int getElapsedAgeInDays(@Nonnull TileEntity te, long ticksElapsed) {
        if (!te.func_145830_o()) {
            return 999999;
        }
        ServerWorld wrt = Locations.getOverworld(te.func_145831_w().func_73046_m());
        return AlmanacHelper.getElapsedDays((World)wrt, ticksElapsed);
    }

    public static final long getTicks(World w, TimeSensitivity relTo) {
        if (relTo != null && relTo != TimeSensitivity.NOW) {
            long TPD = AlmanacHelper.ticksPerFullDay(w);
            int currentDay = AlmanacHelper.getCurrentDay(w);
            long untilEOD = (long)currentDay * TPD - 1L;
            switch (relTo) {
                case EOD: {
                    return untilEOD;
                }
                case EOW: {
                    int m = DayOfWeek.LAST_DAY.index() - DayOfWeek.from(currentDay - 1).index();
                    return untilEOD + (long)m * TPD;
                }
                case EOS: {
                    int m = AlmanacHelper.daysPerSeason(w) - AlmanacHelper.getSeasonDay(w);
                    return untilEOD + (long)m * TPD;
                }
                case EOY: {
                    int m = AlmanacHelper.daysPerFullYear(w) - AlmanacHelper.getYearDay(w);
                    return untilEOD + (long)m * TPD;
                }
            }
        }
        return AlmanacHelper.__almanacNowTicks(w);
    }

    public static final long getTicksFromNow(World w, TimeSensitivity relTo) {
        long diff = 0L;
        if (relTo != null && relTo != TimeSensitivity.NOW) {
            diff = AlmanacHelper.getTicks(w, relTo) - AlmanacHelper.__almanacNowTicks(w);
        }
        return diff;
    }

    public static final long getNowTime(@Nonnull World w) {
        return AlmanacHelper.getTicks(w, TimeSensitivity.NOW);
    }

    public static final long getFutureTime(@Nonnull World world, long minDelayTicks, @Nonnull TimeSensitivity relTo) {
        return AlmanacHelper.getTicks(world, relTo) + minDelayTicks;
    }

    public static final long getFutureTime(@Nonnull World world, long minDelayTicks) {
        return AlmanacHelper.getNowTime(world) + minDelayTicks;
    }

    public static final long getCountdownTicksLeft(@Nonnull World world, long soonestTimeTicks) {
        return Math.max(0L, soonestTimeTicks - AlmanacHelper.getNowTime(world));
    }

    public static final boolean isBeforeTime(@Nonnull World world, long soonestTimeTicks) {
        boolean before = false;
        long now = AlmanacHelper.getNowTime(world);
        if (soonestTimeTicks > 0L && now < soonestTimeTicks) {
            before = true;
        }
        return before;
    }

    public static final boolean isAfterOrAtTime(@Nonnull World world, long soonestTimeTicks) {
        boolean after = true;
        long now = AlmanacHelper.getNowTime(world);
        if (now < soonestTimeTicks) {
            after = false;
        }
        return after;
    }

    private AlmanacHelper() {
    }

    public static interface SPILink {
        default public ModIntegration modid() {
            return ModIntegration.CARROTS_LIB;
        }

        default public WorldSeason.Provider seasonProvider() {
            return SeasonsHelper.get();
        }

        default public DayNightState.Provider daynightOracle() {
            return DayNightHelper.get();
        }
    }
}

