/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.integration.CuriosLinkImpl;

public final class BaublesHelper {
    static boolean ENABLED = false;
    static boolean INITED = false;
    static SPILink _spiInstance = new SPILink(){};

    public static final void initDefaults() {
        if (INITED) {
            return;
        }
        boolean allowed = LibConfig.allowBaublesAutoIntegration();
        if (allowed) {
            ModIntegration want = LibConfig.getPreferredBaublesImpl();
            if (want == ModIntegration.CARROTS_LIB) {
                want = ModIntegration.CURIOS.isLoaded() ? ModIntegration.CURIOS : (ModIntegration.BAUBLES.isLoaded() ? ModIntegration.BAUBLES : ModIntegration.MINECRAFT);
            }
            if (want == ModIntegration.CURIOS && ModIntegration.isLoadedAndValid(ModIntegration.CURIOS)) {
                _spiInstance = new CuriosLinkImpl();
                ENABLED = true;
                LibInfo.LOG.info("Registered Curios mod as primary baubles provider");
            }
        }
        LibInfo.LOG.debug("carrots/lib baubles helper initialized");
        INITED = true;
    }

    public static final void initFinalize() {
        _spiInstance.initFinalize();
    }

    public static final boolean isAnyExtensionPresent() {
        return ENABLED && ModIntegration.MINECRAFT != _spiInstance.modid();
    }

    public static final ItemStack findBauble(@Nonnull Predicate<ItemStack> test, @Nonnull LivingEntity wearer) {
        return _spiInstance.findBauble(test, wearer);
    }

    public static final void iterateBaubles(@Nonnull Function<OwnedBauble, Void> function, @Nonnull LivingEntity wearer) {
        _spiInstance.iterateBaubles(function, wearer);
    }

    public static final <T> T iterateBaubles(@Nonnull Function<OwnedBauble, T> function, @Nonnull LivingEntity wearer, T r) {
        return _spiInstance.iterateBaubles(function, wearer, r);
    }

    @Nullable
    public static final ICapabilityProvider genericAmuletWrap(ItemStack amulet) {
        return _spiInstance.wrapAmuletImpl(amulet);
    }

    @Nullable
    public static final ICapabilityProvider genericNecklaceWrap(ItemStack necklace) {
        return _spiInstance.wrapNecklaceImpl(necklace);
    }

    @Nullable
    public static final ICapabilityProvider wearableWrap(ItemStack wearable) {
        if (!(wearable.func_77973_b() instanceof WearableBaubleCallback)) {
            throw new IllegalArgumentException("Wearable bauble item MUST implement BaublesHelper.WearableBaubleCallback");
        }
        return _spiInstance.wrapWearableImpl(wearable);
    }

    public static interface SPILink {
        default public ModIntegration modid() {
            return ModIntegration.MINECRAFT;
        }

        default public void initFinalize() {
        }

        default public ItemStack findBauble(@Nonnull Predicate<ItemStack> test, @Nonnull LivingEntity wearer) {
            return ItemStack.field_190927_a;
        }

        default public void iterateBaubles(@Nonnull Function<OwnedBauble, Void> task, @Nonnull LivingEntity wearer) {
        }

        default public <T> T iterateBaubles(@Nonnull Function<OwnedBauble, T> task, @Nonnull LivingEntity wearer, T r) {
            return r;
        }

        @Nullable
        default public ICapabilityProvider wrapAmuletImpl(ItemStack amulet) {
            return null;
        }

        @Nullable
        default public ICapabilityProvider wrapNecklaceImpl(ItemStack necklace) {
            return null;
        }

        @Nullable
        default public ICapabilityProvider wrapWearableImpl(ItemStack wearable) {
            return null;
        }
    }

    public static interface WearableBaubleCallback {
        @OnlyIn(value=Dist.CLIENT)
        public Object doCreateWearableBaubleModel(ModIntegration var1);

        @Nonnull
        public ResourceLocation getWearableBaubleTexture(ModIntegration var1);

        default public void doWearableBaubleUpdateTick(String type, int index, @Nonnull LivingEntity wearer, ItemStack it) {
        }
    }

    public static final class OwnedBauble {
        @Nonnull
        public final LivingEntity owner;
        @Nonnull
        public final ItemStack bauble;
        public Object ticket;

        OwnedBauble(LivingEntity wearer, ItemStack stack) {
            this.owner = wearer;
            this.bauble = stack;
        }

        OwnedBauble(LivingEntity wearer, ItemStack stack, Object r) {
            this(wearer, stack);
            this.ticket = r;
        }
    }
}

