/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.World;
import org.apache.commons.lang3.ClassUtils;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.TemperatureRange;
import org.jwaresoftware.mcmods.lib.api.WorldSeason;
import org.jwaresoftware.mcmods.lib.integration.SereneSeasonsLinkImpl;

public final class SeasonsHelper {
    static final WorldSeason.Provider DISABLED_ALMANAC = new WorldSeason.Provider(){

        @Override
        public BlockPos positionZero(World w) {
            return BlockPos.field_177992_a;
        }

        @Override
        public int ticksPerFullDay(RegistryKey<World> w) {
            return SharedGlue.DEFAULT_TICKS_PER_FULL_DAYNIGHT_CYCLE();
        }

        @Override
        public int ticksInDaytime(RegistryKey<World> w) {
            return SharedGlue.DEFAULT_TICKS_DAY_TIME();
        }

        @Override
        public int getSeasonCount(World w) {
            return 1;
        }

        @Override
        public int getSeasonDays(World w) {
            return 20160;
        }

        @Override
        public int getFullYearDays(World w) {
            return 20160;
        }

        @Override
        public WorldSeason apply(World w, BlockPos p) {
            return WorldSeason.UNKNOWN;
        }

        @Override
        public TemperatureRange getTemperature(World w, BlockPos at) {
            return TemperatureRange.FREEZING;
        }

        @Override
        public String translationKey(World w, WorldSeason s) {
            return "carrots:null";
        }
    };
    static final WorldSeason.Provider UNCHANGING_BIOME_ALMANAC = new WorldSeason.Provider(){

        @Override
        public int getSeasonCount(World w) {
            return 1;
        }

        @Override
        public int getSeasonDays(World w) {
            return 336;
        }

        @Override
        public int getFullYearDays(World w) {
            return 336;
        }

        @Override
        public WorldSeason apply(World w, BlockPos p) {
            return WorldSeason.fromBiome((IBiomeReader)w, p);
        }

        @Override
        public String translationKey(World w, WorldSeason s) {
            return s.getTranslationKey();
        }
    };
    static final Supplier<WorldSeason.Provider> UNCHANGING_s = () -> UNCHANGING_BIOME_ALMANAC;
    private static final Map<String, WorldSeason.Provider> _IMPLS = (Map)Util.func_200696_a(new HashMap(), m -> {
        m.put("*DEFAULT*", WorldSeason.BY_CONFIGURED_ALMANAC);
        m.put("config", WorldSeason.BY_CONFIGURED_ALMANAC);
        m.put("84x4", WorldSeason.BY_84DAY_4SEASON_ALMANAC);
        m.put("sereneseasons", WorldSeason.BY_84DAY_4SEASON_ALMANAC);
        m.put("biome", UNCHANGING_BIOME_ALMANAC);
        m.put("disabled", DISABLED_ALMANAC);
    });
    static WorldSeason.Provider _spiInstance = DISABLED_ALMANAC;

    static final void initDefaults() {
        ModIntegration want = LibConfig.getPreferredEnvironImpl();
        if (want == ModIntegration.CARROTS_LIB) {
            want = ModIntegration.SERENE_SEASONS.isLoaded() ? ModIntegration.SERENE_SEASONS : ModIntegration.MINECRAFT;
        }
        if (want == ModIntegration.SERENE_SEASONS && ModIntegration.isLoadedAndValid(ModIntegration.SERENE_SEASONS)) {
            _spiInstance = new OverridingProvider(WorldSeason::isTheNetherOrTheEnd, UNCHANGING_s, new SereneSeasonsLinkImpl());
            LibInfo.LOG.info("Setting Serene Seasons mod as default season provider");
        } else {
            String id = LibConfig.getPreferredAlmanacImpl();
            WorldSeason.Provider picked = _IMPLS.get(id);
            if (picked == null || picked == DISABLED_ALMANAC) {
                _spiInstance = DISABLED_ALMANAC;
                LibInfo.LOG.info("Setting default season provider ({}) as disabled/no-op", (Object)id);
            } else {
                _spiInstance = new OverridingProvider(WorldSeason::isTheNetherOrTheEnd, UNCHANGING_s, picked);
                LibInfo.LOG.info("Setting {} builtin as default season provider", (Object)id);
            }
        }
    }

    static final boolean initConfigured(MinecraftServer minecraft) {
        boolean track;
        boolean bl = track = LibConfig.includeAlmanacTracking() && _spiInstance != DISABLED_ALMANAC;
        if (track) {
            UNCHANGING_BIOME_ALMANAC.initConfigured(minecraft);
            _spiInstance.initConfigured(minecraft);
        } else {
            _spiInstance = DISABLED_ALMANAC;
            LibInfo.LOG.info("Season provider and tracking is disabled (not required by any mod) [FINAL]");
        }
        return track;
    }

    @Nonnull
    static final WorldSeason.Provider get() {
        return _spiInstance;
    }

    public static final WorldSeason.Provider set(WorldSeason.Provider impl) {
        if (impl == null) {
            impl = DISABLED_ALMANAC;
        }
        WorldSeason.Provider prevInstance = _spiInstance;
        _spiInstance = impl;
        LibInfo.LOG.info("Changing library season provider to " + ClassUtils.getShortCanonicalName(impl.getClass()));
        return prevInstance;
    }

    public static class OverridingProvider
    implements WorldSeason.Provider {
        private final Predicate<RegistryKey<World>> _check;
        private final Supplier<WorldSeason.Provider> _alt;
        private final WorldSeason.Provider _impl;

        public OverridingProvider(Predicate<RegistryKey<World>> test, Supplier<WorldSeason.Provider> altimpl, WorldSeason.Provider realimpl) {
            this._check = test;
            this._impl = realimpl;
            this._alt = altimpl;
        }

        public OverridingProvider(Predicate<RegistryKey<World>> test, Supplier<WorldSeason.Provider> altimpl) {
            this(test, altimpl, _spiInstance);
        }

        @Override
        public final void initConfigured(MinecraftServer minecraft) {
            this._impl.initConfigured(minecraft);
        }

        @Override
        public boolean locationSensitive(World w) {
            return this._impl.locationSensitive(w);
        }

        @Override
        public long nowTicks(World w) {
            return this._check(w) ? this._alt.get().nowTicks(w) : this._impl.nowTicks(w);
        }

        @Override
        public int ticksPerFullDay(RegistryKey<World> w) {
            return this._check.test(w) ? this._alt.get().ticksPerFullDay(w) : this._impl.ticksPerFullDay(w);
        }

        @Override
        public int ticksInDaytime(RegistryKey<World> w) {
            return this._check.test(w) ? this._alt.get().ticksInDaytime(w) : this._impl.ticksInDaytime(w);
        }

        @Override
        public int getSeasonCount(World w) {
            return this._check(w) ? this._alt.get().getSeasonCount(w) : this._impl.getSeasonCount(w);
        }

        @Override
        public int getSeasonDays(World w) {
            return this._check(w) ? this._alt.get().getSeasonDays(w) : this._impl.getSeasonDays(w);
        }

        @Override
        public int getSeasonDaysOrDefault(World w) {
            return this._check(w) ? this._alt.get().getSeasonDays(w) : this._impl.getSeasonDaysOrDefault(w);
        }

        @Override
        public int getFullYearDays(World w) {
            return this._check(w) ? this._alt.get().getFullYearDays(w) : this._impl.getFullYearDays(w);
        }

        @Override
        public TemperatureRange getTemperature(World w, BlockPos at) {
            return this._check(w) ? this._alt.get().getTemperature(w, at) : this._impl.getTemperature(w, at);
        }

        @Override
        public String translationKey(@Nullable World w, WorldSeason s) {
            return w != null && this._check(w) ? this._alt.get().translationKey(w, s) : this._impl.translationKey(w, s);
        }

        @Override
        public WorldSeason apply(World w, BlockPos p) {
            return this._check(w) ? this._alt.get().apply(w, p) : this._impl.apply(w, p);
        }

        protected final boolean _check(World w) {
            return this._check.test((RegistryKey<World>)(w == null ? null : w.func_234923_W_()));
        }
    }
}

