/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import java.util.Locale;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.TimeFrame;
import org.jwaresoftware.mcmods.lib.api.WorldSeason;
import sereneseasons.api.SSGameRules;
import sereneseasons.api.config.ISyncedOption;
import sereneseasons.api.config.SeasonsOption;
import sereneseasons.api.config.SyncedConfig;
import sereneseasons.api.season.ISeasonState;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;

public final class SereneSeasonsLinkImpl
implements WorldSeason.Provider {
    private static final int _SS_SEASONS = 4;
    private static final String[] _NAMES_LC = (String[])Stream.of(Season.values()).map(s -> s.name().toLowerCase(Locale.ROOT)).toArray(String[]::new);
    private int __day1TickOffset;

    @Override
    public void initConfigured(MinecraftServer minecraft) {
        int ticksperday;
        World w = null;
        for (World next : minecraft.func_212370_w()) {
            if (next.func_234923_W_() != World.field_234918_g_) continue;
            w = next;
            break;
        }
        int offset = 0;
        boolean ss = SharedGlue.isaServerWorld(w);
        if (w != null) {
            ISeasonState sd = SeasonHelper.getSeasonState(w);
            offset = SyncedConfig.getIntValue((ISyncedOption)SeasonsOption.STARTING_SUB_SEASON);
            if (offset > 0) {
                offset = (offset - 1) * sd.getSubSeasonDuration();
            } else {
                offset = 0;
                LibInfo.LOG.fatal("Serene Seasons starting sub-season is random; ALMANACS WILL BE OUT-OF-SYNC!");
            }
        }
        this.__day1TickOffset = offset;
        if (ss && LibConfig.__ticksPerFullDay() > 0 && (ticksperday = SyncedConfig.getIntValue((ISyncedOption)SeasonsOption.DAY_DURATION)) != LibConfig.__ticksPerFullDay()) {
            LibInfo.LOG.error("Serene Seasons ticks per day differs from Carrots Library configuration; ALMANACS WILL BE OUT-OF-SYNC!");
        }
        if (ss && !w.func_82736_K().func_223586_b(SSGameRules.RULE_DOSEASONCYCLE)) {
            LibInfo.LOG.fatal("Serene Seasons season-cycling is disabled; ALMANACS WILL BE OUT-OF-SYNC!");
        }
    }

    @Override
    public long nowTicks(World w) {
        return SharedGlue.tickingTime(w) + (long)this.__day1TickOffset;
    }

    @Override
    public final int ticksPerFullDay(RegistryKey<World> w) {
        if (w == null) {
            return LibConfig.__ticksPerFullDay();
        }
        return SyncedConfig.getIntValue((ISyncedOption)SeasonsOption.DAY_DURATION);
    }

    @Override
    @Nonnull
    public final WorldSeason apply(World w, BlockPos p) {
        ISeasonState sd = SeasonHelper.getSeasonState((World)w);
        return WorldSeason.fromFast(_NAMES_LC[sd.getSeason().ordinal()]);
    }

    @Override
    public final boolean hasDetailedSeasons() {
        return true;
    }

    @Override
    public final WorldSeason.Detailed getDetailedSeason(World w, BlockPos p) {
        TimeFrame when;
        ISeasonState sd = SeasonHelper.getSeasonState((World)w);
        switch (sd.getSubSeason()) {
            case EARLY_AUTUMN: 
            case EARLY_SPRING: 
            case EARLY_SUMMER: 
            case EARLY_WINTER: {
                when = TimeFrame.EARLY;
                break;
            }
            case LATE_AUTUMN: 
            case LATE_SPRING: 
            case LATE_SUMMER: 
            case LATE_WINTER: {
                when = TimeFrame.LATE;
                break;
            }
            default: {
                when = TimeFrame.MID;
            }
        }
        return new WorldSeason.Detailed(this.apply(w, p), when);
    }

    @Override
    public final int getSeasonDays(World w) {
        ISeasonState sd = SeasonHelper.getSeasonState((World)w);
        return sd.getSeasonDuration() / sd.getDayDuration();
    }

    @Override
    public final int getFullYearDays(World w) {
        return this.getSeasonDays(w) * 4;
    }

    @Override
    public int getSeasonCount(World w) {
        return 4;
    }
}

