/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.jwaresoftware.mcmods.lib.api.TemperatureRange;

public class Temperature
implements DoubleSupplier,
Supplier<TemperatureRange> {
    public static final double BIOME_BASELINE_TEMPERATURE = 0.75;
    public double value;
    @Nonnull
    public TemperatureRange range;

    public static final <T extends Temperature> T set(T t, double value) {
        t.value = value;
        t.range = TemperatureRange.match(value);
        return t;
    }

    public Temperature(double t) {
        Temperature.set(this, t);
    }

    public Temperature() {
        this.reset();
    }

    public <T extends Temperature> T set(double t) {
        Temperature.set(this, t);
        return (T)this;
    }

    public final <T extends Temperature> T reset() {
        return this.set(this.startingValue());
    }

    protected double startingValue() {
        return 0.75;
    }

    public double value() {
        return this.value;
    }

    @Override
    public final double getAsDouble() {
        return this.value();
    }

    @Override
    public final TemperatureRange get() {
        return Objects.requireNonNull(this.range);
    }

    public String toString() {
        return String.format(".2f", this.value());
    }
}

