/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.FoodStats;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;

final class WellnessHardcore {
    static final int _DEHYDRATION_CHECK_MODULO = SharedGlue.SECS_TO_TICKS_DURATION_MULTIPLIER() * 5;

    WellnessHardcore() {
    }

    static final void initFinalize() {
        boolean enabled;
        WellnessHelper.SPILink provider = WellnessHelper._spiInstance;
        boolean bl = enabled = WellnessHelper.ENABLED && !provider.disableHardcoreTweaks() && LibConfig.hardcoreSurvivalMechanics();
        if (enabled && provider.manageThirst() && provider.manageEnergy()) {
            MinecraftForge.EVENT_BUS.register((Object)new EventsHandler());
        }
    }

    static final class EventsHandler {
        EventsHandler() {
        }

        static final boolean checkMechanics(LivingEntity target) {
            World world = target.func_130014_f_();
            return SharedGlue.isaServerWorld((IWorldReader)world) && !SharedGlue.isLightweightDifficulty((IWorld)world);
        }

        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void onPlayerWakeupDiminishFood(PlayerWakeUpEvent e) {
            if (EventsHandler.checkMechanics((LivingEntity)e.getPlayer()) && !e.updateWorld()) {
                try {
                    int _1 = SharedGlue.PLAYER_ONE_FOOD_LEVEL();
                    e.getPlayer().func_130014_f_().func_217369_A().forEach(player -> {
                        FoodStats stats = player.func_71024_bL();
                        int fL = stats.func_75116_a();
                        if (fL > _1) {
                            int hunger = Math.min(fL, 2 * _1);
                            stats.func_75122_a(-hunger, 0.5f);
                        } else if (player.func_130014_f_().func_175659_aa() == Difficulty.HARD || !player.func_70644_a(SharedGlue.Potion_hunger)) {
                            Potions.addPotionEffect((LivingEntity)player, SharedGlue.Potion_hunger, 60, 1);
                        }
                    });
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }
}

