/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.integration;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.api.IDrink;
import org.jwaresoftware.mcmods.lib.api.INutritionSource;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.lib.impl.effects.EnergizedEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.NourishmentEffect;
import org.jwaresoftware.mcmods.lib.integration.NNHelper;
import org.jwaresoftware.mcmods.lib.integration.WellnessHardcore;

@ParametersAreNonnullByDefault
public final class WellnessHelper {
    static SPILink _spiInstance = new SPILink(){};
    static boolean INITED = false;
    static boolean INITED_FOODMGMT = false;
    static boolean INITED_LINING = false;
    static boolean INITED_PORTPAKS = false;
    static boolean ENABLED = false;
    @Nonnull
    static Effect FOOD_WARMING = Potions.NO_EFFECT;
    @Nonnull
    static Effect FOOD_COOLING = Potions.NO_EFFECT;
    @Nonnull
    static Effect FOOD_HYDRATE = Potions.NO_EFFECT;
    @Nonnull
    static Effect FOOD_WELLFED = Potions.NO_EFFECT;
    @Nonnull
    static Effect FOOD_STAMINA = Potions.NO_EFFECT;

    public static final boolean isEnabled() {
        return ENABLED;
    }

    public static final void initDefaults() {
        if (INITED) {
            return;
        }
        NourishmentEffect.initDefaults();
        LibInfo.LOG.debug("carrots/lib wellness nutrition effects initialized");
        boolean allowed = LibConfig.allowWellbeingAutoIntegration();
        NNHelper.initDefaults(allowed);
        INITED = true;
    }

    public static final void initFoodManagement(@Nonnull Effect warming, @Nonnull Effect cooling, @Nullable Effect hydrating, @Nullable Effect satiating) {
        WellnessHelper.initDefaults();
        if (INITED_FOODMGMT) {
            return;
        }
        INITED_FOODMGMT = true;
        Validate.isTrue((!Potions.isEmpty(warming) ? 1 : 0) != 0, (String)"Food warming indicator potion is required", (Object[])new Object[0]);
        Validate.isTrue((!Potions.isEmpty(cooling) ? 1 : 0) != 0, (String)"Food cooling indicator potion is required", (Object[])new Object[0]);
        Validate.isTrue((warming != cooling ? 1 : 0) != 0, (String)"Temperature indicator potions MUST be different from each other", (Object[])new Object[0]);
        if (ENABLED) {
            FOOD_WARMING = warming;
            FOOD_COOLING = cooling;
            if (hydrating != null) {
                FOOD_HYDRATE = hydrating;
            }
            if (satiating != null) {
                FOOD_WELLFED = satiating;
            }
        }
    }

    public static final void initArmorLining() {
        WellnessHelper.initDefaults();
        if (INITED_LINING) {
            return;
        }
        INITED_LINING = true;
    }

    public static final void initPortablePaks() {
        WellnessHelper.initDefaults();
        if (INITED_PORTPAKS) {
            return;
        }
        INITED_PORTPAKS = true;
    }

    public static final void initFinalize() {
        NourishmentEffect.initFinalize();
        if (FOOD_HYDRATE == Potions.NO_EFFECT) {
            FOOD_HYDRATE = NourishmentEffect.getOrNone("hydration");
        }
        if (FOOD_WELLFED == Potions.NO_EFFECT) {
            FOOD_WELLFED = NourishmentEffect.getOrNone("well_fed");
        }
        if (FOOD_STAMINA == Potions.NO_EFFECT) {
            FOOD_STAMINA = NourishmentEffect.getOrNone("endurance");
        }
        NNHelper.initFinalize();
        _spiInstance.initFinalize();
        if (ENABLED) {
            WellnessHardcore.initFinalize();
        }
    }

    public static final boolean isAnyExtensionPresent() {
        return ENABLED && ModIntegration.MINECRAFT != _spiInstance.modid();
    }

    public static final boolean manageThirst() {
        return ENABLED && _spiInstance.manageThirst();
    }

    public static final boolean manageWater() {
        return ENABLED && _spiInstance.manageWater();
    }

    public static final boolean manageNutrition() {
        return NNHelper.ENABLED;
    }

    public static final boolean manageTemperature() {
        return ENABLED && _spiInstance.manageTemperature();
    }

    public static final boolean manageEnergy() {
        return ENABLED && _spiInstance.manageEnergy();
    }

    public static final boolean isThirsty(@Nullable World world, LivingEntity target) {
        return _spiInstance.isThirsty(world, target);
    }

    public static final boolean quenchThirst(LivingEntity target, IDrink drink, ItemStack with) {
        return WellnessHelper.quenchThirst(target, drink.getThirstQuenched(with), drink.getHydrationAdded(with), drink.getThirstTriggerChance(with, target));
    }

    public static final boolean quenchThirst(LivingEntity target, float quenchPts, float hydration, float impurityChance) {
        return _spiInstance.quenchThirst(target, quenchPts, hydration, impurityChance);
    }

    public static final boolean hydrateFor(int duration_secs, LivingEntity target) {
        boolean hydrated = false;
        if (FOOD_HYDRATE != Potions.NO_EFFECT) {
            hydrated = target.func_195064_c(Potions.newHiddenPotionTypeEffect(FOOD_HYDRATE, duration_secs, 0));
        }
        return hydrated;
    }

    public static final boolean isAtExtremeTemperature(LivingEntity target, boolean hot) {
        return _spiInstance.isAtExtremeTemperature(target, hot);
    }

    public static final boolean coolIfHot(LivingEntity target, int instantCooldown, int ongoingTimesecs, int fortifyTimesecs) {
        return _spiInstance.coolIfHot(target, instantCooldown, ongoingTimesecs, fortifyTimesecs);
    }

    public static final boolean coolIfHot(LivingEntity target, int instantCooldown, int ongoingTimesecs) {
        return WellnessHelper.coolIfHot(target, instantCooldown, ongoingTimesecs, -1);
    }

    public static final boolean warmIfCold(LivingEntity target, int instantWarmup, int ongoingTimesecs, int fortifyTimesecs) {
        return _spiInstance.warmIfCold(target, instantWarmup, ongoingTimesecs, fortifyTimesecs);
    }

    public static final boolean warmIfCold(LivingEntity target, int instantWarmup, int ongoingTimesecs) {
        return WellnessHelper.warmIfCold(target, instantWarmup, ongoingTimesecs, -1);
    }

    public static final boolean applyTemperatureRelief(ItemStack from, ITemperatureChangeable t_cap, PlayerEntity player) {
        boolean applied = false;
        if (WellnessHelper.manageTemperature()) {
            if (t_cap == null && from.func_77973_b() instanceof ITemperatureChangeable) {
                t_cap = (ITemperatureChangeable)from.func_77973_b();
            }
            if (t_cap != null) {
                int modifier = t_cap.getTemperatureModifier(from);
                if (t_cap.hasBonusTemperature(from)) {
                    int ongoingTimesecs = t_cap.getBonusTemperatureTimeLeftForApply(from, -1);
                    applied = t_cap.isHeated(from) ? WellnessHelper.warmIfCold((LivingEntity)player, modifier, ongoingTimesecs) : WellnessHelper.coolIfHot((LivingEntity)player, modifier, ongoingTimesecs);
                } else if (t_cap.isNaturallyCooling(from)) {
                    int ongoingTimesecs = t_cap.getCoolDuration(from);
                    applied = WellnessHelper.coolIfHot((LivingEntity)player, modifier, ongoingTimesecs);
                }
            }
        }
        return applied;
    }

    public static final boolean applyTemperatureRelief(ItemStack from, @Nonnull PlayerEntity player) {
        return WellnessHelper.applyTemperatureRelief(from, null, player);
    }

    public static final boolean isFatigued(LivingEntity target) {
        return _spiInstance.isFatigued(target);
    }

    public static final boolean isAtExtremeFatigue(LivingEntity target) {
        return _spiInstance.isAtExtremeFatigue(target);
    }

    public static final boolean rejuvenateIfTired(LivingEntity target, boolean rested, int instantEnergy, int ongoingTimesecs) {
        return _spiInstance.setEnergy(target, instantEnergy, ongoingTimesecs, rested, false);
    }

    public static final boolean rejuvenateIfTired(LivingEntity target, int instantEnergy, int ongoingTimesecs) {
        return _spiInstance.setEnergy(target, instantEnergy, ongoingTimesecs, false, false);
    }

    public static final void weakenFromDehydration(LivingEntity target, int instantEnergyLoss) {
        _spiInstance.setEnergy(target, -instantEnergyLoss, -1, false, false);
    }

    public static final void addEnergizedEffects(Item food, int secs, int amplifier) {
        _spiInstance.addEnergizedEffects(food, secs, amplifier);
    }

    public static final boolean isHardDifficultyScaled(LivingEntity target) {
        World w = target.func_130014_f_();
        float health = target.func_110143_aJ() / target.func_110138_aP();
        switch (w.func_175659_aa()) {
            case HARD: {
                return true;
            }
            case NORMAL: {
                return health > 0.6f;
            }
            case EASY: {
                return health > 0.85f;
            }
        }
        return false;
    }

    public static final void noteItemConsumed(LivingEntity by, ItemStack consumed, INutritionSource nn) {
        NNHelper._spiInstance.noteItemConsumed(by, consumed, nn);
    }

    private WellnessHelper() {
    }

    @ParametersAreNonnullByDefault
    public static interface SPILink {
        default public ModIntegration modid() {
            return ModIntegration.MINECRAFT;
        }

        default public void initFinalize() {
        }

        default public boolean disableHardcoreTweaks() {
            return false;
        }

        default public boolean manageThirst() {
            return false;
        }

        default public boolean manageWater() {
            return this.manageThirst();
        }

        default public boolean manageTemperature() {
            return false;
        }

        default public boolean manageEnergy() {
            return false;
        }

        default public float liquidTypeAdjustment(float thirstAmount) {
            return 1.0f;
        }

        default public boolean isThirsty(@Nullable World world, LivingEntity entity) {
            return false;
        }

        default public boolean quenchThirst(LivingEntity entity, float thirstPts, float hydration, float impurityChance) {
            return false;
        }

        default public boolean isAtExtremeTemperature(LivingEntity entity, boolean hot) {
            return false;
        }

        default public boolean coolIfHot(LivingEntity entity, int instantCooldown, int ongoingTimesecs, int fortifyTimesecs) {
            return false;
        }

        default public boolean warmIfCold(LivingEntity entity, int instantWarmup, int ongoingTimesecs, int fortifyTimesecs) {
            return false;
        }

        default public boolean isFatigued(LivingEntity entity) {
            return entity.func_110143_aJ() / entity.func_110138_aP() < 0.1f;
        }

        default public boolean isAtExtremeFatigue(LivingEntity entity) {
            return this.isFatigued(entity);
        }

        default public boolean setEnergy(LivingEntity entity, int instantAmount, int ongoingTimesecs, boolean fromResting, boolean fromSugar) {
            return false;
        }

        default public void addEnergizedEffects(Item food, int secs, int amplifier) {
            Potions.addPotionEffect(food, EnergizedEffect.get(), secs, amplifier, 1.0f);
        }
    }
}

