/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.IntClamper;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.Loot;

public final class ApplyClampedBonusFunction
extends LootFunction {
    private static final int _64 = SharedGlue.VANILLA_MAX_STACK_SIZE();
    @Nonnull
    final IntClamper _limits;
    @Nonnull
    final Enchantment[] _enchants;

    ApplyClampedBonusFunction(ILootCondition[] conditions, IntClamper limits, @Nullable Enchantment[] enchants) {
        super(conditions);
        Enchantment[] enchantmentArray;
        this._limits = limits;
        if (enchants == null) {
            Enchantment[] enchantmentArray2 = new Enchantment[1];
            enchantmentArray = enchantmentArray2;
            enchantmentArray2[0] = Enchantments.field_185308_t;
        } else {
            enchantmentArray = enchants;
        }
        this._enchants = enchantmentArray;
    }

    @Nullable
    private EnchantmentData match(ItemStack held) {
        if (!ItemStacks.isEmpty(held)) {
            for (Enchantment e : this._enchants) {
                int level = EnchantmentHelper.func_77506_a((Enchantment)e, (ItemStack)held);
                if (level <= 0) continue;
                return new EnchantmentData(e, Math.min(level, 10));
            }
        }
        return null;
    }

    private int clamped(int n) {
        return (n = this._limits.applyAsInt(n)) < 0 ? 0 : (n > _64 ? _64 : n);
    }

    public LootFunctionType func_230425_b_() {
        return CarrotsLootTypes.Functions.APPLY_BONUS;
    }

    public ItemStack func_215859_a(ItemStack in, LootContext context) {
        ItemStack held;
        EnchantmentData e;
        ItemStack out = in;
        if (!in.func_190926_b() && (e = this.match(held = (ItemStack)context.func_216031_c(LootParameters.field_216289_i))) != null) {
            int multiplier = context.func_216032_b().nextInt(e.field_76303_c + 2) - 1;
            if (multiplier > 0) {
                int n = in.func_190916_E() * (multiplier + 1);
                out = (n = this.clamped(n)) == 0 ? ItemStack.field_190927_a : Loot.resized(ItemStacks.copy1(in), n);
            } else {
                int min = this._limits.applyAsInt(in.func_190916_E());
                if (in.func_190916_E() < min) {
                    out = Loot.resized(ItemStacks.copy1(in), min);
                }
            }
        }
        return out;
    }

    public static final class Serializer
    extends LootFunction.Serializer<ApplyClampedBonusFunction> {
        private static final String _ERR_MSG = "Invalid or missing enchantment id(s); must be either id or array of ids of registered items.";
        private static final String _ENCH = "enchantment";

        public ApplyClampedBonusFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            Enchantment[] enchants = null;
            if (JSONUtils.func_151204_g((JsonObject)json, (String)_ENCH)) {
                if (JSONUtils.func_151205_a((JsonObject)json, (String)_ENCH)) {
                    ResourceLocation rid = ResourceLocation.func_208304_a((String)JSONUtils.func_151200_h((JsonObject)json, (String)_ENCH));
                    if (rid == null || !ForgeRegistries.ENCHANTMENTS.containsKey(rid)) {
                        throw new JsonSyntaxException(_ERR_MSG);
                    }
                    enchants = new Enchantment[]{(Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(rid)};
                } else {
                    if (!JSONUtils.func_151202_d((JsonObject)json, (String)_ENCH)) {
                        throw new JsonSyntaxException(_ERR_MSG);
                    }
                    JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)_ENCH);
                    ArrayList<Enchantment> e = new ArrayList<Enchantment>();
                    for (JsonElement jsonelement : jsonarray) {
                        ResourceLocation rid = ResourceLocation.func_208304_a((String)JSONUtils.func_151206_a((JsonElement)jsonelement, (String)_ENCH));
                        if (rid == null || !ForgeRegistries.ENCHANTMENTS.containsKey(rid)) {
                            throw new JsonSyntaxException(_ERR_MSG);
                        }
                        e.add((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(rid));
                    }
                    if (e.isEmpty()) {
                        throw new JsonSyntaxException(_ERR_MSG);
                    }
                    enchants = e.toArray(new Enchantment[0]);
                }
            }
            IntClamper limit = (IntClamper)JSONUtils.func_188174_a((JsonObject)json, (String)"clamp", (JsonDeserializationContext)deserializationContext, IntClamper.class);
            return new ApplyClampedBonusFunction(conditions, limit, enchants);
        }

        public void serialize(JsonObject object, ApplyClampedBonusFunction lfunction, JsonSerializationContext serializationContext) {
            super.func_230424_a_(object, (LootFunction)lfunction, serializationContext);
            object.add("clamp", serializationContext.serialize((Object)lfunction._limits));
            if (lfunction._enchants.length == 1) {
                object.add(_ENCH, serializationContext.serialize((Object)lfunction._enchants[0].getRegistryName().toString()));
            } else {
                JsonArray jsonarray = new JsonArray();
                for (Enchantment e : lfunction._enchants) {
                    jsonarray.add(serializationContext.serialize((Object)e.getRegistryName().toString()));
                }
                if (jsonarray.size() > 0) {
                    object.add(_ENCH, (JsonElement)jsonarray);
                }
            }
        }
    }
}

