/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import org.jwaresoftware.mcmods.lib.api.PropertyDefinition;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootParameters;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.Loot;

public class EarlyHarvestCountFunction
extends LootFunction {
    final int _n;
    final float _p;
    final int _maxage;
    final boolean _zeromiss;
    final int _maxcnt;
    final float _bonus_multiplier;
    @Nullable
    final LootContext.EntityTarget _e;

    public EarlyHarvestCountFunction(ILootCondition[] conditions, int n, float p, int maxage, int max, float bonus, boolean z, @Nullable LootContext.EntityTarget e) {
        super(conditions);
        this._n = n;
        this._p = p;
        this._maxcnt = max;
        this._bonus_multiplier = bonus;
        this._maxage = maxage;
        this._zeromiss = z;
        this._e = e;
    }

    public LootFunctionType func_230425_b_() {
        return CarrotsLootTypes.Functions.EARLY_HARVEST_COUNT;
    }

    private final boolean enough(int n) {
        return this._maxcnt <= 0 ? false : n >= this._maxcnt;
    }

    public ItemStack func_215859_a(ItemStack input, LootContext lc) {
        ItemStack out = input;
        if (!input.func_190926_b()) {
            BlockState harvested;
            PropertyDefinition age;
            int N = 0;
            if (this._e == null && (age = PropertyDefinition.getAgeFrom(harvested = (BlockState)lc.func_216031_c(LootParameters.field_216287_g), new String[0])) != null) {
                int maxage = this._maxage > 0 ? this._maxage : age.max_value;
                N = (int)((float)this._n * ((float)age.value / (float)maxage));
            }
            int n = 0;
            for (int i = 0; i < N; ++i) {
                if (!(lc.func_216032_b().nextFloat() < this._p)) continue;
                out.func_190917_f(1);
                if (this.enough(++n)) break;
            }
            if (this._bonus_multiplier > 0.0f && !this.enough(n)) {
                int bfl = lc.func_216033_a(CarrotsLootParameters.BETTER_FORTUNE) ? (Integer)lc.func_216031_c(CarrotsLootParameters.BETTER_FORTUNE) : Loot.getBetterFortuneOrLuck(lc);
                bfl = (int)(this._bonus_multiplier * (float)bfl);
                int m = lc.func_216032_b().nextInt(bfl + 1);
                while (m-- > 0) {
                    out.func_190917_f(1);
                    if (!this.enough(++n)) continue;
                }
            }
            if (n == 0 && this._zeromiss) {
                out = ItemStack.field_190927_a;
            }
        }
        return out;
    }

    public static class Serializer
    extends LootFunction.Serializer<EarlyHarvestCountFunction> {
        private static final String _FROM = "entity";

        public EarlyHarvestCountFunction deserialize(JsonObject json, JsonDeserializationContext context, ILootCondition[] conditions) {
            int n = JSONUtils.func_151203_m((JsonObject)json, (String)"n");
            float p = JSONUtils.func_151217_k((JsonObject)json, (String)"p");
            int maxage = JSONUtils.func_151208_a((JsonObject)json, (String)"max_age", (int)-1);
            boolean z = JSONUtils.func_151209_a((JsonObject)json, (String)"zero_miss", (boolean)false);
            int maxcnt = JSONUtils.func_151208_a((JsonObject)json, (String)"max", (int)-1);
            float bonus = JSONUtils.func_151221_a((JsonObject)json, (String)"bonus_multiplier", (float)-1.0f);
            LootContext.EntityTarget e = json.has(_FROM) ? (LootContext.EntityTarget)JSONUtils.func_188174_a((JsonObject)json, (String)_FROM, (JsonDeserializationContext)context, LootContext.EntityTarget.class) : null;
            return new EarlyHarvestCountFunction(conditions, n, p, maxage, maxcnt, bonus, z, e);
        }

        public void serialize(JsonObject json, EarlyHarvestCountFunction lfunction, JsonSerializationContext context) {
            super.func_230424_a_(json, (LootFunction)lfunction, context);
            json.addProperty("n", (Number)lfunction._n);
            json.addProperty("p", (Number)Float.valueOf(lfunction._p));
            if (lfunction._maxage > 0) {
                json.addProperty("max_age", (Number)lfunction._maxage);
            }
            json.addProperty("zero_miss", Boolean.valueOf(lfunction._zeromiss));
            if (lfunction._maxcnt > 0) {
                json.addProperty("max", (Number)lfunction._maxcnt);
            }
            if (lfunction._bonus_multiplier > 0.0f) {
                json.addProperty("bonus_multiplier", (Number)Float.valueOf(lfunction._bonus_multiplier));
            }
            if (lfunction._e != null) {
                json.add(_FROM, context.serialize((Object)lfunction._e));
            }
        }
    }
}

