/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.common.collect.Lists;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.Tags;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Whatis;

public abstract class EnchantCompatibleFunction
extends LootFunction {
    protected static final Random _RAND = new SecureRandom();

    public EnchantCompatibleFunction(ILootCondition[] conditions) {
        super(conditions);
    }

    static final boolean isSillyItem(ItemStack in) {
        return !in.func_190926_b() && in.func_77973_b().func_206844_a((ITag)Tags.Items.RODS) && !in.func_77948_v();
    }

    @Nonnull
    public static final List<EnchantmentData> getPossibilities(int xpLevel, boolean forBook, boolean allowTreasure, @Nonnull Iterable<Enchantment> from) {
        ArrayList<EnchantmentData> list = new ArrayList<EnchantmentData>(13);
        block0: for (Enchantment e : from) {
            if (!e.func_230310_i_() || !allowTreasure && e.func_185261_e() || forBook && !e.isAllowedOnBooks()) continue;
            for (int eLevel = e.func_77325_b(); eLevel > e.func_77319_d() - 1; --eLevel) {
                if (xpLevel < e.func_77321_a(eLevel) || xpLevel > e.func_223551_b(eLevel)) continue;
                list.add(new EnchantmentData(e, eLevel));
                continue block0;
            }
        }
        return list;
    }

    @Nonnull
    public static final List<EnchantmentData> buildRandomList(@Nonnull ItemStack target, int enchantability, int xpLevel, boolean allowTreasure, @Nullable Random rng, @Nonnull Iterable<Enchantment> from) {
        ArrayList<EnchantmentData> list = new ArrayList<EnchantmentData>(13);
        if (ItemStacks.isEmpty(target)) {
            return list;
        }
        boolean isBook = Whatis.isBlankBook(target.func_77973_b());
        if (enchantability < 0) {
            enchantability = target.getItemEnchantability();
            if (isBook && enchantability <= 0) {
                enchantability = 1;
            }
        }
        if (enchantability > 0) {
            if (rng == null) {
                rng = _RAND;
            }
            xpLevel += 1 + rng.nextInt(enchantability / 4 + 1) + rng.nextInt(enchantability / 4 + 1);
            float variance = (rng.nextFloat() + rng.nextFloat() - 1.0f) * 0.15f;
            List<EnchantmentData> possibles = EnchantCompatibleFunction.getPossibilities(xpLevel = MathHelper.func_76125_a((int)Math.round((float)xpLevel + (float)xpLevel * variance), (int)1, (int)Integer.MAX_VALUE), isBook, allowTreasure, from);
            if (!possibles.isEmpty()) {
                EnchantmentData d = (EnchantmentData)WeightedRandom.func_76271_a((Random)rng, possibles);
                if (d != null) {
                    list.add(d);
                }
                while (rng.nextInt(50) <= xpLevel) {
                    EnchantmentHelper.func_185282_a(possibles, (EnchantmentData)((EnchantmentData)list.get(list.size() - 1)));
                    if (possibles.isEmpty()) break;
                    d = (EnchantmentData)WeightedRandom.func_76271_a((Random)rng, possibles);
                    if (d != null) {
                        list.add(d);
                    }
                    xpLevel /= 2;
                }
            }
        }
        return list;
    }

    @Nullable
    public static final List<Enchantment> getSpecialItemsEnchantments(@Nullable ItemStack what, boolean silly_mode) {
        List<Enchantment> list = null;
        if (!ItemStacks.isEmpty(what)) {
            Item item = what.func_77973_b();
            if (Whatis.isSimpleShield(item) || item == Items.field_190929_cY) {
                list = Arrays.asList(SharedGlue.Enchantment_unbreaking, SharedGlue.Enchantment_mending, SharedGlue.Enchantment_projectile_protection, SharedGlue.Enchantment_blastProtection, SharedGlue.Enchantment_protection, SharedGlue.Enchantment_thorns, SharedGlue.Enchantment_vanishingCurse);
            } else if (Whatis.isNaturalFlightGear(item)) {
                list = Arrays.asList(SharedGlue.Enchantment_unbreaking, SharedGlue.Enchantment_mending, SharedGlue.Enchantment_protection, SharedGlue.Enchantment_vanishingCurse);
            } else if (Whatis.isSimpleShears(item)) {
                list = Arrays.asList(SharedGlue.Enchantment_unbreaking, SharedGlue.Enchantment_mending, SharedGlue.Enchantment_fortune, SharedGlue.Enchantment_fireAspect, SharedGlue.Enchantment_vanishingCurse);
            } else if (Whatis.isFlintAndSteel(item)) {
                list = Arrays.asList(SharedGlue.Enchantment_unbreaking, SharedGlue.Enchantment_mending, SharedGlue.Enchantment_fireAspect, SharedGlue.Enchantment_vanishingCurse);
            } else if (silly_mode && EnchantCompatibleFunction.isSillyItem(what)) {
                list = Arrays.asList(SharedGlue.Enchantment_knockback, SharedGlue.Enchantment_fireAspect, SharedGlue.Enchantment_fortune, SharedGlue.Enchantment_power, SharedGlue.Enchantment_baneOfArthropods, SharedGlue.Enchantment_unbreaking, SharedGlue.Enchantment_vanishingCurse);
            }
        }
        return list;
    }

    public static abstract class Serializer<K extends LootFunction>
    extends LootFunction.Serializer<K> {
        protected Serializer() {
        }
    }

    public static enum Profile {
        BOOK,
        WEAPON,
        TOOL,
        ARMOR,
        BOW("bows", 2),
        WINGS,
        HEAD,
        FEET,
        FISHROD("fishing_rods", 2),
        SHIELD("shields", 2),
        SPECIALARMOR("special_armor", 4),
        BAUBLE("baubles", 2);

        private static final List<SampleItem> _BOOK;
        private static final EnumMap<Profile, List<SampleItem>> _DEFAULTS;
        private static final EnumMap<Profile, List<SampleItem>> _DEFAULTS_BASE;
        private static final Profile[] _VALUES;
        @Nullable
        private final String _tag;
        private final int _tag_weight;

        public static final ItemStack example(@Nonnull Profile p, @Nullable Random rng, @Nullable EnumMap<Profile, List<SampleItem>> choices) {
            if (rng == null) {
                rng = _RAND;
            }
            if (choices == null) {
                choices = _DEFAULTS;
            }
            List<SampleItem> default_samples = _DEFAULTS.getOrDefault((Object)p, _BOOK);
            List<SampleItem> samples = choices.getOrDefault((Object)p, default_samples);
            return new ItemStack((IItemProvider)((SampleItem)WeightedRandom.func_76271_a((Random)rng, samples)).sampleitem);
        }

        public static final ItemStack example(@Nonnull Profile p, Random rand) {
            return Profile.example(p, rand, null);
        }

        @Nullable
        public static final Profile fromLString(@Nullable String s) {
            if (s != null) {
                s = s.toUpperCase(Locale.US);
                for (Profile p : _VALUES) {
                    if (!p.name().equals(s)) continue;
                    return p;
                }
            }
            return null;
        }

        @Nullable
        public static final String toLString(@Nullable Profile p) {
            return p == null ? null : p.name();
        }

        public static final void reTitle(@Nonnull ItemStack what, @Nullable Profile p) {
            if (p != null && p != BOOK) {
                ItemStacks.setUnlocalizedNameOverride(what, LibInfo.lstring("enchantedBook.profile." + p.name()));
            }
        }

        static final void addTaggedProfileSamples() {
            for (Profile p : _VALUES) {
                if (p.tag() == null) continue;
                ArrayList defaults = _DEFAULTS_BASE.get((Object)p);
                defaults = Lists.newArrayList(defaults);
                _DEFAULTS.put(p, defaults);
                for (Item piece : RID.getItemsInGroup(p.tag())) {
                    defaults.add(new SampleItem(p.tagWeight(), piece));
                }
            }
        }

        private Profile() {
            this._tag = null;
            this._tag_weight = 0;
        }

        private Profile(String t, int w) {
            this._tag = "enchantables/" + t;
            this._tag_weight = w;
        }

        @Nullable
        public String tag() {
            return this._tag;
        }

        int tagWeight() {
            return this._tag_weight;
        }

        static {
            _BOOK = Arrays.asList(new SampleItem(6, Items.field_151122_aG));
            EnumMap<Profile, List<SampleItem>> map = new EnumMap<Profile, List<SampleItem>>(Profile.class);
            map.put(BOOK, _BOOK);
            map.put(BAUBLE, Arrays.asList(new SampleItem(6, Items.field_190929_cY)));
            map.put(WINGS, Arrays.asList(new SampleItem(6, Items.field_185160_cR)));
            map.put(WEAPON, Arrays.asList(new SampleItem(3, Items.field_151006_E), new SampleItem(12, Items.field_151010_B), new SampleItem(4, Items.field_151031_f), new SampleItem(4, Items.field_151041_m), new SampleItem(1, Items.field_203184_eO), new SampleItem(2, Items.field_222114_py)));
            map.put(TOOL, Arrays.asList(new SampleItem(5, Items.field_151011_C), new SampleItem(10, Items.field_151005_D), new SampleItem(5, Items.field_151006_E), new SampleItem(4, Items.field_151112_aM), new SampleItem(2, Items.field_151039_o)));
            map.put(ARMOR, Arrays.asList(new SampleItem(5, Items.field_151169_ag), new SampleItem(5, Items.field_151171_ah), new SampleItem(5, Items.field_151149_ai), new SampleItem(5, Items.field_151151_aj), new SampleItem(3, Items.field_185159_cQ), new SampleItem(3, Items.field_151027_R), new SampleItem(3, Items.field_151030_Z)));
            map.put(HEAD, Arrays.asList(new SampleItem(10, Items.field_151169_ag), new SampleItem(3, Items.field_151020_U)));
            map.put(FEET, Arrays.asList(new SampleItem(10, Items.field_151151_aj), new SampleItem(2, Items.field_151029_X)));
            map.put(BOW, Arrays.asList(new SampleItem(10, Items.field_151031_f), new SampleItem(3, Items.field_222114_py)));
            map.put(FISHROD, Arrays.asList(new SampleItem(10, Items.field_151112_aM)));
            map.put(SHIELD, Arrays.asList(new SampleItem(10, Items.field_185159_cQ)));
            map.put(SPECIALARMOR, Arrays.asList(new SampleItem(10, Items.field_151169_ag), new SampleItem(10, Items.field_151171_ah), new SampleItem(10, Items.field_151149_ai), new SampleItem(10, Items.field_151151_aj), new SampleItem(6, Items.field_185159_cQ), new SampleItem(6, Items.field_151027_R), new SampleItem(6, Items.field_151030_Z)));
            _DEFAULTS_BASE = map;
            map = new EnumMap(Profile.class);
            for (Profile p : _DEFAULTS_BASE.keySet()) {
                map.put(p, Lists.newArrayList((Iterable)_DEFAULTS_BASE.get((Object)p)));
            }
            _DEFAULTS = map;
            _VALUES = Profile.values();
        }
    }

    public static class SampleItem
    extends WeightedRandom.Item {
        public final Item sampleitem;

        public SampleItem(int weight, @Nonnull Item item) {
            super(weight);
            this.sampleitem = item;
            Validate.notNull((Object)item);
        }
    }
}

