/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.BlockState;
import net.minecraft.fluid.Fluid;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameter;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.JSONUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.LootConditionBase;

public final class FluidStatePropertyCondition
extends LootConditionBase {
    @Nullable
    final String _tag;
    @Nullable
    final Fluid _fluid;
    @Nonnull
    final StatePropertiesPredicate _impl;

    public FluidStatePropertyCondition(@Nullable String tag, @Nullable Fluid fluid, StatePropertiesPredicate impl) {
        Validate.isTrue((tag != null || fluid != null ? 1 : 0) != 0, (String)"Both selectors cannot be null", (Object[])new Object[0]);
        this._tag = tag;
        this._fluid = fluid;
        this._impl = impl;
    }

    public Set<LootParameter<?>> func_215855_a() {
        return ImmutableSet.of((Object)LootParameters.field_216287_g);
    }

    @Override
    protected LootConditionType _getLootConditionType() {
        return CarrotsLootTypes.Conditions.BLOCK_STATE_PROPERTY;
    }

    public boolean test(LootContext context) {
        Fluid fluid;
        BlockState state = (BlockState)context.func_216031_c(LootParameters.field_216287_g);
        Fluid fluid2 = fluid = state != null ? state.func_204520_s().func_206886_c() : Fluids.NO_FLUID;
        if (!Fluids.isNone(fluid)) {
            if (this._fluid != null && fluid != this._fluid) {
                return false;
            }
            if (this._tag != null && !RID.isIn(fluid, this._tag)) {
                return false;
            }
            return this._impl.func_227185_a_(state.func_204520_s());
        }
        return false;
    }

    public static class Serializer
    implements ILootSerializer<FluidStatePropertyCondition> {
        private static final String _IMPL = "properties";

        public FluidStatePropertyCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            String tag = StringUtils.trimToNull((String)JSONUtils.func_151200_h((JsonObject)json, (String)"fluid_tag"));
            String fluid_id = StringUtils.trimToNull((String)JSONUtils.func_151219_a((JsonObject)json, (String)"fluid", null));
            Fluid f = Fluids.getFluidOrNull(fluid_id);
            if (tag == null && f == null) {
                throw new JsonSyntaxException("A registered fluid's id or tag is required");
            }
            if (tag != null && f != null) {
                throw new JsonSyntaxException("Either a registered fluid's id or tag is required - not BOTH");
            }
            StatePropertiesPredicate impl = StatePropertiesPredicate.func_227186_a_((JsonElement)json.get(_IMPL));
            return new FluidStatePropertyCondition(tag, f, impl);
        }

        public void serialize(JsonObject json, FluidStatePropertyCondition lcond, JsonSerializationContext context) {
            if (lcond._tag != null) {
                json.addProperty("fluid_tag", lcond._tag);
            }
            if (lcond._fluid != null) {
                json.addProperty("fluid", lcond._fluid.getRegistryName().toString());
            }
            json.add(_IMPL, lcond._impl.func_227180_a_());
        }
    }
}

