/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nonnull;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.block.BlockState;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.util.JSONUtils;
import org.jwaresoftware.mcmods.lib.api.PropertyDefinition;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootParameters;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.lib.loot.LootConditionBase;

public final class IfAgedToCondition
extends LootConditionBase {
    final boolean _strict;
    @Nonnull
    final MinMaxBounds.IntBound _wanted;

    public IfAgedToCondition(MinMaxBounds.IntBound want, boolean strict) {
        this._wanted = want;
        this._strict = strict;
    }

    @Override
    protected LootConditionType _getLootConditionType() {
        return CarrotsLootTypes.Conditions.GROWTH_AGE;
    }

    public boolean test(LootContext lc) {
        boolean ok = false;
        if (this._strict && Loot.hasBlockHarvestingParameters(lc) || !this._strict && (lc.func_216033_a(LootParameters.field_216287_g) || lc.func_216033_a(CarrotsLootParameters.GROWTH_AGE))) {
            int age = -1;
            if (lc.func_216033_a(CarrotsLootParameters.GROWTH_AGE)) {
                age = (Integer)lc.func_216031_c(CarrotsLootParameters.GROWTH_AGE);
            } else {
                BlockState harvested = (BlockState)lc.func_216031_c(LootParameters.field_216287_g);
                age = PropertyDefinition.getAgeReading(harvested);
            }
            if (age >= 0 && this._wanted.func_211339_d(age)) {
                ok = true;
            }
        }
        return ok;
    }

    public static class Serializer
    implements ILootSerializer<IfAgedToCondition> {
        public IfAgedToCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            int i;
            boolean strict = !JSONUtils.func_151209_a((JsonObject)json, (String)"lenient", (boolean)false);
            MinMaxBounds.IntBound want = null;
            JsonElement v = json.get("value");
            want = v != null && JSONUtils.func_188175_b((JsonElement)v) ? ((i = v.getAsInt()) < 0 ? MinMaxBounds.IntBound.func_211345_a((int)0x7FFFFFFE) : MinMaxBounds.IntBound.func_211345_a((int)i)) : MinMaxBounds.IntBound.func_211344_a((JsonElement)v);
            return new IfAgedToCondition(want, strict);
        }

        public void serialize(JsonObject json, IfAgedToCondition lcond, JsonSerializationContext context) {
            if (!lcond._strict) {
                json.addProperty("lenient", Boolean.valueOf(true));
            }
            json.add("value", lcond._wanted.func_200321_c());
        }
    }
}

