/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import org.jwaresoftware.mcmods.lib.impl.Flag;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.lib.loot.LootConditionBase;

public final class IfEntityInBiomeCondition
extends LootConditionBase {
    @Nullable
    final LootContext.EntityTarget _target_locked;
    @Nonnull
    final List<ResourceLocation> _biomes;

    public IfEntityInBiomeCondition(@Nullable LootContext.EntityTarget target, @Nonnull String[] ids) {
        this._target_locked = target;
        this._biomes = new ArrayList<ResourceLocation>(Math.max(10, ids.length));
        for (int i = 0; i < ids.length; ++i) {
            this._biomes.add(new ResourceLocation(ids[i]));
        }
    }

    public IfEntityInBiomeCondition(String ... ids) {
        this((LootContext.EntityTarget)null, ids);
    }

    @Override
    protected LootConditionType _getLootConditionType() {
        return CarrotsLootTypes.Conditions.IN_BIOME;
    }

    private boolean test(Biome biome) {
        ResourceLocation rb;
        return biome != null && (rb = biome.getRegistryName()) != null && this._biomes.contains(rb);
    }

    public boolean test(LootContext context) {
        if (this._target_locked != null) {
            Entity target = (Entity)context.func_216031_c(this._target_locked.func_216029_a());
            if (target != null) {
                Biome biome = context.func_202879_g().func_226691_t_(target.func_233580_cy_());
                return this.test(biome);
            }
        } else {
            Flag entity = Flag.of(false);
            BlockPos at = Loot.getLocationIfPresent(context, entity);
            if (at != null && (entity.isTrue() || context.func_202879_g().func_175625_s(at) != null)) {
                Biome biome = context.func_202879_g().func_226691_t_(at);
                return this.test(biome);
            }
        }
        return false;
    }

    public static class Serializer
    implements ILootSerializer<IfEntityInBiomeCondition> {
        private static final String _ERR_MSG = "Invalid or missing biome id(s); must be either string or array of strings.";
        private static final String _FROM = "entity";
        private static final String _TYPE = "type";

        @Nullable
        public static final String[] deserialize_type_outof(JsonObject json, String field) {
            String[] typeids = null;
            if (JSONUtils.func_151204_g((JsonObject)json, (String)field)) {
                if (JSONUtils.func_151205_a((JsonObject)json, (String)field)) {
                    String key = JSONUtils.func_151200_h((JsonObject)json, (String)field);
                    typeids = new String[]{key};
                } else {
                    if (!JSONUtils.func_151202_d((JsonObject)json, (String)field)) {
                        throw new JsonSyntaxException(_ERR_MSG);
                    }
                    JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)field);
                    typeids = new String[jsonarray.size()];
                    int j = 0;
                    for (JsonElement jsonelement : jsonarray) {
                        typeids[j++] = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)field);
                    }
                    if (typeids.length == 0) {
                        throw new JsonSyntaxException(_ERR_MSG);
                    }
                }
            }
            return typeids;
        }

        public IfEntityInBiomeCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            String[] typeids;
            LootContext.EntityTarget target = null;
            if (json.has(_FROM)) {
                target = (LootContext.EntityTarget)JSONUtils.func_188174_a((JsonObject)json, (String)_FROM, (JsonDeserializationContext)context, LootContext.EntityTarget.class);
            }
            if ((typeids = Serializer.deserialize_type_outof(json, _TYPE)) == null) {
                throw new JsonSyntaxException(_ERR_MSG);
            }
            return new IfEntityInBiomeCondition(target, typeids);
        }

        public void serialize(JsonObject json, IfEntityInBiomeCondition lcond, JsonSerializationContext context) {
            if (lcond._target_locked != null) {
                json.add(_FROM, context.serialize((Object)lcond._target_locked));
            }
            if (lcond._biomes.size() == 1) {
                json.add(_TYPE, context.serialize((Object)lcond._biomes.get(0).toString()));
            } else {
                JsonArray jsonarray = new JsonArray();
                for (ResourceLocation rid : lcond._biomes) {
                    jsonarray.add(context.serialize((Object)rid.toString()));
                }
                json.add(_TYPE, (JsonElement)jsonarray);
            }
        }
    }
}

