/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.impl.Flag;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.lib.loot.LootConditionBase;

public final class IfEntityInBiomeOfTypeCondition
extends LootConditionBase {
    @Nullable
    final LootContext.EntityTarget _target_locked;
    @Nonnull
    final BiomeDictionary.Type[] _biomeTypes;
    final boolean _allMatch;

    public IfEntityInBiomeOfTypeCondition(@Nullable LootContext.EntityTarget target, boolean all, @Nonnull String[] typeids) {
        Collection ALL = BiomeDictionary.Type.getAll();
        this._target_locked = target;
        this._biomeTypes = new BiomeDictionary.Type[typeids.length];
        this._allMatch = all;
        for (int i = 0; i < typeids.length; ++i) {
            BiomeDictionary.Type match = null;
            String name = typeids[i].toUpperCase(Locale.ROOT);
            for (BiomeDictionary.Type t : ALL) {
                if (!Objects.equals(t.getName(), name)) continue;
                match = t;
                break;
            }
            if (match == null) {
                throw new JsonSyntaxException("Unable to find biome type: '" + typeids[i] + "'");
            }
            this._biomeTypes[i] = match;
        }
    }

    public IfEntityInBiomeOfTypeCondition(String ... typeids) {
        this(null, true, typeids);
    }

    @Override
    protected LootConditionType _getLootConditionType() {
        return CarrotsLootTypes.Conditions.IN_BIOME_TYPE;
    }

    private boolean contains(RegistryKey<Biome> biome) {
        boolean match = false;
        if (biome != null) {
            match = this._allMatch ? Locations.isBiomeLike(biome, this._biomeTypes) : BiomeDictionary.getTypes(biome).stream().anyMatch(have -> {
                for (BiomeDictionary.Type want : this._biomeTypes) {
                    if (want != have) continue;
                    return true;
                }
                return false;
            });
        }
        return match;
    }

    public boolean test(LootContext context) {
        boolean match = false;
        if (this._target_locked != null) {
            Entity target = (Entity)context.func_216031_c(this._target_locked.func_216029_a());
            if (target != null) {
                RegistryKey<Biome> biome = Locations.biomeKeyFor((IBiomeReader)context.func_202879_g(), target.func_233580_cy_());
                match = this.contains(biome);
            }
        } else {
            Flag entity = Flag.of(false);
            BlockPos at = Loot.getLocationIfPresent(context, entity);
            if (at != null && (entity.isTrue() || context.func_202879_g().func_175625_s(at) != null)) {
                RegistryKey<Biome> biome = Locations.biomeKeyFor((IBiomeReader)context.func_202879_g(), at);
                match = this.contains(biome);
            }
        }
        return match;
    }

    public static class Serializer
    implements ILootSerializer<IfEntityInBiomeOfTypeCondition> {
        private static final String _ERR_MSG = "Invalid or missing biome type(s); must be either string or array of strings.";
        private static final String _FROM = "entity";
        private static final String _TYPE = "type";

        public IfEntityInBiomeOfTypeCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            boolean all = !"any".equals(JSONUtils.func_151219_a((JsonObject)json, (String)"matcher", (String)"all"));
            LootContext.EntityTarget target = null;
            if (json.has(_FROM)) {
                target = (LootContext.EntityTarget)JSONUtils.func_188174_a((JsonObject)json, (String)_FROM, (JsonDeserializationContext)context, LootContext.EntityTarget.class);
            }
            String[] typeids = null;
            if (JSONUtils.func_151204_g((JsonObject)json, (String)_TYPE)) {
                if (JSONUtils.func_151205_a((JsonObject)json, (String)_TYPE)) {
                    String key = JSONUtils.func_151200_h((JsonObject)json, (String)_TYPE);
                    typeids = new String[]{key};
                } else {
                    if (!JSONUtils.func_151202_d((JsonObject)json, (String)_TYPE)) {
                        throw new JsonSyntaxException(_ERR_MSG);
                    }
                    JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)_TYPE);
                    typeids = new String[jsonarray.size()];
                    int j = 0;
                    for (JsonElement jsonelement : jsonarray) {
                        typeids[j++] = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)_TYPE);
                    }
                    if (typeids.length == 0) {
                        throw new JsonSyntaxException("Invalid biome type array; must contain at least one biome type.");
                    }
                }
            }
            if (typeids == null) {
                throw new JsonSyntaxException(_ERR_MSG);
            }
            return new IfEntityInBiomeOfTypeCondition(target, all, typeids);
        }

        public void serialize(JsonObject json, IfEntityInBiomeOfTypeCondition lcond, JsonSerializationContext context) {
            json.addProperty("matcher", lcond._allMatch ? "all" : "any");
            if (lcond._target_locked != null) {
                json.add(_FROM, context.serialize((Object)lcond._target_locked));
            }
            if (lcond._biomeTypes.length == 1) {
                json.add(_TYPE, context.serialize((Object)lcond._biomeTypes[0].getName()));
            } else {
                JsonArray jsonarray = new JsonArray();
                for (BiomeDictionary.Type type : lcond._biomeTypes) {
                    jsonarray.add(context.serialize((Object)type.getName()));
                }
                json.add(_TYPE, (JsonElement)jsonarray);
            }
        }
    }
}

