/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nonnull;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.api.DayNightState;
import org.jwaresoftware.mcmods.lib.integration.AlmanacHelper;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.lib.loot.LootConditionBase;

public final class IfTimeOfDayCondition
extends LootConditionBase {
    @Nonnull
    final DayNightState[] _wanted;

    public IfTimeOfDayCondition(DayNightState[] want) {
        if (want == null || want.length == 0) {
            throw new IllegalArgumentException("A daynight state is required");
        }
        for (DayNightState st : want) {
            if (st.isKnown()) continue;
            throw new IllegalArgumentException("Only known daynight states allowed (do not include UNKNOWN)");
        }
        this._wanted = want;
    }

    @Override
    protected LootConditionType _getLootConditionType() {
        return CarrotsLootTypes.Conditions.TIMEOFDAY;
    }

    public boolean test(LootContext lc) {
        BlockPos at = Loot.getLocationIfPresent(lc, null);
        for (DayNightState wanted : this._wanted) {
            boolean is;
            boolean bl = is = at == null ? AlmanacHelper.isTimeOfDay((World)lc.func_202879_g(), wanted) : AlmanacHelper.isTimeOfDay((World)lc.func_202879_g(), at, wanted);
            if (!is) continue;
            return true;
        }
        return false;
    }

    public static ILootCondition.IBuilder builder(DayNightState ... want) {
        return () -> new IfTimeOfDayCondition(want);
    }

    public static class Serializer
    implements ILootSerializer<IfTimeOfDayCondition> {
        public IfTimeOfDayCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            DayNightState[] want = DayNightState.deserialize_from(json.get("value"));
            return new IfTimeOfDayCondition(want);
        }

        public void serialize(JsonObject json, IfTimeOfDayCondition lcond, JsonSerializationContext context) {
            JsonArray jsonarray = new JsonArray();
            for (DayNightState st : lcond._wanted) {
                jsonarray.add(context.serialize((Object)st.toString()));
            }
            json.add("value", (JsonElement)jsonarray);
        }
    }
}

