/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.lib.loot.RandomPickFromVariantSetFunction;

public final class RandomPickFromSharedDictFunction
extends LootFunction {
    private static final List<ResourceLocation> _NO_OMISSIONS = Collections.emptyList();
    @Nullable
    final Type _dict_type;
    final String[] _dict_keys;
    final int _retries;
    @Nullable
    final String _denylist;

    public RandomPickFromSharedDictFunction(ILootCondition[] conditions, @Nullable Type type, @Nonnull String[] dict_keys, int retries, @Nullable String denylist_tag) {
        super(conditions);
        this._dict_type = type;
        this._retries = retries;
        this._denylist = denylist_tag;
        this._dict_keys = new String[dict_keys.length];
        for (int i = 0; i < dict_keys.length; ++i) {
            this._dict_keys[i] = StringUtils.trimToNull((String)dict_keys[i]);
        }
    }

    public LootFunctionType func_230425_b_() {
        return CarrotsLootTypes.Functions.RANDOM_PICK;
    }

    private ItemStack apply(String dict_key, ItemStack in, LootContext context) {
        Random rand = context.func_216032_b();
        ItemStack out = ItemStack.field_190927_a;
        Type type = Type.orDefault(this._dict_type);
        if (dict_key != null) {
            block0 : switch (type) {
                case VARIANT: {
                    Item marker = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(dict_key));
                    if (!SharedGlue.isDefined(marker)) break;
                    ItemStack base = RandomPickFromVariantSetFunction.copyout(in, marker);
                    int retries = this._retries;
                    do {
                        ItemStack choice;
                        if ((choice = RandomPickFromVariantSetFunction.apply(base, rand, _NO_OMISSIONS, this._retries)).func_190926_b() || this._denylist != null && RID.isIn(choice.func_77973_b(), this._denylist)) continue;
                        out = choice;
                        break block0;
                    } while (--retries >= 0);
                    break;
                }
                default: {
                    List<ItemStack> all;
                    String tag = dict_key;
                    if (tag.indexOf(58) < 0 && type == Type.MINECRAFT) {
                        tag = "minecraft:" + tag;
                    }
                    if (!RID.isGroupDefined(tag) || (all = RID.getAllInGroup(tag)).isEmpty()) break;
                    int retries = this._retries;
                    do {
                        int i;
                        ItemStack choice;
                        if ((choice = all.get(i = rand.nextInt(all.size()))).func_77951_h()) {
                            choice = ItemStacks.copy1(choice);
                            choice.func_196085_b(0);
                        } else {
                            choice = Loot.resized(choice, in.func_190916_E());
                        }
                        if (choice.func_190926_b() || this._denylist != null && RID.isIn(choice.func_77973_b(), this._denylist)) continue;
                        out = choice;
                        break block0;
                    } while (--retries >= 0);
                }
            }
        }
        return out;
    }

    public ItemStack func_215859_a(ItemStack in, LootContext context) {
        ItemStack out = in;
        if (!in.func_190926_b()) {
            for (String dict_key : this._dict_keys) {
                ItemStack pick = this.apply(dict_key, in, context);
                if (pick.func_190926_b()) continue;
                out = pick;
                break;
            }
        }
        return out;
    }

    public static enum Type {
        FORGE,
        MINECRAFT,
        VARIANT;


        @Nullable
        public static final Type fromLString(@Nullable String s) {
            if (s == null) {
                return null;
            }
            if ("forge".equals(s)) {
                return FORGE;
            }
            if ("dataset".equals(s)) {
                return VARIANT;
            }
            if ("minecraft".equals(s)) {
                return MINECRAFT;
            }
            return null;
        }

        @Nullable
        public static final String toLString(@Nullable Type type) {
            return type == null || type == FORGE ? null : (type == VARIANT ? "dataset" : "minecraft");
        }

        @Nonnull
        public static final Type orDefault(@Nullable Type type) {
            return type == null ? FORGE : type;
        }
    }

    public static final class Serializer
    extends LootFunction.Serializer<RandomPickFromSharedDictFunction> {
        private static final String _ERR_MSG = "Invalid or missing tags id(s); must be either string or array of strings.";
        private static final String _TAGS = "tags";
        private static final String _ORE_DICT = "dict";

        public RandomPickFromSharedDictFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            String[] dictids = null;
            String _DICT = _TAGS;
            if (!JSONUtils.func_151204_g((JsonObject)json, (String)_TAGS)) {
                _DICT = _ORE_DICT;
            }
            if (JSONUtils.func_151204_g((JsonObject)json, (String)_DICT)) {
                if (JSONUtils.func_151205_a((JsonObject)json, (String)_DICT)) {
                    String key = JSONUtils.func_151200_h((JsonObject)json, (String)_DICT);
                    dictids = new String[]{key};
                } else {
                    if (!JSONUtils.func_151202_d((JsonObject)json, (String)_DICT)) {
                        throw new JsonSyntaxException(_ERR_MSG);
                    }
                    JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)_DICT);
                    dictids = new String[jsonarray.size()];
                    int j = 0;
                    for (JsonElement jsonelement : jsonarray) {
                        dictids[j++] = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)_DICT);
                    }
                    if (dictids.length == 0) {
                        throw new JsonSyntaxException("Invalid dictionary keys; must contain at least one value.");
                    }
                }
            }
            if (dictids == null) {
                throw new JsonSyntaxException(_ERR_MSG);
            }
            int retries = JSONUtils.func_151208_a((JsonObject)json, (String)"retries", (int)-1);
            Type type = Type.fromLString(JSONUtils.func_151219_a((JsonObject)json, (String)"type", null));
            String deny_tag = JSONUtils.func_151219_a((JsonObject)json, (String)"denylist_tag", null);
            return new RandomPickFromSharedDictFunction(conditions, type, dictids, retries, deny_tag);
        }

        public void serialize(JsonObject object, RandomPickFromSharedDictFunction lfunction, JsonSerializationContext serializationContext) {
            super.func_230424_a_(object, (LootFunction)lfunction, serializationContext);
            String type = Type.toLString(lfunction._dict_type);
            if (type != null) {
                object.add("type", serializationContext.serialize((Object)type));
            }
            if (lfunction._retries > 0) {
                object.add("retries", serializationContext.serialize((Object)lfunction._retries));
            }
            if (lfunction._denylist != null && !lfunction._denylist.isEmpty()) {
                object.add("denylist_tag", serializationContext.serialize((Object)lfunction._denylist));
            }
            if (lfunction._dict_keys.length > 0) {
                if (lfunction._dict_keys.length == 1) {
                    object.add(_TAGS, serializationContext.serialize((Object)lfunction._dict_keys[0]));
                } else {
                    JsonArray jsonarray = new JsonArray();
                    for (String dict_key : lfunction._dict_keys) {
                        if (dict_key == null) continue;
                        jsonarray.add(serializationContext.serialize((Object)dict_key));
                    }
                    if (jsonarray.size() > 0) {
                        object.add(_TAGS, (JsonElement)jsonarray);
                    }
                }
            }
        }
    }
}

