/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.Loot;

public final class RandomPickFromVariantSetFunction
extends LootFunction {
    final int _retries;
    @Nonnull
    final List<ResourceLocation> _exceptions;

    public RandomPickFromVariantSetFunction(ILootCondition[] conditions, int retries, String[] exceptions) {
        super(conditions);
        this._retries = retries;
        this._exceptions = new ArrayList<ResourceLocation>(10);
        if (exceptions != null && exceptions.length > 0) {
            for (String rloc : exceptions) {
                this._exceptions.add(new ResourceLocation(rloc));
            }
        }
    }

    public RandomPickFromVariantSetFunction(ILootCondition[] conditions) {
        this(conditions, -1, null);
    }

    public LootFunctionType func_230425_b_() {
        return CarrotsLootTypes.Functions.RANDOM_VARIANT;
    }

    static final ItemStack copyout(ItemStack in, Item pickitem) {
        ItemStack out = Loot.resized(ItemStacks.create(pickitem), in.func_190916_E());
        if (in.func_82837_s()) {
            ItemStacks.copyDisplayName(in, out);
        }
        return out;
    }

    @Nonnull
    static final ItemStack apply(ItemStack in, Random rand, @Nonnull List<ResourceLocation> exceptions, int retries) {
        ItemStack out = in;
        if (!in.func_190926_b() && in.func_77973_b() instanceof IVariant) {
            Predicate<Item> filter = exceptions.isEmpty() ? null : choice -> exceptions.contains(choice.getRegistryName());
            ItemStack pick = ((IVariant)in.func_77973_b()).randomPick(ItemStack.field_190927_a, filter, rand);
            if (!pick.func_190926_b()) {
                out = Loot.resized(pick, in.func_190916_E());
            }
        }
        return out;
    }

    public ItemStack func_215859_a(ItemStack in, LootContext context) {
        return RandomPickFromVariantSetFunction.apply(in, context.func_216032_b(), this._exceptions, this._retries);
    }

    public static final class Serializer
    extends LootFunction.Serializer<RandomPickFromVariantSetFunction> {
        private static final String _ERR_MSG = "Invalid omit key(s); must be either string or array of strings.";
        private static final String _OMIT = "omit";

        public RandomPickFromVariantSetFunction deserialize(JsonObject json, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            String[] exceptions = null;
            if (JSONUtils.func_151204_g((JsonObject)json, (String)_OMIT)) {
                if (JSONUtils.func_151205_a((JsonObject)json, (String)_OMIT)) {
                    String rid = JSONUtils.func_151200_h((JsonObject)json, (String)_OMIT);
                    exceptions = new String[]{rid};
                } else {
                    if (!JSONUtils.func_151202_d((JsonObject)json, (String)_OMIT)) {
                        throw new JsonSyntaxException(_ERR_MSG);
                    }
                    JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)_OMIT);
                    exceptions = new String[jsonarray.size()];
                    int j = 0;
                    for (JsonElement jsonelement : jsonarray) {
                        exceptions[j++] = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)_OMIT);
                    }
                }
            }
            int retries = JSONUtils.func_151208_a((JsonObject)json, (String)"retries", (int)-1);
            return new RandomPickFromVariantSetFunction(conditions, retries, exceptions);
        }

        public void serialize(JsonObject object, RandomPickFromVariantSetFunction lfunction, JsonSerializationContext serializationContext) {
            super.func_230424_a_(object, (LootFunction)lfunction, serializationContext);
            if (lfunction._retries > 0) {
                object.add("retries", serializationContext.serialize((Object)lfunction._retries));
            }
            if (!lfunction._exceptions.isEmpty()) {
                if (lfunction._exceptions.size() == 1) {
                    object.add(_OMIT, serializationContext.serialize((Object)lfunction._exceptions.get(0).toString()));
                } else {
                    JsonArray jsonarray = new JsonArray();
                    for (ResourceLocation r : lfunction._exceptions) {
                        jsonarray.add(serializationContext.serialize((Object)r.toString()));
                    }
                    object.add(_OMIT, (JsonElement)jsonarray);
                }
            }
        }
    }
}

