/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import javax.annotation.Nonnull;
import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootConditionType;
import net.minecraft.loot.LootContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.api.WorldSeason;
import org.jwaresoftware.mcmods.lib.integration.AlmanacHelper;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;
import org.jwaresoftware.mcmods.lib.loot.Loot;
import org.jwaresoftware.mcmods.lib.loot.LootConditionBase;

public final class SeasonCondition
extends LootConditionBase {
    @Nonnull
    final WorldSeason.Detailed[] _seasons;

    public SeasonCondition(WorldSeason.Detailed[] seasons) {
        if (seasons == null) {
            throw new IllegalArgumentException("A non-zero season is required");
        }
        this._seasons = seasons;
    }

    @Override
    protected LootConditionType _getLootConditionType() {
        return CarrotsLootTypes.Conditions.IN_SEASON;
    }

    public boolean test(LootContext lc) {
        BlockPos at = Loot.getLocationIfPresent(lc, null);
        if (at == null) {
            at = AlmanacHelper.safeLocation((World)lc.func_202879_g());
        }
        WorldSeason.Detailed ws = AlmanacHelper.getDetailedSeason((World)lc.func_202879_g(), at);
        for (WorldSeason.Detailed allowed : this._seasons) {
            if (!allowed.equals(ws)) continue;
            return true;
        }
        return false;
    }

    public static class Serializer
    implements ILootSerializer<SeasonCondition> {
        private static final String _SEASONS = "seasons";

        public SeasonCondition deserialize(JsonObject json, JsonDeserializationContext context) {
            WorldSeason.Detailed[] seasons = WorldSeason.deserialize_from(json.get(_SEASONS));
            return new SeasonCondition(seasons);
        }

        public void serialize(JsonObject json, SeasonCondition lcond, JsonSerializationContext context) {
            if (lcond._seasons.length == 1) {
                json.add(_SEASONS, context.serialize((Object)lcond._seasons[0].func_176610_l()));
            } else {
                JsonArray jsonarray = new JsonArray();
                for (WorldSeason.Detailed ws : lcond._seasons) {
                    jsonarray.add(context.serialize((Object)ws.func_176610_l()));
                }
                json.add(_SEASONS, (JsonElement)jsonarray);
            }
        }
    }
}

