/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.util.JSONUtils;
import net.minecraft.world.World;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ILootedListener;
import org.jwaresoftware.mcmods.lib.loot.CarrotsLootTypes;

public final class SetOwnedFunction
extends LootFunction {
    private static final String _DEFAULT_ORIGIN = "looted";
    final String _origin;
    final boolean _notify_looted;
    final boolean _exclude_name;

    public SetOwnedFunction(ILootCondition[] conditions, boolean exclude_name, boolean notify, String origin) {
        super(conditions);
        this._exclude_name = exclude_name;
        this._notify_looted = notify;
        this._origin = origin != null ? origin.toLowerCase(Locale.ROOT) : _DEFAULT_ORIGIN;
    }

    public LootFunctionType func_230425_b_() {
        return CarrotsLootTypes.Functions.SET_OWNED;
    }

    public ItemStack func_215859_a(ItemStack input, LootContext lc) {
        PlayerEntity player;
        if (!input.func_190926_b() && (player = SharedGlue.getRealPlayerOrNull((Entity)lc.func_216031_c(LootParameters.field_216281_a))) != null) {
            boolean skip = false;
            if (this._notify_looted && input.func_77973_b() instanceof ILootedListener) {
                boolean had = Instructions.hasOwner(input);
                ((ILootedListener)input.func_77973_b()).notifyLooted(input, (World)lc.func_202879_g(), player, lc.func_186491_f(), this._origin);
                if (!had && Instructions.hasOwner(input)) {
                    skip = true;
                }
            }
            if (!skip) {
                if (this._exclude_name) {
                    String uuid = player.func_189512_bd();
                    if (!StringUtils.isBlank((CharSequence)uuid)) {
                        Instructions.setOwner(input, uuid);
                    }
                } else {
                    Instructions.setOwner(input, player, true);
                }
            }
        }
        return input;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetOwnedFunction> {
        public SetOwnedFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditions) {
            boolean exclude_name = !JSONUtils.func_151209_a((JsonObject)object, (String)"include_name", (boolean)true);
            boolean notify = JSONUtils.func_151209_a((JsonObject)object, (String)"notify", (boolean)false);
            String origin = JSONUtils.func_151219_a((JsonObject)object, (String)"context", null);
            return new SetOwnedFunction(conditions, exclude_name, notify, origin);
        }

        public void serialize(JsonObject object, SetOwnedFunction lfunction, JsonSerializationContext serializationContext) {
            super.func_230424_a_(object, (LootFunction)lfunction, serializationContext);
            if (lfunction._exclude_name) {
                object.addProperty("include_name", Boolean.valueOf(false));
            }
            if (lfunction._notify_looted) {
                object.addProperty("notify", Boolean.valueOf(true));
            }
            if (!SetOwnedFunction._DEFAULT_ORIGIN.equals(lfunction._origin)) {
                object.addProperty("context", lfunction._origin);
            }
        }
    }
}

