/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.recipes.TagIsPresentCondition;

public final class AllTagsPresentCondition
implements ICondition {
    public static final ResourceLocation NAME = LibInfo.r("tags_exist");
    final TagIsPresentCondition.TagType _type;
    final String[] _tags;
    final boolean _is_not;

    AllTagsPresentCondition(@Nullable TagIsPresentCondition.TagType type, boolean inverse, String[] tags) {
        this._type = type == null ? TagIsPresentCondition.TagType.ITEM : type;
        this._tags = tags;
        this._is_not = inverse;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        boolean is = true;
        for (String tag : this._tags) {
            if (this._type.test(tag)) continue;
            is = false;
            break;
        }
        return is == !this._is_not;
    }

    public static final class Serializer
    implements IConditionSerializer<AllTagsPresentCondition> {
        public static final Serializer INSTANCE = new Serializer();
        private static final String _LIST = "values";
        private static final String _TYPE = "tag_type";
        private static final String _NOT = "inverse";

        public ResourceLocation getID() {
            return NAME;
        }

        public final AllTagsPresentCondition read(JsonObject json) {
            TagIsPresentCondition.TagType type = TagIsPresentCondition.TagType.fromLString(JSONUtils.func_151219_a((JsonObject)json, (String)_TYPE, null));
            JsonArray jsonarray = JSONUtils.func_151214_t((JsonObject)json, (String)_LIST);
            String[] tagids = new String[jsonarray.size()];
            int j = 0;
            for (JsonElement jsonelement : jsonarray) {
                tagids[j++] = JSONUtils.func_151206_a((JsonElement)jsonelement, (String)_LIST);
            }
            if (tagids.length == 0) {
                throw new JsonSyntaxException("Invalid tags; must contain at least one value.");
            }
            return new AllTagsPresentCondition(type, JSONUtils.func_151209_a((JsonObject)json, (String)_NOT, (boolean)false), tagids);
        }

        public final void write(JsonObject json, AllTagsPresentCondition rc) {
            JsonArray jsonarray = new JsonArray();
            for (String tag : rc._tags) {
                if (tag == null) continue;
                jsonarray.add(tag);
            }
            if (jsonarray.size() > 0) {
                if (rc._type != TagIsPresentCondition.TagType.ITEM) {
                    json.addProperty(_TYPE, rc._type.Lstring());
                }
                json.add(_LIST, (JsonElement)jsonarray);
                json.addProperty(_NOT, Boolean.valueOf(rc._is_not));
            }
        }
    }
}

