/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.recipes;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.SpecialRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.capability.IDye;
import org.jwaresoftware.mcmods.lib.capability.IDyeable;

public final class DyeableDyeRecipe
extends SpecialRecipe {
    private final boolean _overrideAll;

    DyeableDyeRecipe(ResourceLocation rid) {
        this(rid, true);
    }

    public DyeableDyeRecipe(ResourceLocation rid, boolean defer) {
        super(rid);
        this._overrideAll = !defer;
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 1;
    }

    public static final boolean isMinecraftRecipe(ItemStack dyeable, List<ItemStack> dyes) {
        ModIntegration mc = ModIntegration.MINECRAFT;
        if (!mc.belongsTo(dyeable)) {
            return false;
        }
        for (ItemStack dye : dyes) {
            if (mc.belongsTo(dye)) continue;
            return false;
        }
        return true;
    }

    private boolean isMinecraft(Pair<ItemStack, List<ItemStack>> items) {
        if (this._overrideAll) {
            return false;
        }
        return DyeableDyeRecipe.isMinecraftRecipe((ItemStack)items.getLeft(), (List)items.getRight());
    }

    @Nullable
    public static final Pair<ItemStack, List<ItemStack>> getItems(CraftingInventory grid) {
        int n = grid.func_70302_i_();
        ItemStack dyeable = ItemStack.field_190927_a;
        ArrayList<ItemStack> dyes = null;
        for (int i = 0; i < n; ++i) {
            ItemStack stack = grid.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            Optional<IDyeable> dyeable_f = IDyeable.get(stack);
            if (dyeable_f.isPresent()) {
                if (!dyeable.func_190926_b()) {
                    return null;
                }
                dyeable = stack;
                continue;
            }
            Optional<IDye> dye_f = IDye.get(stack);
            if (!dye_f.isPresent()) {
                return null;
            }
            if (dyes == null) {
                dyes = new ArrayList<ItemStack>(5);
            }
            dyes.add(stack);
        }
        return dyes != null && !dyeable.func_190926_b() ? Pair.of((Object)dyeable, dyes) : null;
    }

    public boolean matches(CraftingInventory grid, World ignored) {
        Pair<ItemStack, List<ItemStack>> items = DyeableDyeRecipe.getItems(grid);
        return items != null && !this.isMinecraft(items);
    }

    public ItemStack getCraftingResult(CraftingInventory grid) {
        ItemStack out = ItemStack.field_190927_a;
        Pair<ItemStack, List<ItemStack>> items = DyeableDyeRecipe.getItems(grid);
        if (items != null) {
            out = IDyeable.applyDyes((ItemStack)items.getKey(), (List)items.getValue());
        }
        return out;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<DyeableDyeRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public DyeableDyeRecipe read(ResourceLocation recipeId, JsonObject unused) {
            return new DyeableDyeRecipe(recipeId);
        }

        public DyeableDyeRecipe read(ResourceLocation recipeId, PacketBuffer unused) {
            return new DyeableDyeRecipe(recipeId);
        }

        public void write(PacketBuffer unused, DyeableDyeRecipe recipe) {
        }
    }
}

