/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.recipes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.CampfireCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.ITag;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.NBTIngredient;
import net.minecraftforge.common.crafting.VanillaIngredientSerializer;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.util.JsonUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.LibInfo;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IModItem;
import org.jwaresoftware.mcmods.lib.api.NutritionNote;
import org.jwaresoftware.mcmods.lib.capability.QualityGrade;
import org.jwaresoftware.mcmods.lib.impl.item.NutritionProfile;
import org.jwaresoftware.mcmods.lib.recipes.AllTagsPresentCondition;
import org.jwaresoftware.mcmods.lib.recipes.CampfireRecipeWrapping;
import org.jwaresoftware.mcmods.lib.recipes.DyeableDyeRecipe;
import org.jwaresoftware.mcmods.lib.recipes.InDevEnvironmentCondition;
import org.jwaresoftware.mcmods.lib.recipes.MultiItemBlastFurnaceRecipe;
import org.jwaresoftware.mcmods.lib.recipes.MultiItemCookingRecipeSerializer;
import org.jwaresoftware.mcmods.lib.recipes.MultiItemFurnaceRecipe;
import org.jwaresoftware.mcmods.lib.recipes.MultiItemSmokerRecipe;
import org.jwaresoftware.mcmods.lib.recipes.NutritionNotedShapedRecipe;
import org.jwaresoftware.mcmods.lib.recipes.NutritionNotedShapelessRecipe;
import org.jwaresoftware.mcmods.lib.recipes.ShapedRecipeWrapping;
import org.jwaresoftware.mcmods.lib.recipes.ShapelessRecipeWrapping;
import org.jwaresoftware.mcmods.lib.recipes.TagIsPresentCondition;

public final class JR {
    static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static MultiItemCookingRecipeSerializer<MultiItemFurnaceRecipe> SMELTING_RECIPE_SERIALIZER;
    public static MultiItemCookingRecipeSerializer<MultiItemSmokerRecipe> SMOKER_RECIPE_SERIALIZER;
    public static MultiItemCookingRecipeSerializer<MultiItemBlastFurnaceRecipe> BLASTING_RECIPE_SERIALIZER;
    static final IIngredientSerializer<BucketTaggedFluidIngredient> INGREDIENT_TAGGED_FLUID_BUCKET_SERIALIZER;
    public static final IIngredientSerializer<BucketFluidIngredient> INGREDIENT_FLUID_BUCKET_SERIALIZER;
    public static final IIngredientSerializer<Ingredient> INGREDIENT_FILLED_UNIVERSAL_BUCKET_SERIALIZER;
    public static final IIngredientSerializer<FillableTankIngredient> INGREDIENT_FILLABLE_BUCKET_SERIALIZER;
    public static final IIngredientSerializer<Ingredient> INGREDIENT_FILLABLE_BUCKET_OR_TANK_SERIALIZER;
    public static final IIngredientSerializer<LootedIngredient> INGREDIENT_LOOTED_ITEM_SERIALIZER;
    public static final IIngredientSerializer<QualityGradedIngredient> INGREDIENT_QGRADED_ITEM_SERIALIZER;
    private static final NutritionNotedShapelessRecipe.NNAdjustment _NO_NNADJ;

    public static ShapelessRecipe readShapeless(ResourceLocation rid, JsonObject json) {
        return (ShapelessRecipe)IRecipeSerializer.field_222158_b.func_199425_a_(rid, json);
    }

    public static void writeShapeless(PacketBuffer to, ShapelessRecipe recipe) {
        IRecipeSerializer.field_222158_b.func_199427_a_(to, (IRecipe)recipe);
    }

    public static ShapelessRecipe readShapeless(ResourceLocation rid, PacketBuffer from) {
        return (ShapelessRecipe)IRecipeSerializer.field_222158_b.func_199426_a_(rid, from);
    }

    public static ShapedRecipe readShaped(ResourceLocation rid, JsonObject json) {
        return (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199425_a_(rid, json);
    }

    public static void writeShaped(PacketBuffer to, ShapedRecipe recipe) {
        IRecipeSerializer.field_222157_a.func_199427_a_(to, (IRecipe)recipe);
    }

    public static ShapedRecipe readShaped(ResourceLocation rid, PacketBuffer from) {
        return (ShapedRecipe)IRecipeSerializer.field_222157_a.func_199426_a_(rid, from);
    }

    public static CampfireCookingRecipe readCampfire(ResourceLocation rid, JsonObject json) {
        return (CampfireCookingRecipe)IRecipeSerializer.field_222174_r.func_199425_a_(rid, json);
    }

    public static void writeCampfire(PacketBuffer to, CampfireCookingRecipe recipe) {
        IRecipeSerializer.field_222174_r.func_199427_a_(to, (AbstractCookingRecipe)recipe);
    }

    public static CampfireCookingRecipe readCampfire(ResourceLocation rid, PacketBuffer from) {
        return (CampfireCookingRecipe)IRecipeSerializer.field_222174_r.func_199426_a_(rid, from);
    }

    @Nullable
    static final Ingredient readFallbackBucket(JsonObject json) {
        Object fallback_bucket = null;
        if (json.has("mod_bucket")) {
            JsonElement e = json.get("mod_bucket");
            if (e.isJsonObject()) {
                fallback_bucket = CraftingHelper.getIngredient((JsonElement)e);
            } else {
                String descriptor = e.getAsString();
                if (descriptor.charAt(0) == '#') {
                    ITag<Item> tag = RID.getTag(descriptor.substring(1));
                    if (tag != null) {
                        fallback_bucket = Ingredient.func_199805_a(tag);
                    }
                } else {
                    ItemStack owned_bucket;
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(descriptor));
                    ItemStack itemStack = owned_bucket = SharedGlue.isDefined(item) ? ItemStacks.create(item) : ItemStack.field_190927_a;
                    if (!owned_bucket.func_190926_b()) {
                        fallback_bucket = new IngredientNBTSensitive(owned_bucket);
                    }
                }
            }
        }
        return fallback_bucket;
    }

    @Nonnull
    public static final Ingredient readFullBucketIngredient(JsonObject json, @Nonnull IIngredientSerializer<? extends Ingredient> serializer) throws JsonSyntaxException {
        ItemStack filled_bucket;
        Ingredient fallback_bucket = JR.readFallbackBucket(json);
        String fluidName = JSONUtils.func_151219_a((JsonObject)json, (String)"fluid", null);
        String tag = JSONUtils.func_151219_a((JsonObject)json, (String)"fluid_tag", (String)fluidName);
        Fluid fluid = Fluids.getFluidOrNull(fluidName);
        if (fluid == null && tag == null) {
            if (fallback_bucket != null) {
                return fallback_bucket;
            }
            throw new JsonSyntaxException("Unregistered fluid '" + fluidName + "' and no fluid tag given");
        }
        if (fluid == null) {
            Object out = null;
            if (fallback_bucket != null) {
                NonNullList both = NonNullList.func_191196_a();
                both.add((Object)fallback_bucket);
                both.add((Object)new BucketTaggedFluidIngredient(tag));
                out = new CompoundIngredientNBTSensitive((List<Ingredient>)both);
            } else {
                out = new BucketTaggedFluidIngredient(tag);
            }
            return out;
        }
        FluidStack contents = new FluidStack(fluid, 1000);
        if (json.has("nbt")) {
            try {
                JsonElement e = json.get("nbt");
                CompoundNBT nbt = e.isJsonObject() ? JsonToNBT.func_180713_a((String)GSON.toJson(e)) : JsonToNBT.func_180713_a((String)e.getAsString());
                contents = new FluidStack(fluid, 1000, nbt);
            }
            catch (Throwable malformX) {
                malformX.printStackTrace();
                throw new JsonSyntaxException("Unable to read fluid NBT because '" + malformX.getMessage() + "'");
            }
        }
        if ((filled_bucket = FluidUtil.getFilledBucket((FluidStack)contents)).func_190926_b()) {
            if (fallback_bucket != null) {
                return fallback_bucket;
            }
            throw new JsonSyntaxException("No bucket found for fluid '" + fluidName + "'");
        }
        Object out = null;
        if (fallback_bucket != null) {
            NonNullList both = NonNullList.func_191196_a();
            both.add((Object)fallback_bucket);
            both.add((Object)new BucketFluidIngredient(filled_bucket, contents, tag));
            out = new CompoundIngredientNBTSensitive((List<Ingredient>)both);
        } else {
            out = new BucketFluidIngredient(filled_bucket, contents, tag, serializer);
        }
        return out;
    }

    @Nonnull
    public static final Ingredient readFillableBucketOrTank(JsonObject json) {
        Ingredient fallback_bucket = JR.readFallbackBucket(json);
        Object out = null;
        if (fallback_bucket != null) {
            NonNullList both = NonNullList.func_191196_a();
            both.add((Object)fallback_bucket);
            both.add((Object)INGREDIENT_FILLABLE_BUCKET_SERIALIZER.parse(json));
            out = new CompoundIngredientNBTSensitive((List<Ingredient>)both);
        } else {
            out = INGREDIENT_FILLABLE_BUCKET_SERIALIZER.parse(json);
        }
        return out;
    }

    public static final void initRecipeSupport() {
        CraftingHelper.register((IConditionSerializer)TagIsPresentCondition.Serializer.INSTANCE);
        CraftingHelper.register((IConditionSerializer)AllTagsPresentCondition.Serializer.INSTANCE);
        CraftingHelper.register((IConditionSerializer)InDevEnvironmentCondition.Serializer.INSTANCE);
        LibInfo.LOG.debug("carrots/lib crafting conditions registered");
    }

    public static void autoregisterSerializers(@Nonnull IForgeRegistry<IRecipeSerializer<?>> serializers) {
        SMELTING_RECIPE_SERIALIZER = new MultiItemCookingRecipeSerializer<AbstractCookingRecipe>(LibInfo.rstring("smelting"), MultiItemFurnaceRecipe::new, 200);
        serializers.register(SMELTING_RECIPE_SERIALIZER);
        SMOKER_RECIPE_SERIALIZER = new MultiItemCookingRecipeSerializer<AbstractCookingRecipe>(LibInfo.rstring("smoking"), MultiItemSmokerRecipe::new, 100);
        serializers.register(SMOKER_RECIPE_SERIALIZER);
        BLASTING_RECIPE_SERIALIZER = new MultiItemCookingRecipeSerializer<AbstractCookingRecipe>(LibInfo.rstring("blasting"), MultiItemBlastFurnaceRecipe::new, 100);
        serializers.register(BLASTING_RECIPE_SERIALIZER);
        serializers.register((IForgeRegistryEntry)((IRecipeSerializer)MultiuseShapelessRecipe.SERIALIZER.setRegistryName(LibInfo.rstring("crafting_shapeless"))));
        serializers.register((IForgeRegistryEntry)((IRecipeSerializer)MultiuseShapedRecipe.SERIALIZER.setRegistryName(LibInfo.rstring("crafting_shaped"))));
        serializers.register((IForgeRegistryEntry)((IRecipeSerializer)NBTSensitiveCampfireRecipe.SERIALIZER.setRegistryName(LibInfo.rstring("campfire_cooking"))));
        serializers.register((IForgeRegistryEntry)((IRecipeSerializer)NoLeftoversShapelessRecipe.SERIALIZER.setRegistryName(LibInfo.rstring("cleanwipe_shapeless"))));
        serializers.register((IForgeRegistryEntry)((IRecipeSerializer)NoLeftoversShapedRecipe.SERIALIZER.setRegistryName(LibInfo.rstring("cleanwipe_shaped"))));
        serializers.register((IForgeRegistryEntry)((IRecipeSerializer)NutritionNotedShapelessRecipe.Serializer.INSTANCE.setRegistryName(LibInfo.rstring("foodcrafting_shapeless"))));
        serializers.register((IForgeRegistryEntry)((IRecipeSerializer)NutritionNotedShapedRecipe.Serializer.INSTANCE.setRegistryName(LibInfo.rstring("foodcrafting_shaped"))));
        serializers.register((IForgeRegistryEntry)((IRecipeSerializer)DyeableDyeRecipe.Serializer.INSTANCE.setRegistryName(LibInfo.rstring("crafting_special_dyeable"))));
        serializers.register((IForgeRegistryEntry)((IRecipeSerializer)ExampleShapelessRecipe.SERIALIZER.setRegistryName(LibInfo.rstring("sampling_shapeless"))));
        serializers.register((IForgeRegistryEntry)((IRecipeSerializer)ExampleShapedRecipe.SERIALIZER.setRegistryName(LibInfo.rstring("sampling_shaped"))));
        LibInfo.LOG.debug("carrots/lib recipe serializers registered");
    }

    static final ItemStack safeNotifyCookedOrCrafted(ItemStack output) {
        try {
            if (!output.func_190926_b() && output.func_77973_b() instanceof IModItem) {
                ((IModItem)output.func_77973_b()).onCookedOrCrafted(output);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return output;
    }

    static final ItemStack safeNotifyCookedOrCrafted(ItemStack output, IItemHandler iih, NutritionNotedShapelessRecipe.NNAdjustment nnadj) {
        output = JR.safeNotifyCookedOrCrafted(output);
        if (LibConfig.includeNutritionNotes() && NutritionProfile.isTaggable(output)) {
            if (nnadj == null) {
                nnadj = _NO_NNADJ;
            }
            long nn = 0L;
            if (nnadj.set != 0L) {
                if (nnadj.exclude >= 0L) {
                    nn = nnadj.set < 0L ? NutritionNote.from(NutritionNote.Scope.ALL.NOTES) : nnadj.set;
                }
                nn = NutritionProfile.adjust(nn, nnadj.exclude, nnadj.include);
            } else {
                nn = nnadj.exclude >= 0L ? (iih == null ? NutritionProfile.compute(output, NutritionNote.BASE_SET, nnadj.exclude, nnadj.include) : NutritionProfile.compute(output, iih, NutritionNote.BASE_SET, nnadj.exclude, nnadj.include)) : NutritionProfile.adjust(nn, nnadj.exclude, nnadj.include);
            }
            NutritionNote.addTo(output, nn);
        }
        return output;
    }

    static final ItemStack safeNotifyCookedOrCrafted(ItemStack output, IInventory grid) {
        return JR.safeNotifyCookedOrCrafted(output, (IItemHandler)(grid == null ? null : new InvWrapper(grid)), null);
    }

    static final ItemStack safeNotifyCookedOrCrafted(ItemStack output, IInventory grid, NutritionNotedShapelessRecipe.NNAdjustment nnadj) {
        return JR.safeNotifyCookedOrCrafted(output, (IItemHandler)(grid == null ? null : new InvWrapper(grid)), nnadj);
    }

    public static final ItemStack safeNotifyCookedOrCrafted(ItemStack output, IItemHandler iih) {
        return JR.safeNotifyCookedOrCrafted(output, iih, null);
    }

    public static NonNullList<ItemStack> defaultRecipeGetRemainingItems(@Nonnull CraftingInventory grid) {
        NonNullList leftovers = NonNullList.func_191197_a((int)grid.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < leftovers.size(); ++i) {
            ItemStack next = grid.func_70301_a(i);
            if (next.func_190926_b()) continue;
            leftovers.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)next));
        }
        return leftovers;
    }

    static {
        INGREDIENT_TAGGED_FLUID_BUCKET_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("tagged_fluid_bucket"), (IIngredientSerializer)new BucketTaggedFluidIngredient.Serializer());
        INGREDIENT_FLUID_BUCKET_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("fluid_bucket"), (IIngredientSerializer)new BucketFluidIngredient.Serializer());
        INGREDIENT_FILLED_UNIVERSAL_BUCKET_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("filled_bucket"), (IIngredientSerializer)new FilledUniversalBucketIngredientSerializer());
        INGREDIENT_FILLABLE_BUCKET_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("fillable_bucket"), (IIngredientSerializer)new FillableTankIngredient.Serializer());
        INGREDIENT_FILLABLE_BUCKET_OR_TANK_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("fillable_tank"), (IIngredientSerializer)new FillableBucketOrTankIngredientSerializer());
        INGREDIENT_LOOTED_ITEM_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("looted_item"), (IIngredientSerializer)new LootedIngredient.Serializer());
        INGREDIENT_QGRADED_ITEM_SERIALIZER = CraftingHelper.register((ResourceLocation)LibInfo.r("qgraded_item"), (IIngredientSerializer)new QualityGradedIngredient.Serializer());
        _NO_NNADJ = new NutritionNotedShapelessRecipe.NNAdjustment();
    }

    public static final class IngredientNBTSensitive
    extends NBTIngredient {
        public IngredientNBTSensitive(ItemStack stack) {
            super(stack);
        }
    }

    public static final class BucketTaggedFluidIngredient
    extends DynamicMatchIngredient {
        @Nonnull
        final String _match_tag;

        public BucketTaggedFluidIngredient(String tag) {
            this._match_tag = Objects.requireNonNull(tag);
        }

        public boolean test(@Nullable ItemStack input) {
            return Fluids.isBucketOf(input, FluidStack.EMPTY, this._match_tag);
        }

        public IIngredientSerializer<? extends Ingredient> getSerializer() {
            return INGREDIENT_TAGGED_FLUID_BUCKET_SERIALIZER;
        }

        public static final class Serializer
        implements IIngredientSerializer<BucketTaggedFluidIngredient> {
            public void write(PacketBuffer to, BucketTaggedFluidIngredient ingredient) {
                to.func_180714_a(ingredient._match_tag);
            }

            public BucketTaggedFluidIngredient parse(PacketBuffer from) {
                return new BucketTaggedFluidIngredient(from.func_150789_c(Short.MAX_VALUE));
            }

            public BucketTaggedFluidIngredient parse(JsonObject json) {
                return new BucketTaggedFluidIngredient(JSONUtils.func_151200_h((JsonObject)json, (String)"fluid_tag"));
            }
        }
    }

    public static final class CompoundIngredientNBTSensitive
    extends CompoundIngredient {
        public CompoundIngredientNBTSensitive(List<Ingredient> children) {
            super(children);
        }

        public boolean func_203189_d() {
            return this.getChildren().isEmpty();
        }
    }

    public static final class BucketFluidIngredient
    extends NBTIngredient {
        final FluidStack _match;
        @Nonnull
        final String _match_tag;
        final boolean _distinct;
        final IIngredientSerializer<? extends Ingredient> _serializer;

        BucketFluidIngredient(ItemStack bucket_sample, @Nonnull IIngredientSerializer<? extends Ingredient> serializer) {
            super(bucket_sample);
            Validate.isTrue((!bucket_sample.func_190926_b() ? 1 : 0) != 0);
            FluidStack f = FluidUtil.getFluidContained((ItemStack)bucket_sample).orElse(null);
            if (f == null) {
                throw new IllegalArgumentException("Unable to find fluid from input stack: " + bucket_sample);
            }
            this._match = f;
            this._distinct = false;
            this._match_tag = "";
            this._serializer = Objects.requireNonNull(serializer);
        }

        public BucketFluidIngredient(ItemStack bucket_sample) {
            this(bucket_sample, INGREDIENT_FLUID_BUCKET_SERIALIZER);
        }

        BucketFluidIngredient(ItemStack mod_bucket, @Nonnull FluidStack f, @Nullable String tag, @Nonnull IIngredientSerializer<? extends Ingredient> serializer) {
            super(mod_bucket);
            Validate.isTrue((!mod_bucket.func_190926_b() ? 1 : 0) != 0);
            Validate.notNull((Object)f, (String)"A non-null fluid stack is required (use EMPTY for tag only matching)", (Object[])new Object[0]);
            this._match = f;
            this._distinct = !f.isEmpty();
            this._match_tag = StringUtils.trimToEmpty((String)tag);
            this._serializer = Objects.requireNonNull(serializer);
        }

        public BucketFluidIngredient(ItemStack mod_bucket, @Nonnull FluidStack f, @Nullable String tag) {
            this(mod_bucket, f, tag, INGREDIENT_FLUID_BUCKET_SERIALIZER);
        }

        public boolean test(@Nullable ItemStack input) {
            if (Fluids.isBucketOf(input, this._match, this._match_tag)) {
                return true;
            }
            return super.test(input);
        }

        public boolean isSimple() {
            return false;
        }

        public IIngredientSerializer<? extends Ingredient> getSerializer() {
            return this._serializer;
        }

        public static final class Serializer
        implements IIngredientSerializer<BucketFluidIngredient> {
            @Nullable
            static final FluidStack readFluidOrNull(PacketBuffer from) {
                try {
                    FluidStack fs = FluidStack.readFromPacket((PacketBuffer)from);
                    return fs.isEmpty() ? null : fs;
                }
                catch (Throwable t) {
                    return null;
                }
            }

            public void write(PacketBuffer to, BucketFluidIngredient ingredient) {
                to.writeBoolean(ingredient._distinct);
                NBTIngredient.Serializer.INSTANCE.write(to, (NBTIngredient)ingredient);
                to.func_180714_a(ingredient._match_tag);
                if (ingredient._distinct) {
                    ingredient._match.writeToPacket(to);
                }
            }

            public BucketFluidIngredient parse(PacketBuffer from) {
                boolean distinct = from.readBoolean();
                ItemStack mod_bucket = from.func_150791_c();
                String tag = from.func_150789_c(Short.MAX_VALUE);
                FluidStack fs = null;
                if (distinct) {
                    fs = Serializer.readFluidOrNull(from);
                }
                if (fs == null && !tag.isEmpty()) {
                    fs = FluidStack.EMPTY;
                }
                return fs == null ? new BucketFluidIngredient(mod_bucket, this) : new BucketFluidIngredient(mod_bucket, fs, tag, this);
            }

            public BucketFluidIngredient parse(JsonObject json) {
                String tag = JSONUtils.func_151219_a((JsonObject)json, (String)"fluid_tag", (String)"");
                FluidStack fs = null;
                if (JSONUtils.func_151204_g((JsonObject)json, (String)"fluid")) {
                    CompoundNBT fluidnbt = JsonUtils.readNBT((JsonObject)json, (String)"fluid");
                    fs = FluidStack.loadFluidStackFromNBT((CompoundNBT)fluidnbt);
                    if (fs.isEmpty() && tag.isEmpty()) {
                        fs = null;
                    }
                } else if (!tag.isEmpty()) {
                    fs = FluidStack.EMPTY;
                }
                ItemStack mod_bucket = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
                return fs == null ? new BucketFluidIngredient(mod_bucket, this) : new BucketFluidIngredient(mod_bucket, fs, tag, this);
            }
        }
    }

    public static class MultiuseShapelessRecipe
    extends ShapelessRecipeWrapping {
        public static final ShapelessRecipeWrapping.Serializer<MultiuseShapelessRecipe> SERIALIZER = new ShapelessRecipeWrapping.Serializer<MultiuseShapelessRecipe>(MultiuseShapelessRecipe::new);

        MultiuseShapelessRecipe(ShapelessRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }
    }

    public static class MultiuseShapedRecipe
    extends ShapedRecipeWrapping {
        public static final ShapedRecipeWrapping.Serializer<MultiuseShapedRecipe> SERIALIZER = new ShapedRecipeWrapping.Serializer<MultiuseShapedRecipe>(MultiuseShapedRecipe::new);

        MultiuseShapedRecipe(ShapedRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }
    }

    public static class NBTSensitiveCampfireRecipe
    extends CampfireRecipeWrapping {
        public static final CampfireRecipeWrapping.Serializer<NBTSensitiveCampfireRecipe> SERIALIZER = new CampfireRecipeWrapping.Serializer<NBTSensitiveCampfireRecipe>(NBTSensitiveCampfireRecipe::new);

        NBTSensitiveCampfireRecipe(CampfireCookingRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }
    }

    public static class NoLeftoversShapelessRecipe
    extends ShapelessRecipeWrapping {
        public static final ShapelessRecipeWrapping.Serializer<NoLeftoversShapelessRecipe> SERIALIZER = new ShapelessRecipeWrapping.Serializer<NoLeftoversShapelessRecipe>(NoLeftoversShapelessRecipe::new);

        NoLeftoversShapelessRecipe(ShapelessRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }

        public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
            return SharedGlue.emptyNonNullItemStackList(grid.func_70302_i_());
        }
    }

    public static class NoLeftoversShapedRecipe
    extends ShapedRecipeWrapping {
        public static final ShapedRecipeWrapping.Serializer<NoLeftoversShapedRecipe> SERIALIZER = new ShapedRecipeWrapping.Serializer<NoLeftoversShapedRecipe>(NoLeftoversShapedRecipe::new);

        NoLeftoversShapedRecipe(ShapedRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }

        public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
            return SharedGlue.emptyNonNullItemStackList(grid.func_70302_i_());
        }
    }

    public static final class ExampleShapelessRecipe
    extends NoLeftoversShapelessRecipe {
        public static final ShapelessRecipeWrapping.Serializer<ExampleShapelessRecipe> SERIALIZER = new ShapelessRecipeWrapping.Serializer<ExampleShapelessRecipe>(ExampleShapelessRecipe::new);

        ExampleShapelessRecipe(ShapelessRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }

        @Override
        public ItemStack func_77572_b(CraftingInventory grid) {
            return ItemStack.field_190927_a;
        }

        public boolean func_77569_a(CraftingInventory grid, World unused) {
            return false;
        }
    }

    public static final class ExampleShapedRecipe
    extends ShapedRecipeWrapping {
        public static final ShapedRecipeWrapping.Serializer<ExampleShapedRecipe> SERIALIZER = new ShapedRecipeWrapping.Serializer<ExampleShapedRecipe>(ExampleShapedRecipe::new);

        ExampleShapedRecipe(ShapedRecipe from) {
            super(from);
        }

        @Override
        public IRecipeSerializer<?> func_199559_b() {
            return SERIALIZER;
        }

        @Override
        public ItemStack func_77572_b(CraftingInventory grid) {
            return ItemStack.field_190927_a;
        }

        public boolean func_77569_a(CraftingInventory grid, World unused) {
            return false;
        }
    }

    static final class FilledUniversalBucketIngredientSerializer
    implements IIngredientSerializer<Ingredient> {
        FilledUniversalBucketIngredientSerializer() {
        }

        public Ingredient parse(JsonObject json) {
            return JR.readFullBucketIngredient(json, INGREDIENT_FLUID_BUCKET_SERIALIZER);
        }

        public void write(PacketBuffer to, Ingredient ingredient) {
            CraftingHelper.write((PacketBuffer)to, (Ingredient)ingredient);
        }

        public Ingredient parse(PacketBuffer from) {
            return Ingredient.func_199566_b((PacketBuffer)from);
        }
    }

    public static final class FillableTankIngredient
    extends DynamicMatchIngredient {
        final int _min_mB;
        final boolean _want_empty;
        public static final Ingredient ForEmptyBucket = new FillableTankIngredient(1000, true);
        public static final Ingredient ForBucket = new FillableTankIngredient(1000, false);

        public FillableTankIngredient(int mB, boolean empty) {
            this._min_mB = mB;
            this._want_empty = empty;
        }

        public boolean test(@Nullable ItemStack input) {
            boolean match = false;
            IFluidHandlerItem fspi = ItemStacks.getFluidHandler(input);
            if (fspi != null) {
                for (int i = 0; i < fspi.getTanks(); ++i) {
                    FluidStack contents;
                    int cap = fspi.getTankCapacity(i);
                    if (cap < this._min_mB || !(contents = fspi.getFluidInTank(i)).isEmpty() && cap - contents.getAmount() < this._min_mB) continue;
                    match = !this._want_empty || this._want_empty && (contents.isEmpty() || contents.getAmount() == 0);
                    break;
                }
            }
            return match;
        }

        public IIngredientSerializer<? extends Ingredient> getSerializer() {
            return INGREDIENT_FILLABLE_BUCKET_SERIALIZER;
        }

        public static final class Serializer
        implements IIngredientSerializer<FillableTankIngredient> {
            public void write(PacketBuffer to, FillableTankIngredient ingredient) {
                to.writeBoolean(ingredient._want_empty);
                to.func_150787_b(ingredient._min_mB);
            }

            public FillableTankIngredient parse(PacketBuffer from) {
                boolean empty = from.readBoolean();
                int mB = from.func_150792_a();
                return new FillableTankIngredient(mB, empty);
            }

            public FillableTankIngredient parse(JsonObject json) {
                int min_mB = 1000;
                int fillAmount = JSONUtils.func_151208_a((JsonObject)json, (String)"min_capacity", (int)-1);
                if (fillAmount > 0) {
                    min_mB = fillAmount;
                }
                boolean empty = JSONUtils.func_151209_a((JsonObject)json, (String)"empty", (boolean)false);
                return new FillableTankIngredient(min_mB, empty);
            }
        }
    }

    static final class FillableBucketOrTankIngredientSerializer
    implements IIngredientSerializer<Ingredient> {
        FillableBucketOrTankIngredientSerializer() {
        }

        public Ingredient parse(JsonObject json) {
            return JR.readFillableBucketOrTank(json);
        }

        public void write(PacketBuffer to, Ingredient ingredient) {
            CraftingHelper.write((PacketBuffer)to, (Ingredient)ingredient);
        }

        public Ingredient parse(PacketBuffer from) {
            return Ingredient.func_199566_b((PacketBuffer)from);
        }
    }

    public static final class LootedIngredient
    extends Ingredient {
        final String _modid;

        public LootedIngredient(Stream<? extends Ingredient.IItemList> match) {
            this(null, match);
        }

        public LootedIngredient(@Nullable String modid, Stream<? extends Ingredient.IItemList> match) {
            super(match);
            this._modid = modid != null ? modid : "";
        }

        private boolean isLooted(@Nullable ItemStack input) {
            String modid = this._modid.isEmpty() ? null : this._modid;
            return Instructions.isLooted(input, modid) || modid == null && ItemStacks.hasFlag(input, "Looted", false);
        }

        public boolean test(@Nullable ItemStack input) {
            return this.isLooted(input) && super.test(input);
        }

        public IIngredientSerializer<? extends Ingredient> getSerializer() {
            return INGREDIENT_LOOTED_ITEM_SERIALIZER;
        }

        public static final class Serializer
        implements IIngredientSerializer<LootedIngredient> {
            public void write(PacketBuffer to, LootedIngredient ingredient) {
                to.func_180714_a(ingredient._modid);
                VanillaIngredientSerializer.INSTANCE.write(to, (Ingredient)ingredient);
            }

            public LootedIngredient parse(PacketBuffer from) {
                String mod_id = from.func_150789_c(Short.MAX_VALUE);
                return new LootedIngredient(mod_id, Stream.generate(() -> new Ingredient.SingleItemList(from.func_150791_c())).limit(from.func_150792_a()));
            }

            public LootedIngredient parse(JsonObject json) {
                String mod_id = JSONUtils.func_151219_a((JsonObject)json, (String)"looted_from", null);
                return new LootedIngredient(mod_id, Stream.of(Ingredient.func_199803_a((JsonObject)json)));
            }
        }
    }

    public static final class QualityGradedIngredient
    extends Ingredient {
        final QualityGrade _qgrade;

        public QualityGradedIngredient(Stream<? extends Ingredient.IItemList> match) {
            this(null, match);
        }

        public QualityGradedIngredient(@Nullable QualityGrade grade, Stream<? extends Ingredient.IItemList> match) {
            super(match);
            this._qgrade = grade;
        }

        private boolean isGraded(@Nullable ItemStack input) {
            return this._qgrade == null ? QualityGrade.isDefined(input) : QualityGrade.isEqualOrBetter(input, this._qgrade);
        }

        public boolean test(@Nullable ItemStack input) {
            return this.isGraded(input) && super.test(input);
        }

        public IIngredientSerializer<? extends Ingredient> getSerializer() {
            return INGREDIENT_QGRADED_ITEM_SERIALIZER;
        }

        public static final class Serializer
        implements IIngredientSerializer<QualityGradedIngredient> {
            public void write(PacketBuffer to, QualityGradedIngredient ingredient) {
                to.func_180714_a(ingredient._qgrade == null ? "-" : ingredient._qgrade.func_176610_l());
                VanillaIngredientSerializer.INSTANCE.write(to, (Ingredient)ingredient);
            }

            public QualityGradedIngredient parse(PacketBuffer from) {
                String grade_name = from.func_150789_c(Short.MAX_VALUE);
                QualityGrade grade = grade_name.isEmpty() || "-".equals(grade_name) ? null : QualityGrade.findOrDefault(grade_name, QualityGrade.HIGHEST);
                return new QualityGradedIngredient(grade, Stream.generate(() -> new Ingredient.SingleItemList(from.func_150791_c())).limit(from.func_150792_a()));
            }

            public QualityGradedIngredient parse(JsonObject json) {
                String grade_name = JSONUtils.func_151219_a((JsonObject)json, (String)"grade", null);
                QualityGrade grade = grade_name == null || "-".equals(grade_name) ? null : QualityGrade.findOrDefault(grade_name, QualityGrade.HIGHEST);
                return new QualityGradedIngredient(grade, Stream.of(Ingredient.func_199803_a((JsonObject)json)));
            }
        }
    }

    public static abstract class DynamicMatchIngredient
    extends Ingredient {
        protected DynamicMatchIngredient() {
            super(Stream.empty());
        }

        public boolean isSimple() {
            return false;
        }

        public boolean func_203189_d() {
            return false;
        }
    }
}

