/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.ItemStacks;

public class MultiItemCookingRecipeSerializer<T extends AbstractCookingRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    final int _cookingTime;
    final RFactory<T> _recipeFactory;

    public MultiItemCookingRecipeSerializer(String recipe_id, RFactory<T> recipe_factory, int cooking_time) {
        this._recipeFactory = recipe_factory;
        this._cookingTime = cooking_time;
        super.setRegistryName(recipe_id);
    }

    public T read(ResourceLocation recipeId, JsonObject json) {
        String group = JSONUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
        JsonArray ingredient_json = JSONUtils.func_151202_d((JsonObject)json, (String)"ingredient") ? JSONUtils.func_151214_t((JsonObject)json, (String)"ingredient") : JSONUtils.func_152754_s((JsonObject)json, (String)"ingredient");
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)ingredient_json);
        ResourceLocation result_rid = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"result"));
        ItemStack result = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(result_rid));
        if (ItemStacks.isEmpty(result)) {
            throw new JsonParseException(result_rid + " does not exist");
        }
        int count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)-1);
        if (count > 0) {
            result.func_190920_e(count);
        }
        float experience = JSONUtils.func_151221_a((JsonObject)json, (String)"experience", (float)0.0f);
        int cooking_ticks = JSONUtils.func_151208_a((JsonObject)json, (String)"cookingtime", (int)this._cookingTime);
        return this._recipeFactory.create(recipeId, group, ingredient, result, experience, cooking_ticks);
    }

    public void write(PacketBuffer data, T recipe) {
        data.func_180714_a(recipe.func_193358_e());
        ((Ingredient)recipe.func_192400_c().get(0)).func_199564_a(data);
        data.func_150788_a(recipe.func_77571_b());
        data.writeFloat(recipe.func_222138_b());
        data.func_150787_b(recipe.func_222137_e());
    }

    public T read(ResourceLocation recipeId, PacketBuffer buffer) {
        String group = buffer.func_150789_c(1024);
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        ItemStack result = buffer.func_150791_c();
        float experience = buffer.readFloat();
        int cooking_ticks = buffer.func_150792_a();
        return this._recipeFactory.create(recipeId, group, ingredient, result, experience, cooking_ticks);
    }

    public static interface RFactory<T extends AbstractCookingRecipe> {
        public T create(ResourceLocation var1, String var2, Ingredient var3, ItemStack var4, float var5, int var6);
    }
}

