/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.lib.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.NutritionNote;
import org.jwaresoftware.mcmods.lib.recipes.JR;
import org.jwaresoftware.mcmods.lib.recipes.ShapelessRecipeWrapping;

public class NutritionNotedShapelessRecipe
extends ShapelessRecipeWrapping {
    @Nullable
    final NNAdjustment _nnadj;
    final boolean _cleanwipe;

    NutritionNotedShapelessRecipe(boolean wipe, @Nullable NNAdjustment nnadj, ShapelessRecipe from) {
        super(from);
        this._nnadj = nnadj;
        this._cleanwipe = wipe;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return Serializer.INSTANCE;
    }

    @Override
    public ItemStack func_77571_b() {
        return JR.safeNotifyCookedOrCrafted(ItemStacks.copy(super.func_77571_b()), (IInventory)null, this._nnadj);
    }

    @Override
    public ItemStack func_77572_b(CraftingInventory grid) {
        return JR.safeNotifyCookedOrCrafted(this.baseline_getCraftingResult(grid), (IInventory)grid, this._nnadj);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory grid) {
        return this._cleanwipe ? SharedGlue.emptyNonNullItemStackList(grid.func_70302_i_()) : super.func_179532_b((IInventory)grid);
    }

    static final class NNAdjustment {
        long set;
        long exclude;
        long include;
        private boolean _touched;

        NNAdjustment() {
        }

        @Nullable
        static final NNAdjustment deserialize_outof(JsonElement elem) {
            NNAdjustment nn = null;
            if (elem != null && !elem.isJsonNull()) {
                if (elem.isJsonPrimitive()) {
                    long val = NutritionNote.fromList(elem.getAsString(), false, 0L, -111L);
                    if (val == -111L) {
                        throw new JsonSyntaxException("Invalid nutrition note value: " + elem.getAsString());
                    }
                    nn = new NNAdjustment();
                    nn.set = val;
                    nn._touched = true;
                } else {
                    long val;
                    String s;
                    String elem_name;
                    JsonObject json = elem.getAsJsonObject();
                    nn = new NNAdjustment();
                    String string = elem_name = json.has("set") ? "set" : "value";
                    if (json.has(elem_name)) {
                        s = JSONUtils.func_151200_h((JsonObject)json, (String)elem_name);
                        val = NutritionNote.fromList(s, false, 0L, -111L);
                        if (val == -111L) {
                            throw new JsonSyntaxException("Invalid nutrition note value: " + s);
                        }
                        nn.set = val;
                        nn._touched = true;
                    }
                    String string2 = elem_name = json.has("include") ? "include" : "add";
                    if (json.has(elem_name)) {
                        s = JSONUtils.func_151200_h((JsonObject)json, (String)elem_name);
                        val = NutritionNote.fromList(s, false, 0L, -113L);
                        if (val == -113L) {
                            throw new JsonSyntaxException("Invalid nutrition note value: " + s);
                        }
                        nn.include = val;
                        nn._touched = true;
                    }
                    String string3 = elem_name = json.has("exclude") ? "exclude" : "remove";
                    if (json.has(elem_name)) {
                        s = JSONUtils.func_151200_h((JsonObject)json, (String)elem_name);
                        val = NutritionNote.fromList(s, false, 0L, -113L);
                        if (val == -113L) {
                            throw new JsonSyntaxException("Invalid nutrition note value: " + s);
                        }
                        nn.exclude = val;
                        nn._touched = true;
                    }
                    if (!nn._touched) {
                        nn = null;
                    }
                }
            }
            return nn;
        }

        static final void save(PacketBuffer into, @Nullable NNAdjustment nn) {
            if (nn == null || !nn._touched) {
                into.writeBoolean(false);
            } else {
                into.writeBoolean(true);
                into.writeLong(nn.set);
                into.writeLong(nn.exclude);
                into.writeLong(nn.include);
            }
        }

        @Nullable
        static final NNAdjustment read(PacketBuffer from) {
            NNAdjustment nn = null;
            if (from.readBoolean()) {
                nn = new NNAdjustment();
                nn.set = from.readLong();
                nn.exclude = from.readLong();
                nn.include = from.readLong();
            }
            return nn;
        }
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<NutritionNotedShapelessRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public NutritionNotedShapelessRecipe read(ResourceLocation recipeId, JsonObject json) {
            NNAdjustment nnadj = NNAdjustment.deserialize_outof(json.get("nnotes"));
            boolean wipe = JSONUtils.func_151209_a((JsonObject)json, (String)"cleanwipe", (boolean)false);
            return new NutritionNotedShapelessRecipe(wipe, nnadj, JR.readShapeless(recipeId, json));
        }

        public void write(PacketBuffer data, NutritionNotedShapelessRecipe recipe) {
            data.writeBoolean(recipe._cleanwipe);
            NNAdjustment.save(data, recipe._nnadj);
            JR.writeShapeless(data, recipe);
        }

        public NutritionNotedShapelessRecipe read(ResourceLocation recipeId, PacketBuffer data) {
            boolean wipe = data.readBoolean();
            NNAdjustment nnadj = NNAdjustment.read(data);
            return new NutritionNotedShapelessRecipe(wipe, nnadj, JR.readShapeless(recipeId, data));
        }
    }
}

