/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStackDef;
import org.jwaresoftware.mcmods.lib.Misc;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.vfp.common.DictionaryNameItemAdaptor;
import org.jwaresoftware.mcmods.vfp.common.Named;

public class Ingredient
implements Named {
    public static final String UNUSED_TAG = "unused";
    private final String _name;
    private final int _id;
    private final int _multiplier;
    private int _mask;
    private ItemStackDef _itemdef;
    private final boolean _isBlock;
    private final boolean _isTag;
    private BooleanSupplier _enabled = Misc.ALWAYS_TRUE;

    public Ingredient(String name, int id, ItemStackDef itemdef) {
        this(name, id, itemdef, 1);
    }

    public Ingredient(String name, int id, ItemStackDef itemDef, int multiplier) {
        boolean check = !StringUtils.isBlank((CharSequence)name) && itemDef != null && !itemDef.isEmpty();
        Validate.isTrue((boolean)check, (String)"Valid parameters for any ingredient are name and ingredient definition", (Object[])new Object[0]);
        this._id = id;
        this._name = name;
        this._itemdef = itemDef;
        this._multiplier = Math.min(SharedGlue.TABLE_CRAFT_GRID_SIZE(), multiplier);
        this._isBlock = itemDef.item instanceof BlockItem;
        this._isTag = DictionaryNameItemAdaptor.isa(itemDef);
        if (this._isTag && !this.isPlaceholder()) {
            this._enabled = () -> SharedGlue.ingredientDefined((String)this.recipeitemName());
        }
    }

    public Ingredient(String name, int id, String dictKey) {
        this(name, id, new ItemStackDef((Item)new DictionaryNameItemAdaptor(dictKey)));
    }

    public Ingredient(String name, int id, String dictKey, int amount, int multiplier) {
        this(name, id, new ItemStackDef((Item)new DictionaryNameItemAdaptor(dictKey), amount), multiplier);
    }

    public final int id() {
        return this._id;
    }

    @Override
    @Nonnull
    public final String name() {
        return this._name;
    }

    @Nonnull
    public final ItemStack recipeitem() {
        return this._itemdef.get();
    }

    public final int multiplier() {
        return this._multiplier;
    }

    public final boolean isTag() {
        return this._isTag;
    }

    @Nullable
    public final String recipeitemName() {
        return this._isTag ? ((DictionaryNameItemAdaptor)this._itemdef.item).dictionaryName() : null;
    }

    public final int attributes() {
        return this._mask;
    }

    public final void attributes(int newmask) {
        this._mask = newmask;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Ingredient) {
            boolean match;
            Ingredient other = (Ingredient)o;
            Item mine = this._itemdef.item;
            Item theirs = other._itemdef.item;
            boolean bl = match = this._isBlock == other._isBlock && this._isTag == other._isTag && this._itemdef.item != null && other._itemdef.item != null && this._itemdef.item.func_77658_a().equals(other._itemdef.item.func_77658_a()) || this._itemdef.item == null && other._itemdef.item == null && StringUtils.equals((CharSequence)this._itemdef.getHolderRef(), (CharSequence)other._itemdef.getHolderRef());
            if (match) {
                match = this._isTag ? this.recipeitemName().equals(other.recipeitemName()) : (this._isBlock ? ((BlockItem)mine).func_179223_d().getClass().equals(((BlockItem)theirs).func_179223_d().getClass()) : mine.getClass().equals(theirs.getClass()));
            }
        }
        return false;
    }

    public int hashCode() {
        return 32 * this._id + this._itemdef.item.func_77658_a().hashCode();
    }

    public final void setEnabled(@Nonnull BooleanSupplier flag) {
        this._enabled = flag;
    }

    public boolean isEnabled() {
        return !this._itemdef.isEmpty() && this._enabled.getAsBoolean();
    }

    public boolean isPlaceholder() {
        return this._itemdef == ItemStackDef.UNUSED || UNUSED_TAG.equals(this.recipeitemName());
    }

    public String toString() {
        if (this.isPlaceholder()) {
            return "*PLACEHOLDER*";
        }
        String enabled = this.isEnabled() ? "Y|" : "N|";
        return enabled + this._name + "@" + this._id + "[tag=" + this._isTag + "/x" + this._multiplier + ",itm=" + this._itemdef + "]";
    }
}

