/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.fluid.Fluid;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.ArrayUtils;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

@ParametersAreNonnullByDefault
public final class PackagedFood
implements Comparable<PackagedFood> {
    private static final Map<String, Integer> TYPE_GROUPS = new Hashtable<String, Integer>();
    private static final Map<ResourceLocation, PackagedFood> FOODS = new ConcurrentHashMap<ResourceLocation, PackagedFood>(3271, 0.75f, 2);
    public static final PackagedFood BREAD = new PackagedFood(Type.bakery, "bread", "bread", LikeFood.bread);
    public static final PackagedFood ENRICHED_BREAD = new PackagedFood(Type.bakery, ModInfo.rstring("enriched_bread"), "enriched_bread", LikeFood.enriched_bread);
    public static final PackagedFood CAKE = new PackagedFood(Type.bakery, "cake", "cakes", LikeFood.cake, VfpCapacity.HALF_TRAY, VfpCapacity.SMALL_STACK);
    public static final PackagedFood PUMPKIN_PIE = new PackagedFood(Type.bakery, "pumpkin_pie", "pumpkin_pies", LikeFood.pumpkin_pie, VfpCapacity.BAKERS_TRAY, VfpCapacity.MEDIUM_STACK);
    public static final PackagedFood COOKIE = new PackagedFood(Type.bakery, "cookie", "cookies", LikeFood.cookie, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood EGG_PIE = new PackagedFood(Type.bakery, ModInfo.rstring("egg_pie"), "egg_pies", LikeFood.egg_pie, VfpCapacity.BAKERS_TRAY, VfpCapacity.MEDIUM_STACK);
    public static final PackagedFood POTATO = new PackagedFood(Type.vegetable, "potato", "potatoes", LikeFood.uncooked_potato, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood CARROT = new PackagedFood(Type.vegetable, "carrot", "carrots", LikeFood.uncooked_carrot, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood BEETROOT = new PackagedFood(Type.vegetable, "beetroot", "beetroots", LikeFood.uncooked_beetroot, VfpCapacity.SMALL_CROP_BUNDLE, VfpCapacity.BULK_STACK);
    public static final PackagedFood BROWN_MUSHROOM = new PackagedFood(Type.vegetable, "brown_mushroom", "brown_mushrooms", LikeFood.mushroom, VfpCapacity.SMALL_CROP_BUNDLE, VfpCapacity.BULK_STACK);
    public static final PackagedFood RED_MUSHROOM = new PackagedFood(Type.vegetable, "red_mushroom", "red_mushrooms", LikeFood.red_mushroom, VfpCapacity.SMALL_CROP_BUNDLE, VfpCapacity.BULK_STACK);
    public static final PackagedFood GREEN_KELP = new PackagedFood(Type.vegetable, ModInfo.rstring("washed_kelp_niblet"), "green_kelp", LikeFood.raw_veg_medley, VfpCapacity.LEAFY_CROP_BUNDLE, VfpCapacity.BULK_STACK, ContainerHint.TIE);
    public static final PackagedFood INK_KELP = new PackagedFood(Type.vegetable, ModInfo.rstring("ink_kelp"), "ink_kelp", LikeFood.raw_veg_medley, VfpCapacity.LEAFY_CROP_BUNDLE, VfpCapacity.BULK_STACK, ContainerHint.TIE);
    public static final PackagedFood RED_APPLE = new PackagedFood(Type.fruit, "apple", "red_apples", LikeFood.apple, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood CHORUS_FRUIT = new PackagedFood(Type.fruit, "chorus_fruit", "chorus_fruit", LikeFood.chorus_fruit, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood SWEET_BERRIES = new PackagedFood(Type.fruit, "sweet_berries", "sweet_berries", LikeFood.sweet_berries, VfpCapacity.TINY_CROP_BUNDLE, VfpCapacity.BULK_STACK);
    public static final PackagedFood COCOA_BEANS = new PackagedFood(Type.general, "cocoa_beans", "cocoa_beans", LikeFood.cocoa_seed, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood SUGARCANE = new PackagedFood(Type.general, "sugar_cane", "sugar_cane", LikeFood.cane_section, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood RAW_SUGAR = new PackagedFood(Type.general, ModInfo.rstring("hardened_sugar"), "hardened_sugar", LikeFood.hardened_sugar);
    public static final PackagedFood BAD_TATOES = new PackagedFood(Type.general, "poisonous_potato", "green_potatoes", LikeFood.bad_potato, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood CHICKEN_EGG = new PackagedFood(Type.meat, "egg", "chicken_eggs", LikeFood.uncooked_egg, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood FRIED_CHICKEN_EGG = new PackagedFood(Type.cooked_meat, ModInfo.rstring("fried_egg"), "fried_eggs", LikeFood.fried_egg);
    public static final PackagedFood STEAMED_CHICKEN_EGG = new PackagedFood(Type.cooked_meat, ModInfo.rstring("steamed_egg"), "steamed_eggs", LikeFood.egg);
    public static final PackagedFood CHICKEN = new PackagedFood(Type.meat, "chicken", "chicken", LikeFood.uncooked_chicken);
    public static final PackagedFood COOKED_CHICKEN = new PackagedFood(Type.cooked_meat, "cooked_chicken", "chicken_cooked", LikeFood.chicken);
    public static final PackagedFood CODFISH = new PackagedFood(Type.meat, "cod", "cod", LikeFood.uncooked_fish, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood COOKED_CODFISH = new PackagedFood(Type.cooked_meat, "cooked_cod", "cod_cooked", LikeFood.fish);
    public static final PackagedFood SALMON = new PackagedFood(Type.meat, "salmon", "salmon", LikeFood.uncooked_salmon, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood COOKED_SALMON = new PackagedFood(Type.cooked_meat, "cooked_salmon", "salmon_cooked", LikeFood.salmon);
    public static final PackagedFood PUFFERFISH = new PackagedFood(Type.meat, ModInfo.rstring("pufferfish_raw_cleaned"), "pufferfish", LikeFood.uncooked_pufferfish, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood COOKED_PUFFERFISH = new PackagedFood(Type.cooked_meat, ModInfo.rstring("pufferfish_cooked"), "pufferfish_cooked", LikeFood.pufferfish);
    public static final PackagedFood PORK = new PackagedFood(Type.meat, "porkchop", "pork", LikeFood.uncooked_pork);
    public static final PackagedFood COOKED_PORK = new PackagedFood(Type.cooked_meat, "cooked_porkchop", "pork_cooked", LikeFood.pork);
    public static final PackagedFood BEEF = new PackagedFood(Type.meat, "beef", "beef", LikeFood.uncooked_beef);
    public static final PackagedFood COOKED_BEEF = new PackagedFood(Type.cooked_meat, "cooked_beef", "beef_cooked", LikeFood.beef);
    public static final PackagedFood MUTTON = new PackagedFood(Type.meat, "mutton", "mutton", LikeFood.uncooked_mutton);
    public static final PackagedFood COOKED_MUTTON = new PackagedFood(Type.cooked_meat, "cooked_mutton", "mutton_cooked", LikeFood.mutton);
    public static final PackagedFood RABBIT = new PackagedFood(Type.meat, "rabbit", "rabbit", LikeFood.uncooked_rabbit);
    public static final PackagedFood COOKED_RABBIT = new PackagedFood(Type.cooked_meat, "cooked_rabbit", "rabbit_cooked", LikeFood.rabbit);
    public static final PackagedFood HORSE = new PackagedFood(Type.meat, ModInfo.rstring("horse_raw"), "horse", LikeFood.uncooked_horse);
    public static final PackagedFood COOKED_HORSE = new PackagedFood(Type.cooked_meat, ModInfo.rstring("horse_cooked"), "horse_cooked", LikeFood.horse);
    public static final PackagedFood WOLF = new PackagedFood(Type.meat, ModInfo.rstring("wolf_raw"), "wolf", LikeFood.uncooked_wolf);
    public static final PackagedFood COOKED_WOLF = new PackagedFood(Type.cooked_meat, ModInfo.rstring("wolf_cooked"), "wolf_cooked", LikeFood.wolf);
    public static final PackagedFood SQUID = new PackagedFood(Type.meat, ModInfo.rstring("squidd_raw"), "squid", LikeFood.uncooked_squid);
    public static final PackagedFood COOKED_SQUID = new PackagedFood(Type.cooked_meat, ModInfo.rstring("squidd_cooked"), "squid_cooked", LikeFood.squid);
    public static final PackagedFood PORK_HOCKS = new PackagedFood(Type.meat, ModInfo.rstring("hocks_raw"), "hocks", LikeFood.uncooked_pork_hocks);
    public static final PackagedFood SALTED_PORK_HOCKS = new PackagedFood(Type.meat, ModInfo.rstring("hocks_raw_salted"), "hocks_salted", LikeFood.uncooked_pork_hocks);
    public static final PackagedFood COOKED_PORK_HOCKS = new PackagedFood(Type.cooked_meat, ModInfo.rstring("hocks_cooked"), "hocks_smoked", LikeFood.smoked_pork_hocks);
    public static final PackagedFood PIGTAILS = new PackagedFood(Type.meat, ModInfo.rstring("pigtail_raw"), "pigtails", LikeFood.uncooked_pigtail);
    public static final PackagedFood SALTED_PIGTAILS = new PackagedFood(Type.meat, ModInfo.rstring("pigtail_salted"), "pigtails_salted", LikeFood.uncooked_pigtail);
    public static final PackagedFood LLAMA = new PackagedFood(Type.meat, ModInfo.rstring("llama_raw"), "llama", LikeFood.uncooked_llama);
    public static final PackagedFood COOKED_LLAMA = new PackagedFood(Type.cooked_meat, ModInfo.rstring("llama_cooked"), "llama_cooked", LikeFood.llama);
    public static final PackagedFood ROTTEN_FLESH = new PackagedFood(Type.meat, "rotten_flesh", "rotten_flesh", LikeFood.rotten_flesh, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood SANITIZED_ROTTEN_FLESH = new PackagedFood(Type.meat, ModInfo.rstring("sanitized_flesh"), "spam_raw", LikeFood.sanitized_flesh, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood BONES = new PackagedFood(Type.meat, "bone", "bones", LikeFood.bone, null, VfpCapacity.BULK_STACK);
    public static final PackagedFood INK_SAC = new PackagedFood(Type.liquids, "ink_sac", "squidink", LikeFood.air, null, VfpCapacity.LIQUID_STACK, ContainerHint.JAR);
    public static final PackagedFood LUMINESCE_SAC = new PackagedFood(Type.liquids, "superblocks:luminesce_sac", "luminesce", LikeFood.air, null, VfpCapacity.LIQUID_STACK, ContainerHint.JAR);
    public static final PackagedFood FRYEGG_SANDWICHES = new PackagedFood(Type.sandwiches, ModInfo.rstring("fried_egg_sandwich"), "sandwich_fryegg", LikeFood.fryegg_sandwich);
    public static final PackagedFood CHEESE_SANDWICHES = new PackagedFood(Type.sandwiches, ModInfo.rstring("cheese_sandwich"), "sandwich_cheeze", LikeFood.cheese_sandwich);
    public static final PackagedFood HAMEGG_SANDWICHES = new PackagedFood(Type.sandwiches, ModInfo.rstring("ham_egg_sandwich"), "sandwich_hamegg", LikeFood.hamegg_sandwich);
    private final String _typeid;
    private final ResourceLocation _id;
    private final int _meta;
    private final String _name;
    private final LikeFood _food;
    private final VfpCapacity _capacity;
    private final Integer _maxstack;
    private final ContainerHint _container;

    private PackagedFood(Type type, String rid, String name, LikeFood like) {
        this(type.name(), new ResourceLocation(rid), name, like, ContainerHint.BAG);
    }

    public PackagedFood(String type, ResourceLocation rid, String short_name, @Nonnull LikeFood like, ContainerHint c) {
        this._typeid = type;
        this._meta = PackagedFood.incr(type);
        this._id = Objects.requireNonNull(rid);
        this._food = Objects.requireNonNull(like);
        this._name = short_name;
        this._capacity = null;
        this._maxstack = VfpCapacity.LARGE_STACK.count();
        this._container = c != null ? c : ContainerHint.BAG;
        FOODS.putIfAbsent(rid, this);
    }

    public PackagedFood(Type type, String rid, String name, LikeFood like, VfpCapacity cap, VfpCapacity max) {
        this(type.name(), new ResourceLocation(rid), name, like, cap, max, ContainerHint.BAG);
    }

    private PackagedFood(Type type, String rid, String name, LikeFood like, VfpCapacity cap, VfpCapacity max, ContainerHint c) {
        this(type.name(), new ResourceLocation(rid), name, like, cap, max, c);
    }

    public PackagedFood(String type, ResourceLocation rid, String short_name, LikeFood like, VfpCapacity cap, VfpCapacity maxstk, ContainerHint c) {
        this._typeid = type;
        this._meta = PackagedFood.incr(type);
        this._id = Objects.requireNonNull(rid);
        this._food = Objects.requireNonNull(like);
        this._name = short_name;
        this._capacity = cap;
        this._maxstack = maxstk != null ? maxstk.count() : VfpCapacity.LARGE_STACK.count();
        this._container = c != null ? c : ContainerHint.BAG;
        FOODS.putIfAbsent(rid, this);
    }

    public final int typemeta() {
        return this._meta;
    }

    public final String type() {
        return this._typeid;
    }

    public final ResourceLocation id() {
        return this._id;
    }

    public final String fmlid_suffix() {
        return this._name;
    }

    public final LikeFood food() {
        return this._food;
    }

    public final ContainerHint container() {
        return this._container;
    }

    public final VfpCapacity capacity() {
        return this._capacity;
    }

    public final Integer maxstack() {
        return this._maxstack;
    }

    public final ItemStack sample() {
        int n;
        ItemStack out = ItemStacks.create((ResourceLocation)this._id);
        if (out.func_190926_b()) {
            out = this._food.sample();
        }
        int n2 = n = this.capacity() != null ? this.capacity().count() : VfpCapacity.TRAY.count();
        if (!out.func_190926_b()) {
            out.func_190920_e(n);
        }
        return out;
    }

    @Nonnull
    public final Fluid samplefluid() {
        Fluid f = Fluids.NO_FLUID;
        if (this.container() == ContainerHint.JAR && Fluids.isDefined((ResourceLocation)this._id)) {
            f = Fluids.getFluid((String)this._id.toString());
        }
        return f;
    }

    @Override
    public int compareTo(PackagedFood o) {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o == this) {
            return 0;
        }
        int i = this._typeid.compareTo(o._typeid);
        if (i == 0) {
            i = this._meta > o._meta ? 1 : (this._meta < o._meta ? -1 : 0);
        }
        return i;
    }

    public String toString() {
        return this._typeid + "/" + this._name + "@" + this._meta + "[cap=" + (Object)((Object)this._capacity) + ",max=" + this._maxstack + "] for " + this._food;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int incr(String typeid) {
        Integer I;
        Map<String, Integer> map = TYPE_GROUPS;
        synchronized (map) {
            I = TYPE_GROUPS.get(typeid);
            I = I == null ? Integer.valueOf(0) : Integer.valueOf(I + 1);
            TYPE_GROUPS.put(typeid, I);
        }
        return I;
    }

    public static final String[] groups() {
        return TYPE_GROUPS.keySet().toArray(ArrayUtils.EMPTY_STRING_ARRAY);
    }

    public static final boolean known(String typeid) {
        return TYPE_GROUPS.containsKey(typeid);
    }

    private static final VfpVariant _new_variant(PackagedFood pf, int index, String fmlid) {
        return new VfpVariant(index, fmlid, pf._food, pf._capacity, pf._maxstack, pf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final VfpVariant[] init(String typeid, boolean shortnames, int idoffset, List<PackagedFood> exclusions) {
        if (!PackagedFood.known(typeid)) {
            return null;
        }
        if (exclusions == null) {
            exclusions = Collections.EMPTY_LIST;
        }
        ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(271);
        Map<ResourceLocation, PackagedFood> map = FOODS;
        synchronized (map) {
            for (PackagedFood pf : FOODS.values()) {
                VfpVariant variant;
                int index;
                if (!typeid.equals(pf.type()) || exclusions.contains(pf)) continue;
                String fmlid = shortnames ? pf.fmlid_suffix() : pf.container().prefix() + pf.fmlid_suffix();
                int n = index = exclusions.isEmpty() ? pf._meta : variants.size();
                if (idoffset > 0) {
                    int id = idoffset + pf._meta;
                    variant = new VfpTransientVariant(index, id, fmlid, pf._food, pf._capacity, pf._maxstack, pf, null);
                } else {
                    variant = PackagedFood._new_variant(pf, index, fmlid);
                }
                variants.add(variant);
            }
        }
        Collections.sort(variants);
        return variants.toArray(VfpVariant.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final VfpVariant[] init(Type type, String what, Item innerContainerItem, VfpVariant[] contained, List<PackagedFood> filter, boolean exclusion) {
        if (filter == null) {
            filter = Collections.EMPTY_LIST;
        }
        ArrayList<VfpVariant> variants = new ArrayList<VfpVariant>(271);
        Map<ResourceLocation, PackagedFood> map = FOODS;
        synchronized (map) {
            for (PackagedFood pf : FOODS.values()) {
                if (!type.name().equals(pf.type()) || (!exclusion || filter.contains(pf)) && (exclusion || !filter.contains(pf))) continue;
                String fmlid = what + "_" + pf.fmlid_suffix();
                ItemStack subcontainer = null;
                for (VfpVariant inner : contained) {
                    if (inner.metadata() != pf._meta + type.shared_metaoffset()) continue;
                    subcontainer = new ItemStack((IItemProvider)innerContainerItem, VfpCapacity.TRAY.count());
                    break;
                }
                VfpVariant variant = subcontainer != null ? new VfpVariant(-1, fmlid, null, pf._capacity, pf._maxstack, subcontainer, null) : PackagedFood._new_variant(pf, -1, fmlid);
                variants.add(variant);
            }
        }
        Collections.sort(variants);
        return variants.toArray(VfpVariant.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final List<PackagedFood> values(String typeid, boolean exclusion, @Nullable List<PackagedFood> filter) {
        if (!PackagedFood.known(typeid)) {
            return null;
        }
        if (filter == null) {
            filter = Collections.EMPTY_LIST;
        }
        ArrayList<PackagedFood> matches = new ArrayList<PackagedFood>(101);
        Map<ResourceLocation, PackagedFood> map = FOODS;
        synchronized (map) {
            for (PackagedFood pf : FOODS.values()) {
                if (!typeid.equals(pf.type()) || (!exclusion || filter.contains(pf)) && (exclusion || !filter.contains(pf))) continue;
                matches.add(pf);
            }
        }
        Collections.sort(matches);
        return matches;
    }

    public static enum Type {
        meat(1),
        bakery(272),
        vegetable(816),
        fruit(1360),
        cooked_meat(1632),
        general(1904),
        powders(2720),
        sandwiches(2992),
        liquids(3264);

        private final int _offset;

        private Type(int offset) {
            this._offset = offset;
        }

        public int shared_metaoffset() {
            return this._offset;
        }

        public static int reservedSlotCount() {
            return 128;
        }

        public static final int idLastUsed() {
            return 6400;
        }

        @Nullable
        public static final Type from(String name) {
            for (Type type : Type.values()) {
                if (!type.name().equals(name)) continue;
                return type;
            }
            return null;
        }
    }

    public static enum ContainerHint {
        BAG("bag_of_"),
        TIE("bunch_of_"),
        JAR("jar_of_"),
        PAK("paket_of_");

        private final String _prefix;

        private ContainerHint(String s) {
            this._prefix = s;
        }

        public final String prefix() {
            return this._prefix;
        }
    }
}

