/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Items;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.jwaresoftware.mcmods.lib.LibConfig;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.mod.FlexibleBoolean;
import org.jwaresoftware.mcmods.lib.api.mod.IModInfo;
import org.jwaresoftware.mcmods.lib.impl.ModConfigBase;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.VanillaFoodPantry;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpExtendedPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public final class VfpConfig
extends ModConfigBase {
    static final String _I18N = ModInfo.uilang("config.");
    static final String _GENERAL = "general.";
    static final String _BAKERY = "bakery.";
    static final String _BUTCHER = "butcher.";
    static final String _PRODUCE = "produce.";
    static final String _UPSIZER = "upsizer.";
    static final String _OTHRMOD = "integration.";
    static final String _MISC = "misc.";
    static final String _INTERNAL = "_internal_";
    private static VfpConfig INSTANCE;
    private static boolean _XFP_PRESENT;
    public static boolean DEBUG_INFO;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> DEBUG_MODE;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> SHOW_TOOLTIPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> COMPAT_MODE;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> CRAFTING_XP;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> GENEROUS_XP;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> ANY_MOD_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> ORE_GEN;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> ENRICH_LOOT;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> STRICT_PROGRESS;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> TREAT_WATER;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> SINGLE_USE_FOODS;
    static final ModConfigBase.Option<List<? extends String>, ForgeConfigSpec.ConfigValue<List<? extends String>>> SINGLE_USE_PER_TYPE;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> SEED_DRYING;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> POTION_BREWING;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> MOONSHINE_MIXING;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.IntValue> MAX_MOONSHINE_POTIONS;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.IntValue> MYSTERY_EFFECTS_DURATION;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> FOOD_ONLY_CUTTERS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> INSTA_EAT_MORSELS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> INSTA_EAT_SOAKED;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> BEARS_LUV_SALMON;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.IntValue> MAX_DRINKS_STACKSIZE;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.IntValue> MAX_SOUPS_STACKSIZE;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> BAT_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> CALF_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> PIG_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> HORSE_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> WOLF_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> SQUIDD_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> POLARBEAR_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> LLAMA_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> OZELOT_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> GUARDIAN_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> ZOMBIE_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> PHANTOM_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> RAVAGER_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> ENSURE_DEATH_DROPS;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> BONE_DROPS;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> LEATHER_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> EXCLUDE_HORSE_MEAT;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> EXCLUDE_SQUID_MEAT;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> EXCLUDE_WOLF_MEAT;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> EXCLUDE_POLARBEAR_MEAT;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> EXCLUDE_LLAMA_MEAT;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> LLAMAS_DROP_WOOL;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> EXCLUDE_GUARDIAN_MEAT;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> EXCLUDE_RAVAGER_MEAT;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> MUSHROOM_PANTRY_BLOCK;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> UPSIZE_MUSHROOM_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> ACORN_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> UGLIFRUIT_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> SPRUCETIP_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> BAMBOO_SHOOTS_DROPS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> HONEY_PANTRY_BLOCKS;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> NUTRITION_NOTES;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> SHOW_NUTRITION_NOTES;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> NUTRITION_NOTES_PICKUP;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> SHOW_ALL_ITEMS;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> ANY_FOOD_IN_GENERIC_DECKER;
    static final ModConfigBase.Option<Integer, ForgeConfigSpec.IntValue> MAX_FOODPTS_PER_CONSUMABLE;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> SHOW_DECKER_FULLTIP;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> INTERMOD_RECIPES;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> KUNG_FOOD;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> FOOD_FUEL;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> BARTERING;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> WARMING_COOLING_RECIPES;
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> ALLOW_MYSTERY_DEBUFFS;
    static final ModConfigBase.Option<String, ForgeConfigSpec.ConfigValue<String>> ADVANCED_SURVIVAL_MECHANICS;
    static final String _MOD_CATEGORY = "integration.vanilla.";
    static final ModConfigBase.Option<Boolean, ForgeConfigSpec.BooleanValue> SMH_INTEGRATE;
    public static final Predicate<Item> EXTENDED_FARMING_PRESENT;
    private ItemGroup _uiTab;
    private boolean _fullyStarted = false;

    public static final VfpConfig setInstance() {
        assert (INSTANCE == null);
        INSTANCE = new VfpConfig();
        return INSTANCE;
    }

    public static final VfpConfig getInstance() {
        return INSTANCE;
    }

    private VfpConfig() {
        super((IModInfo)ModInfo.getInstance());
    }

    public final int currentVersion() {
        return 2;
    }

    public boolean useForgeTracking() {
        return true;
    }

    public boolean isFullyStarted() {
        return this._fullyStarted && LibConfig.getInstance().tagsLoaded();
    }

    public void setFullyStarted() {
        this._fullyStarted = true;
        DEBUG_INFO = this.isDebugMode();
    }

    public final boolean isModLoaded(String modid) {
        return ModIntegration.isPresent((String)modid);
    }

    public final boolean isDebugMode() {
        return VanillaFoodPantry.DESPERATION_DEBUG ? true : (Boolean)DEBUG_MODE.value();
    }

    private void define_isDebugMode() {
        VfpConfig.DEBUG_MODE.val = this._spec.comment("[INTERNAL] Set true to enable development checks and workflows. Do NOT enable in a regular environment.").define(VfpConfig.DEBUG_MODE.PROPERTY, DEBUG_MODE);
    }

    public void setTab(ItemGroup tab) {
        this._uiTab = tab;
        VfpUtils.setVfpTabOverride(tab);
    }

    public ItemGroup getTab() {
        return this._uiTab;
    }

    public boolean showDocumentationTooltips() {
        return (Boolean)SHOW_TOOLTIPS.value();
    }

    private void define_showDocumentationTooltips() {
        VfpConfig.SHOW_TOOLTIPS.val = this._spec.comment("Set to false to turn off documentation tooltips (status tips not affected). Enabled by default.").define(VfpConfig.SHOW_TOOLTIPS.PROPERTY, SHOW_TOOLTIPS);
    }

    public final boolean isAllowed(@Nonnull String option, boolean defaultValue) {
        if ("false".equals(option)) {
            return false;
        }
        if ("debug_recipe".equals(option)) {
            return this.isDebugMode();
        }
        if ("nutrition_notes".equals(option)) {
            return this.computeNutritionNotes();
        }
        if ("loot_tables".equals(option)) {
            return this.allowLootTableEnrichment();
        }
        if ("vanilla_only".equals(option)) {
            return this.strictVanillaProgression(defaultValue);
        }
        if ("vanilla_plus".equals(option)) {
            return !this.strictVanillaProgression(!defaultValue);
        }
        if ("general_cutters".equals(option)) {
            return this.allowGeneralFlintCutter();
        }
        if ("inter_mod_recipes".equals(option)) {
            return this.includeInterModRecipes();
        }
        if ("hotcold_food".equals(option)) {
            return this.allowReheatingAndChillingRecipes();
        }
        if ("advanced_survival".equals(option)) {
            return this.integrateWithSurvivalMechanics();
        }
        if ("spawn_eggs".equals(option)) {
            return this.allowSpawnEggCrafting() && !this.strictVanillaProgression(false);
        }
        if ("dragon_breath".equals(option)) {
            return this.allowAirSacToDragonBreathConversion() && !this.strictVanillaProgression(false);
        }
        if ("exo_boxes".equals(option)) {
            return this.allowExoBoxes() && !this.strictVanillaProgression(false);
        }
        if ("depth_pearls".equals(option)) {
            return this.allowInkPearlToEnderPearlConversion() && !this.strictVanillaProgression(false);
        }
        if ("addl_water_recipes".equals(option)) {
            return this.craftOtherSourcesOfWater();
        }
        if ("food_charcoal".equals(option)) {
            return VfpConfig.allowFoodFuel();
        }
        if ("straps_as_string".equals(option)) {
            return this.hideStrapsLikeString() && !this.strictVanillaProgression(defaultValue);
        }
        return super.isAllowed(option, defaultValue);
    }

    public boolean isSuperCompatibilityMode() {
        return (Boolean)COMPAT_MODE.value();
    }

    private void define_isSuperCompatibilityMode() {
        VfpConfig.COMPAT_MODE.val = this._spec.comment("Set to true to force all the basic recipes to use a mod-specific element to ensure no collisions with other mod recipes. Off by default; requires restart if changed.").define(VfpConfig.COMPAT_MODE.PROPERTY, COMPAT_MODE);
    }

    public boolean includeCraftingXp() {
        return (Boolean)CRAFTING_XP.value();
    }

    private void define_includeCraftingXp() {
        VfpConfig.CRAFTING_XP.val = this._spec.comment("Set to false to disable generation of experience from crafting foods using VFP's mechanism. Note that this option does not affect cooking or mining experience drops or Xp generated by other mods. Enabled by default; requires restart if changed.").define(VfpConfig.CRAFTING_XP.PROPERTY, CRAFTING_XP);
    }

    public boolean generousCraftingXp() {
        return (Boolean)GENEROUS_XP.value();
    }

    private void define_generousCraftingXp() {
        VfpConfig.GENEROUS_XP.val = this._spec.comment("Set to false to disable compensation for Minecraft ignoring small amounts of crafting Xp. Note that this option is ignored if crafting Xp is disabled. Enabled by default; requires restart if changed.").define(VfpConfig.GENEROUS_XP.PROPERTY, GENEROUS_XP);
    }

    public boolean includeModDrops() {
        return (Boolean)ANY_MOD_DROPS.value();
    }

    private void define_includeModDrops() {
        VfpConfig.ANY_MOD_DROPS.val = this._spec.comment("Set to false to disable -ALL- custom VFP drops from blocks and mobs unconditionally. Overrides all other settings. OFF by default. Requires restart if changed.").define(VfpConfig.ANY_MOD_DROPS.PROPERTY, ANY_MOD_DROPS);
    }

    public boolean isOreGenerationEnabled() {
        return (Boolean)ORE_GEN.value();
    }

    private void define_isOreGenerationEnabled() {
        VfpConfig.ORE_GEN.val = this._spec.comment("Set to false to disable generation of custom VFP ores like rock salt and natron in new worlds and new chunks. Enabled by default; requires restart if changed.").define(VfpConfig.ORE_GEN.PROPERTY, ORE_GEN);
    }

    public boolean allowLootTableEnrichment() {
        return (Boolean)ENRICH_LOOT.value();
    }

    private void define_allowLootTableEnrichment() {
        VfpConfig.ENRICH_LOOT.val = this._spec.comment("Set to false to disable all mod-specific additions to structure and activity loot tables. Changing this affects things like fishing and dungeon loot but NOT upsize drops (see individual options). Enabled by default; requires restart if changed.").define(VfpConfig.ENRICH_LOOT.PROPERTY, ENRICH_LOOT);
    }

    public boolean strictVanillaProgression(boolean preferred_value) {
        return VfpConfig._getBooleanOrDefault((String)((String)STRICT_PROGRESS.value()), (boolean)preferred_value);
    }

    private void define_strictVanillaProgression() {
        VfpConfig.STRICT_PROGRESS.val = FlexibleBoolean.define((String)VfpConfig.STRICT_PROGRESS.PROPERTY, (ForgeConfigSpec.Builder)this._spec.comment("Set to \"true\" to disable extra recipes and actions that allow players access to items normally tied to standard progression. For example, if true, disables recipes for blaze powder and ender pearls. Combine with other options to remove all possible vanilla progression changes."));
    }

    public boolean useTreatedWaterRecipes() {
        String PROPERTY = VfpConfig.TREAT_WATER.PROPERTY;
        Boolean b = (Boolean)this._cache.get(_GENERAL + PROPERTY);
        if (b != null) {
            return b;
        }
        String p = (String)TREAT_WATER.value();
        b = Strings.isDefaultValue((String)p) ? Boolean.valueOf(LibConfig.integrateWithSurvivalMods() && WellnessHelper.manageWater()) : Boolean.valueOf(BooleanUtils.toBoolean((String)p));
        this._cache.put(_GENERAL + PROPERTY, b);
        return b;
    }

    private void define_useTreatedWaterRecipes() {
        VfpConfig.TREAT_WATER.val = FlexibleBoolean.define((String)VfpConfig.TREAT_WATER.PROPERTY, (ForgeConfigSpec.Builder)this._spec.comment("Set to \"true\" to force crafting recipes to require treated water for VFP's food recipes (or \"false\" to NOT require it). Defaults false unless a mod like Survive is present but does not require these other mods be present to set true! Requires restart if changed."));
    }

    public boolean preferSingleUseFood(String what, boolean preferred_value) {
        if (!what.isEmpty() && !"all".equals(what)) {
            Map<String, FlexibleBoolean> all = this.getSingleUsesPerType();
            preferred_value = VfpConfig._getBooleanOrDefault((String)all.getOrDefault(what, FlexibleBoolean.DEFAULT).setting(), (boolean)preferred_value);
        }
        return VfpConfig._getBooleanOrDefault((String)((String)SINGLE_USE_FOODS.value()), (boolean)preferred_value);
    }

    private void define_preferSingleUseFood() {
        VfpConfig.SINGLE_USE_FOODS.val = FlexibleBoolean.define((String)VfpConfig.SINGLE_USE_FOODS.PROPERTY, (ForgeConfigSpec.Builder)this._spec.comment("Set to \"true\" to have VFP create single-use food items if possible. 'If possible' is defined as having a total food value less than or equal to the max food points allowed by vanilla Minecraft (20pts). Off for most multi-use capable foods by default. Requires restart if changed."));
    }

    private final void define_singleUsePerType() {
        VfpConfig.SINGLE_USE_PER_TYPE.val = this._spec.comment("Use to define granular per-type defaults of the general 'prefer_singleuse' option provided that option has not been set to 'true' or 'false' specifically.").defineList(VfpConfig.SINGLE_USE_PER_TYPE.PROPERTY, (List)VfpConfig.SINGLE_USE_PER_TYPE.DFLT, IS_NONEMPTY_STRING);
    }

    @Nonnull
    private Map<String, FlexibleBoolean> getSingleUsesPerType() {
        HashMap<String, FlexibleBoolean> values = (HashMap<String, FlexibleBoolean>)this._cache.get(VfpConfig.SINGLE_USE_PER_TYPE.PROPERTY);
        if (values != null) {
            return values;
        }
        values = new HashMap<String, FlexibleBoolean>();
        for (String defn : (List)SINGLE_USE_PER_TYPE.value()) {
            FlexibleBoolean v;
            String[] kv = StringUtils.split((String)defn, (char)'=');
            if (kv.length != 2 || (v = FlexibleBoolean.fromLString((String)kv[1].trim())) == null) continue;
            values.put(kv[0].trim(), v);
        }
        this._cache.put(VfpConfig.SINGLE_USE_PER_TYPE.PROPERTY, values);
        return values;
    }

    public boolean allowSeedDrying() {
        return (Boolean)SEED_DRYING.value();
    }

    private void define_allowSeedDrying() {
        VfpConfig.SEED_DRYING.val = this._spec.comment("Set to false to disable seed drying from source produce. By default you can use seed drying paper to extract seeds from melons, pumpkins, wheat, and a few modded crops. Enabled by default; requires restart if changed.").define(VfpConfig.SEED_DRYING.PROPERTY, SEED_DRYING);
    }

    public boolean includePotionBrewing() {
        return (Boolean)POTION_BREWING.value();
    }

    private void define_includePotionBrewing() {
        VfpConfig.POTION_BREWING.val = this._spec.comment("Set to false to disable installation of VFP's potions like Wolf's Spirit potion. Does NOT affect adhoc mixing of existing potions into moonshine potions or the temperature effects of chilled and heated foods. Enabled by default. Requires restart if changed.").define(VfpConfig.POTION_BREWING.PROPERTY, POTION_BREWING);
    }

    public boolean allowMoonshineMixing() {
        return (Boolean)MOONSHINE_MIXING.value();
    }

    private void define_allowMoonshineMixing() {
        VfpConfig.MOONSHINE_MIXING.val = this._spec.comment("Set to false to disable all moonshine potions (tonics) and bootleg gelos features. Does not affect availability of VFP's custom potions. Existing items will still work. Enabled by default; requires restart if changed.").define(VfpConfig.MOONSHINE_MIXING.PROPERTY, MOONSHINE_MIXING);
    }

    public int maxMoonshineMixCapacity() {
        return MathHelper.func_76125_a((int)((Integer)MAX_MOONSHINE_POTIONS.value()), (int)1, (int)12);
    }

    private void define_maxMoonshineMixCapacity() {
        VfpConfig.MAX_MOONSHINE_POTIONS.val = this._spec.comment("Set to the max number of distinct potions allowed in a single moonshine mixture. Hard-limit is 12. Set to one (1) to disable moonshine mixing but keep potion-to-tonic conversion for stackable potions.").defineInRange(VfpConfig.MAX_MOONSHINE_POTIONS.PROPERTY, ((Integer)VfpConfig.MAX_MOONSHINE_POTIONS.DFLT).intValue(), 1, 12);
    }

    public int maxMysteriousEffectDurationSecs() {
        return MathHelper.func_76125_a((int)((Integer)MYSTERY_EFFECTS_DURATION.value()), (int)5, (int)900);
    }

    private void define_maxMysteriousEffectDuration() {
        VfpConfig.MYSTERY_EFFECTS_DURATION.val = this._spec.comment("Set to the max number of seconds the effect given by a mysterious fruit salad should last. Note this value may be ignored if the given effect is an instant effect (like Healing). Limited to a range of 5s to 900s (or 5sec to 15min).").defineInRange(VfpConfig.MYSTERY_EFFECTS_DURATION.PROPERTY, ((Integer)VfpConfig.MYSTERY_EFFECTS_DURATION.DFLT).intValue(), 5, 900);
    }

    public boolean allowGeneralFlintCutter() {
        return (Boolean)FOOD_ONLY_CUTTERS.value() == false;
    }

    private void define_allowGeneralFlintCutter() {
        VfpConfig.FOOD_ONLY_CUTTERS.val = this._spec.comment("Set to true to limit the use of the flint-cutter to only food RELATED recipes. Disabled by default (cutter can be used to cut things like wool blocks and leather).").define(VfpConfig.FOOD_ONLY_CUTTERS.PROPERTY, FOOD_ONLY_CUTTERS);
    }

    public static final boolean allowInstaEating() {
        return (Boolean)INSTA_EAT_MORSELS.value();
    }

    private void define_allowInstaEating() {
        VfpConfig.INSTA_EAT_MORSELS.val = this._spec.comment("Set to true to allow player to instantly consume VFP morsels on right-click. Morsels are defined as any consumable item with less than 4pts of food value. Disabled by default.").define(VfpConfig.INSTA_EAT_MORSELS.PROPERTY, INSTA_EAT_MORSELS);
    }

    public boolean allowInstaPotions() {
        return (Boolean)INSTA_EAT_SOAKED.value();
    }

    private void define_allowInstaPotions() {
        VfpConfig.INSTA_EAT_SOAKED.val = this._spec.comment("Set to true to allow player to instantly consume soaked VFP foods and bootleg gelos on right-click. This option is independent of the 'insta_eat_morsels' option. Does NOT apply to suspicious stews or mysterious fruit salads. Disabled by default.").define(VfpConfig.INSTA_EAT_SOAKED.PROPERTY, INSTA_EAT_SOAKED);
    }

    public boolean allowPolarbearBreeding() {
        return (Boolean)BEARS_LUV_SALMON.value();
    }

    private void define_allowPolarbearBreeding() {
        VfpConfig.BEARS_LUV_SALMON.val = this._spec.comment("Set to false to disable breeding polar bears with raw salmon. Enabled by default; requires restart if changed.").define(VfpConfig.BEARS_LUV_SALMON.PROPERTY, BEARS_LUV_SALMON);
    }

    public VfpCapacity maxDrinksStackCapacity(VfpCapacity defaultSize) {
        VfpCapacity n = (VfpCapacity)((Object)this._cache.get(VfpConfig.MAX_DRINKS_STACKSIZE.PROPERTY));
        if (n != null) {
            return n;
        }
        n = VfpCapacity.fromConfig((Integer)MAX_DRINKS_STACKSIZE.value(), defaultSize);
        this._cache.put(VfpConfig.MAX_DRINKS_STACKSIZE.PROPERTY, n);
        return n;
    }

    private void define_maxDrinksStackCapacity() {
        VfpConfig.MAX_DRINKS_STACKSIZE.val = this._spec.comment("Max stack size for all bottled items like fizzy drinks and juices. Default stack size is " + VfpCapacity.LIQUID_STACK.count() + ". Allowed sizes are [1,4,8,16,24,32,64].").defineInRange(VfpConfig.MAX_DRINKS_STACKSIZE.PROPERTY, ((Integer)VfpConfig.MAX_DRINKS_STACKSIZE.DFLT).intValue(), 1, 64);
    }

    public VfpCapacity maxSoupsStackCapacity(VfpCapacity defaultSize) {
        VfpCapacity n = (VfpCapacity)((Object)this._cache.get(VfpConfig.MAX_SOUPS_STACKSIZE.PROPERTY));
        if (n != null) {
            return n;
        }
        n = VfpCapacity.fromConfig((Integer)MAX_SOUPS_STACKSIZE.value(), defaultSize);
        this._cache.put(VfpConfig.MAX_SOUPS_STACKSIZE.PROPERTY, n);
        return n;
    }

    private void define_maxSoupsStackCapacity() {
        VfpConfig.MAX_SOUPS_STACKSIZE.val = this._spec.comment("Max stack size for all soupy items like creamy soups, chowders, and stews. Default stack size is " + VfpCapacity.LIQUID_STACK.count() + ". Allowed sizes are [1,4,8,16,24,32,64].").defineInRange(VfpConfig.MAX_SOUPS_STACKSIZE.PROPERTY, ((Integer)VfpConfig.MAX_SOUPS_STACKSIZE.DFLT).intValue(), 1, 64);
    }

    public boolean includeBatDrops() {
        return (Boolean)BAT_DROPS.value();
    }

    private void define_includeBatDrops() {
        VfpConfig.BAT_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing a bat. VFP adds bat meat, bat poop (use like bonemeal or to create rotten flesh), and special drops for potions. Enabled by default.").define(VfpConfig.BAT_DROPS.PROPERTY, BAT_DROPS);
    }

    public boolean includeCalfDrops() {
        return (Boolean)CALF_DROPS.value();
    }

    private void define_includeCalfDrops() {
        VfpConfig.CALF_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing baby cows. VFP adds calf stomach lining for use in creating curdling agent for cheese. Enabled by default.").define(VfpConfig.CALF_DROPS.PROPERTY, CALF_DROPS);
    }

    public boolean includePigDrops() {
        return (Boolean)PIG_DROPS.value();
    }

    private void define_includePigDrops() {
        VfpConfig.PIG_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing pigs. VFP adds drops like raw pork hocks and pig tails for intriguing culinary delights. Enabled by default.").define(VfpConfig.PIG_DROPS.PROPERTY, PIG_DROPS);
    }

    public boolean includeHorseDrops() {
        return (Boolean)HORSE_DROPS.value();
    }

    private void define_includeHorseDrops() {
        VfpConfig.HORSE_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing horses. VFP adds drops like raw horse meat and horse tears for brewing potions. Enabled by default.").define(VfpConfig.HORSE_DROPS.PROPERTY, HORSE_DROPS);
    }

    public boolean includeWolfDrops() {
        return (Boolean)WOLF_DROPS.value();
    }

    private void define_includeWolfDrops() {
        VfpConfig.WOLF_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing wolves (tamed and untamed). VFP adds raw wolf meat and special drops for custom potions. Enabled by default.").define(VfpConfig.WOLF_DROPS.PROPERTY, WOLF_DROPS);
    }

    public boolean includeSquidDrops() {
        return (Boolean)SQUIDD_DROPS.value();
    }

    private void define_includeSquidDrops() {
        VfpConfig.SQUIDD_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing squid. VFP adds raw squid meat and ink pearl fragment drops from squid. Enabled by default.").define(VfpConfig.SQUIDD_DROPS.PROPERTY, SQUIDD_DROPS);
    }

    public boolean includePolarBearDrops() {
        return (Boolean)POLARBEAR_DROPS.value();
    }

    private void define_includePolarBearDrops() {
        VfpConfig.POLARBEAR_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing polar bears. VFP adds raw  bear meat and special drops for custom potions. Enabled by default.").define(VfpConfig.POLARBEAR_DROPS.PROPERTY, POLARBEAR_DROPS);
    }

    public boolean includeLlamaDrops() {
        return (Boolean)LLAMA_DROPS.value();
    }

    private void define_includeLlamaDrops() {
        VfpConfig.LLAMA_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing llamas. VFP adds raw llama meat and fleece (like wool) blocks. Enabled by default.").define(VfpConfig.LLAMA_DROPS.PROPERTY, LLAMA_DROPS);
    }

    public boolean includeOcelotDrops() {
        return (Boolean)OZELOT_DROPS.value();
    }

    private void define_includeOcelotDrops() {
        VfpConfig.OZELOT_DROPS.val = this._spec.comment("Set to false to disable the ability to steal lives from ocelots as Felis Life Essence. Also controls Bane of Ocelot drop from creepers. Enabled by default.").define(VfpConfig.OZELOT_DROPS.PROPERTY, OZELOT_DROPS);
    }

    public boolean includeGuardianDrops() {
        return (Boolean)GUARDIAN_DROPS.value();
    }

    private void define_includeGuardianDrops() {
        VfpConfig.GUARDIAN_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing guardians and elder guardians. VFP adds guardian air sacs, tail fins, meat, and other items. Enabled by default.").define(VfpConfig.GUARDIAN_DROPS.PROPERTY, GUARDIAN_DROPS);
    }

    public boolean includeZombieDrops() {
        return (Boolean)ZOMBIE_DROPS.value();
    }

    private void define_includeZombieDrops() {
        VfpConfig.ZOMBIE_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing zombies of all kinds. VFP adds tainted souls for use with Felis Life Essence in potion brewing. Enabled by default.").define(VfpConfig.ZOMBIE_DROPS.PROPERTY, ZOMBIE_DROPS);
    }

    public boolean includePhantomDrops() {
        return (Boolean)PHANTOM_DROPS.value();
    }

    private void define_includePhantomDrops() {
        VfpConfig.PHANTOM_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing phantoms. VFP adds phantom meat and other items used in potion brewing. Enabled by default.").define(VfpConfig.PHANTOM_DROPS.PROPERTY, PHANTOM_DROPS);
    }

    public boolean includeRavagerDrops() {
        return (Boolean)RAVAGER_DROPS.value();
    }

    private void define_includeRavagerDrops() {
        VfpConfig.RAVAGER_DROPS.val = this._spec.comment("Set to false to disable mod drops from killing ravager beasts. VFP adds ravager meat, bones, and other items used in potion brewing. Enabled by default.").define(VfpConfig.RAVAGER_DROPS.PROPERTY, RAVAGER_DROPS);
    }

    public boolean ensureDeathDrops() {
        return (Boolean)ENSURE_DEATH_DROPS.value();
    }

    private void define_ensureDeathDrops() {
        VfpConfig.ENSURE_DEATH_DROPS.val = this._spec.comment("Set to true to guarantee a minimum amount of items are dropped from killing cows, pigs, sheep, etc. The meat drop increase is from 0 to 3 more pieces with other items like hides, feathers, shells, and bones also guaranteed (1 per kill) unless blocked by another config option. This option applies to standard Minecraft mobs only. Enabled by default; requires restart if changed. Ignored if mod drops disabled.").define(VfpConfig.ENSURE_DEATH_DROPS.PROPERTY, ENSURE_DEATH_DROPS);
    }

    public boolean includeBoneDrops() {
        Boolean b = (Boolean)this._cache.get(VfpConfig.BONE_DROPS.PROPERTY);
        if (b != null) {
            return b;
        }
        b = true;
        String p = (String)BONE_DROPS.value();
        if (Strings.isDefaultValue((String)p)) {
            if (this.isSuperCompatibilityMode()) {
                b = false;
            }
        } else {
            b = BooleanUtils.toBoolean((String)p);
        }
        this._cache.put(VfpConfig.BONE_DROPS.PROPERTY, b);
        return b;
    }

    private void define_includeBoneDrops() {
        VfpConfig.BONE_DROPS.val = FlexibleBoolean.define((String)VfpConfig.BONE_DROPS.PROPERTY, (ForgeConfigSpec.Builder)this._spec.comment("Set to \"true\" to enable mod bone drops regardless of the other mods present and super-compatibility mode setting. Leave as *DEFAULT* to let VFP decide if bone drops are appropriate per animal type. Requires game restart if changed."));
    }

    public boolean includeLeatherDrops() {
        Boolean b = (Boolean)this._cache.get(VfpConfig.LEATHER_DROPS.PROPERTY);
        if (b != null) {
            return b;
        }
        b = true;
        String p = (String)LEATHER_DROPS.value();
        if (Strings.isDefaultValue((String)p)) {
            if (this.isSuperCompatibilityMode() || this.strictVanillaProgression(false)) {
                b = false;
            }
        } else {
            b = BooleanUtils.toBoolean((String)p);
        }
        this._cache.put(VfpConfig.LEATHER_DROPS.PROPERTY, b);
        return b;
    }

    private void define_includeLeatherDrops() {
        VfpConfig.LEATHER_DROPS.val = FlexibleBoolean.define((String)VfpConfig.LEATHER_DROPS.PROPERTY, (ForgeConfigSpec.Builder)this._spec.comment("Set to \"false\" to completely disable mod leather drops. Leave as *DEFAULT* to let VFP decide if leather drops are appropriate per animal type. Note that super-compatibility mode defines the default value to be false. Requires game restart if changed."));
    }

    public boolean excludeHorseMeatDrops() {
        return (Boolean)EXCLUDE_HORSE_MEAT.value();
    }

    private void define_excludeHorseMeatDrops() {
        VfpConfig.EXCLUDE_HORSE_MEAT.val = this._spec.comment("Set to true to disable ONLY meat drops from killing horses when 'include_horse_drops' is enabled; ignored otherwise. Use if you have another mod that already drops horse meat.").define(VfpConfig.EXCLUDE_HORSE_MEAT.PROPERTY, EXCLUDE_HORSE_MEAT);
    }

    public boolean excludeSquidMeatDrops() {
        return (Boolean)EXCLUDE_SQUID_MEAT.value();
    }

    private void define_excludeSquidMeatDrops() {
        VfpConfig.EXCLUDE_SQUID_MEAT.val = this._spec.comment("Set to true to disable ONLY meat drops from killing squid when 'include_squid_drops' is enabled; ignored otherwise. Use if you have another mod that already drops squid meat.").define(VfpConfig.EXCLUDE_SQUID_MEAT.PROPERTY, EXCLUDE_SQUID_MEAT);
    }

    public boolean excludeWolfMeatDrops() {
        return (Boolean)EXCLUDE_WOLF_MEAT.value();
    }

    private void define_excludeWolfMeatDrops() {
        VfpConfig.EXCLUDE_WOLF_MEAT.val = this._spec.comment("Set to true to disable ONLY meat drops from killing wolves when 'include_wolf_drops' is enabled; ignored otherwise. Use if you have another mod that already drops wolf meat.").define(VfpConfig.EXCLUDE_WOLF_MEAT.PROPERTY, EXCLUDE_WOLF_MEAT);
    }

    public boolean excludePolarBearMeatDrops() {
        return (Boolean)EXCLUDE_POLARBEAR_MEAT.value();
    }

    private void define_excludePolarBearMeatDrops() {
        VfpConfig.EXCLUDE_POLARBEAR_MEAT.val = this._spec.comment("Set to true to disable ONLY meat drops from killing polar bears when 'include_polarbear_drops' is enabled; ignored otherwise. Use if you have another mod that already drops polar bear meat.").define(VfpConfig.EXCLUDE_POLARBEAR_MEAT.PROPERTY, EXCLUDE_POLARBEAR_MEAT);
    }

    public boolean excludeLlamaMeatDrops() {
        return (Boolean)EXCLUDE_LLAMA_MEAT.value();
    }

    private void define_excludeLlamaMeatDrops() {
        VfpConfig.EXCLUDE_LLAMA_MEAT.val = this._spec.comment("Set to true to disable ONLY meat drops from killing llamas when 'include_llama_drops' is enabled; ignored otherwise. Use if you have another mod that already drops llama meat.").define(VfpConfig.EXCLUDE_LLAMA_MEAT.PROPERTY, EXCLUDE_LLAMA_MEAT);
    }

    public boolean llamasDropRegularWool() {
        return (Boolean)LLAMAS_DROP_WOOL.value();
    }

    private void define_llamasDropRegularWool() {
        VfpConfig.LLAMAS_DROP_WOOL.val = this._spec.comment("Set to true to have llamas drop regular (sheep) wool blocks instead of the custom VFP fleece wool blocks. Disabled by default. Ignored if llama drops in general are disabled.").define(VfpConfig.LLAMAS_DROP_WOOL.PROPERTY, LLAMAS_DROP_WOOL);
    }

    public boolean excludeGuardianMeatDrops() {
        return (Boolean)EXCLUDE_GUARDIAN_MEAT.value();
    }

    private void define_excludeGuardianMeatDrops() {
        VfpConfig.EXCLUDE_GUARDIAN_MEAT.val = this._spec.comment("Set to true to disable ONLY meat drops from killing guardians when 'include_guardian_drops' is enabled; ignored otherwise. Use if you're interested in tail fins and air sac drops only.").define(VfpConfig.EXCLUDE_GUARDIAN_MEAT.PROPERTY, EXCLUDE_GUARDIAN_MEAT);
    }

    public boolean excludeRavagerMeatDrops() {
        return (Boolean)EXCLUDE_RAVAGER_MEAT.value();
    }

    private void define_excludeRavagerMeatDrops() {
        VfpConfig.EXCLUDE_RAVAGER_MEAT.val = this._spec.comment("Set to true to disable ONLY meat drops from killing ravagers when 'include_ravager_drops' is enabled; ignored otherwise. Use if you're interested in bone, hide, and horn drops only.").define(VfpConfig.EXCLUDE_RAVAGER_MEAT.PROPERTY, EXCLUDE_RAVAGER_MEAT);
    }

    public boolean useMushroomBlocksForPantry() {
        return (Boolean)MUSHROOM_PANTRY_BLOCK.value();
    }

    private void define_useMushroomBlocksForPantry() {
        VfpConfig.MUSHROOM_PANTRY_BLOCK.val = this._spec.comment("Set to true to enable (un)crafting of 9 mushrooms from standard mushroom blocks. If enabled you can increase storage size of mushrooms per slot and unlock all the mushroomy goodness of giant mushrooms! Disabled by default.").define(VfpConfig.MUSHROOM_PANTRY_BLOCK.PROPERTY, MUSHROOM_PANTRY_BLOCK);
    }

    public boolean increaseShroomDrops() {
        return (Boolean)UPSIZE_MUSHROOM_DROPS.value();
    }

    private void define_increaseShroomDrops() {
        VfpConfig.UPSIZE_MUSHROOM_DROPS.val = this._spec.comment("Set to false to disable additional mushroom drops from chopping down huge mushrooms with a butchering axe or other tool with fortune enchantment. Also adds mushrooms to mooshroom drops. Enabled by default. Needs restart if changed.").define(VfpConfig.UPSIZE_MUSHROOM_DROPS.PROPERTY, UPSIZE_MUSHROOM_DROPS);
    }

    public boolean includeAcornDrops() {
        return (Boolean)ACORN_DROPS.value();
    }

    private void define_includeAcornDrops() {
        VfpConfig.ACORN_DROPS.val = this._spec.comment("Set to false to stop acorn drops when you break oak and dark-oak leaves. Will not disable acornmeal based recipes (as acorns can be obtained from other mods). Enabled by default.").define(VfpConfig.ACORN_DROPS.PROPERTY, ACORN_DROPS);
    }

    public boolean includeUgliFruitDrops() {
        return (Boolean)UGLIFRUIT_DROPS.value();
    }

    private void define_includeUgliFruitDrops() {
        VfpConfig.UGLIFRUIT_DROPS.val = this._spec.comment("Set to false to stop raftugli fruit drops when you break jungle leaves. Enabled by default.").define(VfpConfig.UGLIFRUIT_DROPS.PROPERTY, UGLIFRUIT_DROPS);
    }

    public boolean includeSpruceTipDrops() {
        return (Boolean)SPRUCETIP_DROPS.value();
    }

    private void define_includeSpruceTipDrops() {
        VfpConfig.SPRUCETIP_DROPS.val = this._spec.comment("Set to false to stop spruce tip drops when you break spruce leaves. Enabled by default.").define(VfpConfig.SPRUCETIP_DROPS.PROPERTY, SPRUCETIP_DROPS);
    }

    public boolean includeBambooShootsDrops() {
        return (Boolean)BAMBOO_SHOOTS_DROPS.value();
    }

    private void define_includeBambooShootsDrops() {
        VfpConfig.BAMBOO_SHOOTS_DROPS.val = this._spec.comment("Set to false to stop bamboo shoot drops when you break bamboo saplings with a cutter. Enabled by default.").define(VfpConfig.BAMBOO_SHOOTS_DROPS.PROPERTY, BAMBOO_SHOOTS_DROPS);
    }

    public boolean useHoneyBlocksForPantry() {
        return (Boolean)HONEY_PANTRY_BLOCKS.value();
    }

    private void define_useHoneyBlocksForPantry() {
        VfpConfig.HONEY_PANTRY_BLOCKS.val = this._spec.comment("Set to false to disable (un)crafting of 4 honeycombs from standard honeycomb blocks and the reheating of honey blocks back into liquid form (honey buckets). If enabled you can use both honey and honeycomb blocks as a simple storage block for all your honey! Enabled by default.").define(VfpConfig.HONEY_PANTRY_BLOCKS.PROPERTY, HONEY_PANTRY_BLOCKS);
    }

    public final boolean computeNutritionNotes() {
        return false;
    }

    private void define_computeNutritionNotes() {
        VfpConfig.NUTRITION_NOTES.val = FlexibleBoolean.define((String)VfpConfig.NUTRITION_NOTES.PROPERTY, (ForgeConfigSpec.Builder)this._spec.comment("[DISABLED] Set to \"false\" to disable computation of nutrition notes COMPLETELY. Nutrition notes is a feature that helps integrate VFP foods with other mods automatically. Turning off does not remove notes already added to existing items. Requires restart if changed."));
    }

    public final boolean showNutritionNotes() {
        return this.computeNutritionNotes() && VfpConfig._getBooleanOrDefault((String)((String)SHOW_NUTRITION_NOTES.value()), (_XFP_PRESENT || this.isDebugMode() ? 1 : 0) != 0);
    }

    private void define_showNutritionNotes() {
        VfpConfig.SHOW_NUTRITION_NOTES.val = FlexibleBoolean.define((String)VfpConfig.SHOW_NUTRITION_NOTES.PROPERTY, (ForgeConfigSpec.Builder)this._spec.comment("[DISABLED] Set to \"false\" to disable tooltips for nutrition notes. This setting does NOT affect the calculation or use of notes, just whether or not you see this information. Ignored if the nutrition notes feature is disabled. Requires restart if changed."));
    }

    public boolean checkNutritionNotesOnPickup() {
        return this.computeNutritionNotes() && (Boolean)NUTRITION_NOTES_PICKUP.value() != false;
    }

    private void define_checkNutritionNotesOnPickup() {
        VfpConfig.NUTRITION_NOTES_PICKUP.val = this._spec.comment("[DISABLED] Set to true to have VFP check nutrition notes for items on player-pickup from the world. This is a supplement to crafting, smelting, etc. when you want to assign notes to uncrafted items. Disabled by default.").define(VfpConfig.NUTRITION_NOTES_PICKUP.PROPERTY, NUTRITION_NOTES_PICKUP);
    }

    public boolean showAllItemsInUI() {
        return (Boolean)SHOW_ALL_ITEMS.value() != false || this.isDebugMode();
    }

    private void define_showAllItemsInUI() {
        VfpConfig.SHOW_ALL_ITEMS.val = this._spec.comment("Set to true to show all of the mod's items whether or not they are directly obtainable by the player using a VFP-made recipe. This option is useful if you want to see what items are available when requisite food or materials are provided by other means like merchants, quests, etc. Disabled by default.").define(VfpConfig.SHOW_ALL_ITEMS.PROPERTY, SHOW_ALL_ITEMS);
    }

    public boolean allowAnyFoodInGenericDecker() {
        return (Boolean)ANY_FOOD_IN_GENERIC_DECKER.value();
    }

    private void define_allowAnyFoodInGenericDecker() {
        VfpConfig.ANY_FOOD_IN_GENERIC_DECKER.val = this._spec.comment("Set false to use the pre-1.16 restricted set of foods for My-Way Deckers rather than allowing most foods provided 1 bread and 1 protein item also included. Enabled by default.").define(VfpConfig.ANY_FOOD_IN_GENERIC_DECKER.PROPERTY, ANY_FOOD_IN_GENERIC_DECKER);
    }

    public static final int maxFoodPointsPerMultiuseFood() {
        return MathHelper.func_76125_a((int)((Integer)MAX_FOODPTS_PER_CONSUMABLE.value()), (int)4, (int)VfpPantryItem.MAX_TOTAL_FOOD_VALUE_ALLOWED);
    }

    private void define_maxFoodPointsPerMultiuseFood() {
        VfpConfig.MAX_FOODPTS_PER_CONSUMABLE.val = this._spec.comment("Set to the max food points any multi-use item, like My-Way and King-Me deckers, can have. Note there can be additional size-restrictions depending on the food being crafted. Has no affect on existing items.").defineInRange(VfpConfig.MAX_FOODPTS_PER_CONSUMABLE.PROPERTY, ((Integer)VfpConfig.MAX_FOODPTS_PER_CONSUMABLE.DFLT).intValue(), 4, VfpPantryItem.MAX_TOTAL_FOOD_VALUE_ALLOWED);
    }

    public boolean showDeckerIngredients() {
        return (Boolean)SHOW_DECKER_FULLTIP.value() != false || this.isDebugMode();
    }

    private void define_showDeckerIngredients() {
        VfpConfig.SHOW_DECKER_FULLTIP.val = this._spec.comment("Set to false to disable decker sandwich ingredient (name) tooltips. If enabled you will see the name of each food item that went into your decker sandwich. Overrides the general 'show_doc_tooltips' option. Enabled by default.").define(VfpConfig.SHOW_DECKER_FULLTIP.PROPERTY, SHOW_DECKER_FULLTIP);
    }

    public boolean includeInterModRecipes() {
        return (Boolean)INTERMOD_RECIPES.value();
    }

    private void define_includeInterModRecipes() {
        VfpConfig.INTERMOD_RECIPES.val = this._spec.comment("Set to false to disable direct recipe making with non-vanilla and non-VFP foodstuffs (for example using Harvestcraft DIRECTLY). Does not affect tag-based recipe ingredients. Enabled by default; requires restart if changed.").define(VfpConfig.INTERMOD_RECIPES.PROPERTY, INTERMOD_RECIPES);
    }

    public static final boolean allowKungFood(boolean preferred_value) {
        return LibConfig.allowFightingFoods((String)((String)KUNG_FOOD.value()), (boolean)preferred_value);
    }

    private void define_allowKungFood() {
        VfpConfig.KUNG_FOOD.val = FlexibleBoolean.define((String)VfpConfig.KUNG_FOOD.PROPERTY, (ForgeConfigSpec.Builder)this._spec.comment("Set to \"false\" to disable the various 'Well Fed' and other combat-useful buffs related to consuming certain items (only affects VFP). Leave as '*DEFAULT*' to inherit the top-level Carrots library value."));
    }

    public static final boolean allowFoodFuel() {
        return LibConfig.allowFoodToFuel((String)((String)FOOD_FUEL.value()), (boolean)true);
    }

    private void define_allowFoodFuel() {
        VfpConfig.FOOD_FUEL.val = FlexibleBoolean.define((String)VfpConfig.FOOD_FUEL.PROPERTY, (ForgeConfigSpec.Builder)this._spec.comment("Set to \"false\" to disable ability to convert certain foods to charcoal-like fuel (only affects VFP). Leave as '*DEFAULT*' to inherit the top-level Carrots library value."));
    }

    public boolean includeBartering(boolean preferred_value) {
        return VfpConfig._getBooleanOrDefault((String)((String)BARTERING.value()), (boolean)preferred_value);
    }

    private void define_includeBartering() {
        VfpConfig.BARTERING.val = FlexibleBoolean.define((String)VfpConfig.BARTERING.PROPERTY, (ForgeConfigSpec.Builder)this._spec.comment("Set to \"false\" to disable direct integration with villager merchant trades tables. Leave as '*DEFAULT*' to permit trading depending on context and availability of other mods."));
    }

    public boolean allowReheatingAndChillingRecipes() {
        return (Boolean)WARMING_COOLING_RECIPES.value();
    }

    private void define_includeReheatingAndChillingRecipes() {
        VfpConfig.WARMING_COOLING_RECIPES.val = this._spec.comment("Set to false to disable builtin reheating and chilling recipes. You can still provide hot/cold foods via loot tables, trading, and shops (modded). This option does NOT alter any bonus effects from consuming such foods. Enabled by default; requires restart if changed.").define(VfpConfig.WARMING_COOLING_RECIPES.PROPERTY, WARMING_COOLING_RECIPES);
    }

    public static final boolean allowHarmfulMysteryEffects() {
        return (Boolean)ALLOW_MYSTERY_DEBUFFS.value();
    }

    private void define_allowHarmfulMysteryEffects() {
        VfpConfig.ALLOW_MYSTERY_DEBUFFS.val = this._spec.comment("Set to false to disable selection of harmful effects (debuffs) by uncrafted Mysterious Fruit Salads. This option basically turns generic mysterious fruit salad into a true 'roulette' style item like the standard suspicious stews. Does NOT affect salads crafted directly (where recipe dictates whether debuffs are allowed). Enabled by default; requires restart if changed.").define(VfpConfig.ALLOW_MYSTERY_DEBUFFS.PROPERTY, ALLOW_MYSTERY_DEBUFFS);
    }

    public boolean integrateWithSurvivalMechanics() {
        return VfpConfig._getBooleanOrDefault((String)((String)ADVANCED_SURVIVAL_MECHANICS.value()), (LibConfig.integrateWithSurvivalMods() && WellnessHelper.isAnyExtensionPresent() ? 1 : 0) != 0);
    }

    private void define_integrateWithSurvivalMods() {
        VfpConfig.ADVANCED_SURVIVAL_MECHANICS.val = FlexibleBoolean.define((String)VfpConfig.ADVANCED_SURVIVAL_MECHANICS.PROPERTY, (ForgeConfigSpec.Builder)this._spec.comment("Set to \"false\" to disable direct integration with advanced survival mods like 'Survive'. Use this option if you want full control over all aspects of VFP's integration with your survival framework and environment."));
    }

    private void define_getVanillaProgressionOption(String PROPERTY, boolean defaultValue, String commentString) {
        String property = _MOD_CATEGORY + PROPERTY;
        ModConfigBase.Option option = new ModConfigBase.Option(PROPERTY, _MOD_CATEGORY, (Object)defaultValue);
        option.val = this._spec.comment(commentString).define(property, defaultValue);
        this._cache.put(_INTERNAL + PROPERTY, option);
    }

    private boolean getVanillaProgressionOption(String PROPERTY, boolean errorValue) {
        String property = _INTERNAL + PROPERTY;
        ModConfigBase.Option option = (ModConfigBase.Option)this._cache.get(property);
        return option != null ? (Boolean)option.value() : errorValue;
    }

    private void define_craftOtherSourcesOfWater() {
        this.define_getVanillaProgressionOption("extra_water_crafting", true, "Set to false to disable extra craft recipes for water buckets and bottles; for instance the recipe to convert ice blocks to buckets of water.");
    }

    public boolean craftOtherSourcesOfWater() {
        return this.getVanillaProgressionOption("extra_water_crafting", false);
    }

    private void define_allowInkPearlToEnderPearlConversion() {
        this.define_getVanillaProgressionOption("ink_pearls_to_ender_pearls", true, "Set to false to disable smelting of Ink Pearls to ender pearls. Ignored if strict vanilla progression enabled.");
    }

    public boolean allowInkPearlToEnderPearlConversion() {
        return this.getVanillaProgressionOption("ink_pearls_to_ender_pearls", false);
    }

    private void define_allowLavaSandToBlazeRodConversion() {
        this.define_getVanillaProgressionOption("lava_sand_to_blaze_rods", true, "Set to false to disable crafting of Lava Sand to blaze rods, magma cream, fire charges, and eyes of ender. Basically affects any recipe that uses lava sand instead of blaze powder. Ignored if strict vanilla progression enabled.");
    }

    public boolean allowLavaSandToBlazeRodConversion() {
        return this.getVanillaProgressionOption("lava_sand_to_blaze_rods", false);
    }

    private void define_allowAirSacToDragonBreathConversion() {
        this.define_getVanillaProgressionOption("airsac_to_dragon_breath", true, "Set to false to disable crafting of dragon's breath using Guardian Air Sacs. Ignored if strict vanilla progression or guardian drops are disabled.");
    }

    public boolean allowAirSacToDragonBreathConversion() {
        return this.getVanillaProgressionOption("airsac_to_dragon_breath", false);
    }

    private void define_increaseWoolDrops() {
        this.define_getVanillaProgressionOption("upsized_wool_drops", true, "Set to false to disable upsizing of wool drops from sheep-- VFP will no longer ensure at least 3 wool blocks are dropped per kill. Ignored if strict vanilla progression or general drops upsizing option disabled.");
    }

    public boolean increaseWoolDrops() {
        return this.getVanillaProgressionOption("upsized_wool_drops", true);
    }

    private void define_allowExoBoxes() {
        this.define_getVanillaProgressionOption("guardian_fins_to_shulkerbox", true, "Set to false to disable crafting of 'Exo' shulker boxes using guardian drops. Ignored if strict vanilla progression or guardian drops are disabled.");
    }

    public boolean allowExoBoxes() {
        return this.getVanillaProgressionOption("guardian_fins_to_shulkerbox", false);
    }

    private void define_allowSpawnEggCrafting() {
        this.define_getVanillaProgressionOption("spawnegg_crafting", false, "Set to true to enable Felis Life Essence based craft recipes for some spawn eggs. Disabled by default; requires restart if changed. Ignored if strict vanilla progression is enabled.");
    }

    public boolean allowSpawnEggCrafting() {
        return this.getVanillaProgressionOption("spawnegg_crafting", false);
    }

    private void define_allowInkMirrorCrafting() {
        this.define_getVanillaProgressionOption("inkmirror_crafting", true, "Set to false to disable the craft recipe for ink mirrors. This option affects only the recipe. If provided by some other mechanism, players still need the prerequisite advancements to use a mirror. Enabled by default; requires restart if changed.");
    }

    public boolean allowInkMirrorCrafting() {
        return this.getVanillaProgressionOption("inkmirror_crafting", false);
    }

    private void define_hideStrapsLikeString() {
        this.define_getVanillaProgressionOption("straps_as_string", true, "Set to false to disable substitution of Animal Hide Straps as 'string' in some recipes. Ignored if strict vanilla progression is enabled.");
    }

    public boolean hideStrapsLikeString() {
        return this.getVanillaProgressionOption("straps_as_string", true);
    }

    private void define_canDispenseWoodenBowls() {
        this.define_getVanillaProgressionOption("dispense_wooden_bowls", true, "Set to false to disable the ability to dispense empty wooden bowls to pick up honey, water, and milk. Ignored if strict vanilla progression is enabled.");
    }

    public boolean canDispenseWoodenBowls() {
        return this.getVanillaProgressionOption("dispense_wooden_bowls", true);
    }

    public boolean isAutocraftingEnabled() {
        return (Boolean)SMH_INTEGRATE.value();
    }

    private void define_isAutocraftingEnabled() {
        VfpConfig.SMH_INTEGRATE.val = this._spec.comment("Set to false to disable integration with SmartHoppers mod's various auto-crafting hoppers. Enabled by default; requires restart if changed.").define(VfpConfig.SMH_INTEGRATE.PROPERTY, SMH_INTEGRATE);
    }

    public static final boolean manageThirst() {
        return INSTANCE.integrateWithSurvivalMechanics() && WellnessHelper.manageThirst();
    }

    public static final boolean manageTemperature() {
        return INSTANCE.integrateWithSurvivalMechanics() && WellnessHelper.manageTemperature();
    }

    public static final boolean manageStamina() {
        return INSTANCE.integrateWithSurvivalMechanics() && WellnessHelper.manageEnergy();
    }

    public static boolean hasExtendedFarming() {
        return INSTANCE.isPresent("extended_farming");
    }

    public void setRecipeFlagsEarly() {
        _XFP_PRESENT = this.isExtendedFoodPantryPresent();
        if (_XFP_PRESENT || EXTENDED_FARMING_PRESENT.test(Items.field_190931_a)) {
            this.setPresent("extended_farming");
            this.setPresent("stew_mix");
        }
        super.setRecipeFlagsEarly();
        Tooltips.setHidden((ModIntegration)ModInfo.ID, (!this.showDocumentationTooltips() ? 1 : 0) != 0);
        this.setRecipeFlag(this.allowInkPearlToEnderPearlConversion(), "ender_pearl_recipes");
        this.setRecipeFlag(this.allowLavaSandToBlazeRodConversion(), "blazerod_recipes");
        this.setRecipeFlag(this.allowAirSacToDragonBreathConversion(), "dragonbreath_recipe");
        this.setRecipeFlag(this.allowExoBoxes(), "exo_boxes");
        this.setRecipeFlag(this.includePotionBrewing(), "potion_brewing");
        this.setRecipeFlag(this.includeModDrops(), "mod_drops");
        this.setRecipeFlag(this.includeInterModRecipes(), "inter_mod_recipes");
        this.setRecipeFlag(this.integrateWithSurvivalMechanics(), "advanced_survival");
        this.setRecipeFlag(this.useTreatedWaterRecipes(), "treated_water");
        this.setRecipeFlag(VfpConfig.allowKungFood(true), "kung_food");
        this.setRecipeFlag(VfpConfig.allowFoodFuel(), "food_charcoal");
        this.setRecipeFlag(this.useMushroomBlocksForPantry(), "mushroom_block_storage");
        this.setRecipeFlag(this.useHoneyBlocksForPantry(), "honey_blocks_storage");
        this.setRecipeFlag(this.allowSeedDrying(), "seed_drying");
        this.setRecipeFlag(this.allowSpawnEggCrafting(), "craftable_spawneggs");
        this.setRecipeFlag(this.allowMoonshineMixing(), "moonshine_mixing");
        this.setRecipeFlag(this.allowGeneralFlintCutter(), "general_cutters");
        this.setRecipeFlag(this.allowReheatingAndChillingRecipes(), "hotcold_food");
        this.setRecipeFlag(VfpConfig.allowInstaEating(), "insta_eat");
        this.setRecipeFlag(this.allowInstaPotions(), "insta_potion");
        this.setRecipeFlag(this.craftOtherSourcesOfWater(), "addl_water_recipes");
        this.setRecipeFlag(this.hideStrapsLikeString(), "straps_as_string");
        this.setRecipeFlag(this.includeBatDrops(), "bat_drops");
        this.setRecipeFlag(this.includeCalfDrops(), "calf_drops");
        this.setRecipeFlag(this.includePigDrops(), "pig_drops");
        this.setRecipeFlag(this.includeHorseDrops(), "horse_drops");
        this.setRecipeFlag(!this.excludeHorseMeatDrops(), "horse_meat");
        this.setRecipeFlag(this.includeWolfDrops(), "wolf_drops");
        this.setRecipeFlag(!this.excludeWolfMeatDrops(), "wolf_meat");
        this.setRecipeFlag(this.includeSquidDrops(), "squid_drops");
        this.setRecipeFlag(!this.excludeSquidMeatDrops(), "squid_meat");
        this.setRecipeFlag(this.includePolarBearDrops(), "polarbear_drops");
        this.setRecipeFlag(!this.excludePolarBearMeatDrops(), "polarbear_meat");
        this.setRecipeFlag(this.includeLlamaDrops(), "llama_drops");
        this.setRecipeFlag(!this.excludeLlamaMeatDrops(), "llama_meat");
        this.setRecipeFlag(this.includeOcelotDrops(), "ocelot_drops");
        this.setRecipeFlag(this.includeGuardianDrops(), "guardian_drops");
        this.setRecipeFlag(!this.excludeGuardianMeatDrops(), "guardian_meat");
        this.setRecipeFlag(this.includeZombieDrops(), "zombie_drops");
        this.setRecipeFlag(this.includePhantomDrops(), "phantom_drops");
        this.setRecipeFlag(this.includeRavagerDrops(), "ravager_drops");
        this.setRecipeFlag(this.includeAcornDrops(), "acorn_drops");
        this.setRecipeFlag(this.includeUgliFruitDrops(), "ugli_drops");
        this.setRecipeFlag(this.includeSpruceTipDrops(), "sprucetips");
        boolean nn = this.computeNutritionNotes();
        this.setRecipeFlag(nn, "nutrition_notes");
        this.setRecipeFlag(nn, "typed_milk");
        this.setRecipeFlag(nn, "typed_sweetener");
    }

    protected void fullyDefineInternal() {
        this.define_version();
        this.define_isDebugMode();
        this.define_isSuperCompatibilityMode();
        this.define_showDocumentationTooltips();
        this.define_strictVanillaProgression();
        this.define_includeCraftingXp();
        this.define_includePotionBrewing();
        this.define_includeModDrops();
        this.define_generousCraftingXp();
        this.define_isOreGenerationEnabled();
        this.define_allowLootTableEnrichment();
        this.define_preferSingleUseFood();
        this.define_singleUsePerType();
        this.define_allowKungFood();
        this.define_allowFoodFuel();
        this.define_includeBoneDrops();
        this.define_includeLeatherDrops();
        this.define_ensureDeathDrops();
        this.define_includeBatDrops();
        this.define_includeCalfDrops();
        this.define_includePigDrops();
        this.define_includeHorseDrops();
        this.define_includeWolfDrops();
        this.define_includeSquidDrops();
        this.define_includePolarBearDrops();
        this.define_includeLlamaDrops();
        this.define_includeOcelotDrops();
        this.define_includeGuardianDrops();
        this.define_includeZombieDrops();
        this.define_includePhantomDrops();
        this.define_includeRavagerDrops();
        this.define_allowGeneralFlintCutter();
        this.define_excludeHorseMeatDrops();
        this.define_excludeSquidMeatDrops();
        this.define_excludeWolfMeatDrops();
        this.define_excludePolarBearMeatDrops();
        this.define_excludeLlamaMeatDrops();
        this.define_excludeGuardianMeatDrops();
        this.define_excludeRavagerMeatDrops();
        this.define_showAllItemsInUI();
        this.define_includeInterModRecipes();
        this.define_includeBartering();
        this.define_useTreatedWaterRecipes();
        this.define_integrateWithSurvivalMods();
        this.define_computeNutritionNotes();
        this.define_showNutritionNotes();
        this.define_checkNutritionNotesOnPickup();
        this.define_increaseWoolDrops();
        this.define_llamasDropRegularWool();
        this.define_allowPolarbearBreeding();
        this.define_allowInkPearlToEnderPearlConversion();
        this.define_allowInkMirrorCrafting();
        this.define_allowLavaSandToBlazeRodConversion();
        this.define_allowAirSacToDragonBreathConversion();
        this.define_allowExoBoxes();
        this.define_hideStrapsLikeString();
        this.define_maxDrinksStackCapacity();
        this.define_maxSoupsStackCapacity();
        this.define_maxFoodPointsPerMultiuseFood();
        this.define_craftOtherSourcesOfWater();
        this.define_useMushroomBlocksForPantry();
        this.define_useHoneyBlocksForPantry();
        this.define_canDispenseWoodenBowls();
        this.define_increaseShroomDrops();
        this.define_includeAcornDrops();
        this.define_includeUgliFruitDrops();
        this.define_includeSpruceTipDrops();
        this.define_includeBambooShootsDrops();
        this.define_isAutocraftingEnabled();
        this.define_allowAnyFoodInGenericDecker();
        this.define_showDeckerIngredients();
        this.define_includeReheatingAndChillingRecipes();
        this.define_allowSeedDrying();
        this.define_allowSpawnEggCrafting();
        this.define_allowMoonshineMixing();
        this.define_maxMoonshineMixCapacity();
        this.define_maxMysteriousEffectDuration();
        this.define_allowHarmfulMysteryEffects();
        this.define_allowInstaEating();
        this.define_allowInstaPotions();
    }

    static {
        DEBUG_INFO = VanillaFoodPantry.DESPERATION_DEBUG;
        DEBUG_MODE = new ModConfigBase.Option("debug_mode", _GENERAL, (Object)false);
        SHOW_TOOLTIPS = new ModConfigBase.Option("show_doc_tooltips", _GENERAL, (Object)true);
        COMPAT_MODE = new ModConfigBase.Option("super_compatibility_mode", _GENERAL, (Object)false);
        CRAFTING_XP = new ModConfigBase.Option("crafting_xp_enabled", _GENERAL, (Object)true);
        GENEROUS_XP = new ModConfigBase.Option("generous_xp", _GENERAL, (Object)true);
        ANY_MOD_DROPS = new ModConfigBase.Option("drops_enabled", _GENERAL, (Object)true);
        ORE_GEN = new ModConfigBase.Option("ore_generate_enabled", _GENERAL, (Object)true);
        ENRICH_LOOT = new ModConfigBase.Option("enrich_loot_tables", _GENERAL, (Object)true);
        STRICT_PROGRESS = new ModConfigBase.Option("strict_progression", _GENERAL, (Object)FlexibleBoolean.DEFAULT.setting());
        TREAT_WATER = new ModConfigBase.Option("treat_raw_water", _GENERAL, (Object)FlexibleBoolean.DEFAULT.setting());
        SINGLE_USE_FOODS = new ModConfigBase.Option("prefer_singleuse", _GENERAL, (Object)FlexibleBoolean.DEFAULT.setting());
        SINGLE_USE_PER_TYPE = new ModConfigBase.Option("singleuse", _UPSIZER, Arrays.asList("bread=false", "dessert_pies=*DEFAULT*", "stuffed_potatoes=*DEFAULT*", "stews=*DEFAULT*"));
        SEED_DRYING = new ModConfigBase.Option("seed_drying_enabled", _GENERAL, (Object)true);
        POTION_BREWING = new ModConfigBase.Option("potions_enabled", _GENERAL, (Object)true);
        MOONSHINE_MIXING = new ModConfigBase.Option("moonshine_mixing_enabled", _GENERAL, (Object)true);
        MAX_MOONSHINE_POTIONS = new ModConfigBase.Option("moonshine_max_potions", _UPSIZER, (Object)7);
        MYSTERY_EFFECTS_DURATION = new ModConfigBase.Option("mystery_effects_duration_secs", _UPSIZER, (Object)480);
        FOOD_ONLY_CUTTERS = new ModConfigBase.Option("flint_cutter_for_food_only", _GENERAL, (Object)false);
        INSTA_EAT_MORSELS = new ModConfigBase.Option("insta_eat_morsels", _GENERAL, (Object)false);
        INSTA_EAT_SOAKED = new ModConfigBase.Option("insta_eat_soaked", _GENERAL, (Object)false);
        BEARS_LUV_SALMON = new ModConfigBase.Option("polarbear_breeding", _GENERAL, (Object)true);
        MAX_DRINKS_STACKSIZE = new ModConfigBase.Option("drinks_max_stacksize", _UPSIZER, (Object)VfpCapacity.LIQUID_STACK.count());
        MAX_SOUPS_STACKSIZE = new ModConfigBase.Option("soups_max_stacksize", _UPSIZER, (Object)VfpCapacity.LIQUID_STACK.count());
        BAT_DROPS = new ModConfigBase.Option("include_bat_drops", _BUTCHER, (Object)true);
        CALF_DROPS = new ModConfigBase.Option("include_calf_drops", _BUTCHER, (Object)true);
        PIG_DROPS = new ModConfigBase.Option("include_pig_drops", _BUTCHER, (Object)true);
        HORSE_DROPS = new ModConfigBase.Option("include_horse_drops", _BUTCHER, (Object)true);
        WOLF_DROPS = new ModConfigBase.Option("include_wolf_drops", _BUTCHER, (Object)true);
        SQUIDD_DROPS = new ModConfigBase.Option("include_squid_drops", _BUTCHER, (Object)true);
        POLARBEAR_DROPS = new ModConfigBase.Option("include_polarbear_drops", _BUTCHER, (Object)true);
        LLAMA_DROPS = new ModConfigBase.Option("include_llama_drops", _BUTCHER, (Object)true);
        OZELOT_DROPS = new ModConfigBase.Option("include_ocelot_drops", _BUTCHER, (Object)true);
        GUARDIAN_DROPS = new ModConfigBase.Option("include_guardian_drops", _BUTCHER, (Object)true);
        ZOMBIE_DROPS = new ModConfigBase.Option("include_zombie_drops", _BUTCHER, (Object)true);
        PHANTOM_DROPS = new ModConfigBase.Option("include_phantom_drops", _BUTCHER, (Object)true);
        RAVAGER_DROPS = new ModConfigBase.Option("include_ravager_drops", _BUTCHER, (Object)true);
        ENSURE_DEATH_DROPS = new ModConfigBase.Option("ensure_death_drops", _BUTCHER, (Object)true);
        BONE_DROPS = new ModConfigBase.Option("include_bone_drops", _BUTCHER, (Object)FlexibleBoolean.DEFAULT.setting());
        LEATHER_DROPS = new ModConfigBase.Option("include_leather_drops", _BUTCHER, (Object)FlexibleBoolean.DEFAULT.setting());
        EXCLUDE_HORSE_MEAT = new ModConfigBase.Option("exclude_horse_meat", _BUTCHER, (Object)false);
        EXCLUDE_SQUID_MEAT = new ModConfigBase.Option("exclude_squid_meat", _BUTCHER, (Object)false);
        EXCLUDE_WOLF_MEAT = new ModConfigBase.Option("exclude_wolf_meat", _BUTCHER, (Object)false);
        EXCLUDE_POLARBEAR_MEAT = new ModConfigBase.Option("exclude_polarbear_meat", _BUTCHER, (Object)false);
        EXCLUDE_LLAMA_MEAT = new ModConfigBase.Option("exclude_llama_meat", _BUTCHER, (Object)false);
        LLAMAS_DROP_WOOL = new ModConfigBase.Option("llamas_drop_wool", _BUTCHER, (Object)false);
        EXCLUDE_GUARDIAN_MEAT = new ModConfigBase.Option("exclude_guardian_meat", _BUTCHER, (Object)false);
        EXCLUDE_RAVAGER_MEAT = new ModConfigBase.Option("exclude_ravager_meat", _BUTCHER, (Object)false);
        MUSHROOM_PANTRY_BLOCK = new ModConfigBase.Option("mushroom_pantry_blocks", _PRODUCE, (Object)false);
        UPSIZE_MUSHROOM_DROPS = new ModConfigBase.Option("upsize_mushroom_drops", _PRODUCE, (Object)true);
        ACORN_DROPS = new ModConfigBase.Option("include_acorn_drops", _PRODUCE, (Object)true);
        UGLIFRUIT_DROPS = new ModConfigBase.Option("include_raftugli_drops", _PRODUCE, (Object)true);
        SPRUCETIP_DROPS = new ModConfigBase.Option("include_spruce_tip_drops", _PRODUCE, (Object)true);
        BAMBOO_SHOOTS_DROPS = new ModConfigBase.Option("include_bamboo_shoots_drops", _PRODUCE, (Object)true);
        HONEY_PANTRY_BLOCKS = new ModConfigBase.Option("honey_pantry_blocks", _PRODUCE, (Object)true);
        NUTRITION_NOTES = new ModConfigBase.Option("calc_nutrition_notes", _OTHRMOD, (Object)FlexibleBoolean.DEFAULT.setting());
        SHOW_NUTRITION_NOTES = new ModConfigBase.Option("show_nutrition_notes", _OTHRMOD, (Object)FlexibleBoolean.DEFAULT.setting());
        NUTRITION_NOTES_PICKUP = new ModConfigBase.Option("add_nutrition_notes_on_pickup", _OTHRMOD, (Object)false);
        SHOW_ALL_ITEMS = new ModConfigBase.Option("show_all_items_in_ui", _OTHRMOD, (Object)false);
        ANY_FOOD_IN_GENERIC_DECKER = new ModConfigBase.Option("any_food_in_myway_decker", _OTHRMOD, (Object)true);
        MAX_FOODPTS_PER_CONSUMABLE = new ModConfigBase.Option("max_foodpts_per_multiuse", _UPSIZER, (Object)VfpPantryItem.MAX_TOTAL_FOOD_VALUE_ALLOWED);
        SHOW_DECKER_FULLTIP = new ModConfigBase.Option("show_sandwich_ingredients", _MISC, (Object)true);
        INTERMOD_RECIPES = new ModConfigBase.Option("modded_ingredients", _OTHRMOD, (Object)true);
        KUNG_FOOD = new ModConfigBase.Option("fighting_food", _OTHRMOD, (Object)FlexibleBoolean.DEFAULT.setting());
        FOOD_FUEL = new ModConfigBase.Option("food_charcoal", _OTHRMOD, (Object)FlexibleBoolean.DEFAULT.setting());
        BARTERING = new ModConfigBase.Option("modded_trading_allowed", _OTHRMOD, (Object)FlexibleBoolean.DEFAULT.setting());
        WARMING_COOLING_RECIPES = new ModConfigBase.Option("hotcold_food_crafting", _OTHRMOD, (Object)true);
        ALLOW_MYSTERY_DEBUFFS = new ModConfigBase.Option("harmful_mystery_effects", _OTHRMOD, (Object)true);
        ADVANCED_SURVIVAL_MECHANICS = new ModConfigBase.Option("modded_survival", _OTHRMOD, (Object)FlexibleBoolean.DEFAULT.setting());
        SMH_INTEGRATE = new ModConfigBase.Option("auto_integrate", "integration.smarthoppers.", (Object)true);
        EXTENDED_FARMING_PRESENT = new VfpExtendedPlainItem.IsIngredientPresent(VfpAware.IdDomain.MODID, "croptopia", "pamhc2crops", "simplefarming");
    }
}

