/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import com.google.common.base.Predicates;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class VfpExtendedPlainItem
extends VfpPlainItem {
    protected Predicate<Item> _show_self = Predicates.alwaysTrue();

    public VfpExtendedPlainItem(@Nonnull VfpProfile profile, @Nonnull Predicate<Item> test, ItemGroup tab) {
        super(profile, tab);
        Validate.notNull(test, (String)"A non-null test is required", (Object[])new Object[0]);
        this._show_self = test;
    }

    protected VfpExtendedPlainItem(@Nonnull VfpProfile profile, ItemGroup tab) {
        super(profile, tab);
    }

    public boolean isHiddenByDefault() {
        if (VfpConfig.getInstance().showAllItemsInUI()) {
            return false;
        }
        return !this._show_self.test((Item)this);
    }

    public static final class IsIngredientPresent
    implements Predicate<Item> {
        private final String[] _choices;
        private final VfpAware.IdDomain _selector;

        public IsIngredientPresent(VfpAware.IdDomain selector, String ... choices) {
            Validate.isTrue((selector != null && choices != null && choices.length > 0 ? 1 : 0) != 0);
            this._selector = selector;
            this._choices = choices;
        }

        @Override
        public boolean test(Item item) {
            VfpConfig config = VfpConfig.getInstance();
            switch (this._selector) {
                case MODID: {
                    if (!config.includeInterModRecipes()) break;
                    for (String modid : this._choices) {
                        if (!config.isModLoaded(modid)) continue;
                        return true;
                    }
                    break;
                }
                case CONFIG: {
                    for (String ingredient : this._choices) {
                        if (!config.isPresent(ingredient)) continue;
                        return true;
                    }
                    break;
                }
                case REGISTRY: {
                    for (String rstring : this._choices) {
                        ResourceLocation rid = ResourceLocation.func_208304_a((String)rstring);
                        if (rid == null || !ForgeRegistries.ITEMS.containsKey(rid)) continue;
                        return true;
                    }
                    break;
                }
                default: {
                    for (String taggroup : this._choices) {
                        if (!RID.isIngredientDefined((String)taggroup)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

