/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BoneMealItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.DeferredWorkQueue;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.BlockXyz;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.ModIntegration;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Whatis;
import org.jwaresoftware.mcmods.lib.api.CompostType;
import org.jwaresoftware.mcmods.lib.api.ICompostable;
import org.jwaresoftware.mcmods.lib.api.IFertilizer;
import org.jwaresoftware.mcmods.lib.api.PropertyDefinition;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class VfpFertilizerItem
extends VfpPlainItem
implements ICompostable,
IFertilizer {
    private static final int _BONEMEAL_DONE_SFX = 2005;
    private static final int _DISPENSE_DONE_SFX = 1000;
    private static final int _DISPENSE_FAIL_SFX = 1001;

    public VfpFertilizerItem(@Nonnull VfpProfile profile) {
        super(profile);
    }

    public VfpFertilizerItem(@Nonnull VfpProfile profile, Item.Properties ip) {
        super(profile, ip);
    }

    public float getCompostChance(Item fertilizer) {
        return 1.0f;
    }

    public CompostType getCompostType(ItemStack fertilizer) {
        return CompostType.NITROGEN;
    }

    protected boolean isUsable(ItemUseContext context) {
        return true;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        World world = context.func_195991_k();
        Direction side = context.func_196000_l();
        ItemStack stack = player.func_184586_b(context.func_221531_n());
        BlockPos hit_pos = context.func_195995_a();
        BlockPos growth_pos = context.func_195995_a().func_177972_a(side);
        if (this.isUsable(context) && player.func_175151_a(growth_pos, side, stack) && this.applyFertilizer(stack, world, hit_pos, growth_pos, context)) {
            this.addUsedStat(player);
            if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                this.reflectAppliedToPlayer(world, hit_pos);
                this.checkApplyAdvancements(world, player, hit_pos, stack);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_195939_a(context);
    }

    protected void reflectAppliedToPlayer(World world, BlockPos hit_pos) {
        if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            Effects.playFertilizedSuccessfully((World)world, (BlockPos)hit_pos);
        }
    }

    protected void checkApplyAdvancements(World world, PlayerEntity player, BlockPos hit_pos, ItemStack with) {
    }

    protected boolean applyFertilizer(ItemStack fertilizer, World world, BlockPos hit_pos, BlockPos growth_pos, ItemUseContext iuc) {
        return VfpFertilizerItem.applyBonemeal(fertilizer, world, hit_pos, growth_pos, iuc);
    }

    public static final boolean applyBonemeal(ItemStack fertilizer, World world, BlockPos to, BlockPos growth_pos, ItemUseContext iuc) {
        BlockState hit = world.func_180495_p(to);
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)iuc.func_195999_j(), (World)world, (BlockPos)to, (BlockState)hit, (ItemStack)fertilizer);
        if (hook != 0) {
            return hook > 0;
        }
        if (VfpFertilizerItem.applyBonemealImpl(fertilizer, world, to, (LivingEntity)iuc.func_195999_j(), iuc.func_221531_n())) {
            return true;
        }
        boolean solid = hit.func_224755_d((IBlockReader)world, to, iuc.func_196000_l());
        return solid && BoneMealItem.func_203173_b((ItemStack)iuc.func_195996_i(), (World)world, (BlockPos)growth_pos, (Direction)iuc.func_196000_l());
    }

    private static final boolean bonemealAlwaysEffective(BlockState state, IGrowable growable) {
        return Whatis.isMushroom((BlockState)state) || Whatis.isLikelySapling((BlockState)state);
    }

    public static final boolean applyBonemeal(ItemStack fertilizer, World world, BlockPos to, PlayerEntity player, Hand hand) {
        BlockState hit = world.func_180495_p(to);
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)world, (BlockPos)to, (BlockState)hit, (ItemStack)fertilizer);
        if (hook != 0) {
            return hook > 0;
        }
        return VfpFertilizerItem.applyBonemealImpl(fertilizer, world, to, (LivingEntity)player, hand);
    }

    public static final boolean applyBonemealImpl(ItemStack fertilizer, World world, BlockPos to, LivingEntity user, Hand hand) {
        boolean updateStack;
        BlockState hit = world.func_180495_p(to);
        Block block = hit.func_177230_c();
        boolean bl = updateStack = SharedGlue.isaPlayer((Entity)user) && SharedGlue.getPlayerInSurvival((PlayerEntity)((PlayerEntity)user));
        if (block instanceof IGrowable) {
            IGrowable growable = (IGrowable)block;
            if (growable.func_176473_a((IBlockReader)world, to, hit, SharedGlue.isaClientWorld((IWorldReader)world))) {
                boolean used = true;
                if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                    boolean always = fertilizer.func_77973_b() instanceof IFertilizer && VfpFertilizerItem.bonemealAlwaysEffective(hit, growable);
                    used = false;
                    if (always || growable.func_180670_a(world, user.func_70681_au(), to, hit)) {
                        growable.func_225535_a_((ServerWorld)world, user.func_70681_au(), to, hit);
                        used = true;
                    }
                    if (used && updateStack) {
                        SharedGlue.usedItem((LivingEntity)user, (ItemStack)fertilizer, (Hand)hand);
                    }
                }
                return used;
            }
        } else if (hit.func_235714_a_((ITag)RID.Tags.OTHER_BONEMEALABLE)) {
            if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                boolean always;
                PropertyDefinition ageinfo = PropertyDefinition.getAgeFrom((BlockState)hit, (String[])new String[0]);
                if (ageinfo != null && ageinfo.value < ageinfo.max_value) {
                    if (ModIntegration.MINECRAFT.belongsTo(block.getRegistryName()) && world.func_175625_s(to) == null) {
                        world.func_175656_a(to, (BlockState)hit.func_206870_a((Property)ageinfo.property, (Comparable)Integer.valueOf(ageinfo.max_value)));
                    }
                    hit.func_227033_a_((ServerWorld)world, to, user.func_70681_au());
                    if (ageinfo.reading(world.func_180495_p(to)) > ageinfo.value) {
                        if (updateStack) {
                            SharedGlue.usedItem((LivingEntity)user, (ItemStack)fertilizer, (Hand)hand);
                        }
                        return true;
                    }
                    if (SharedGlue.isSame((Block)block, (Block)Blocks.field_150388_bm)) {
                        return false;
                    }
                }
                if (!SharedGlue.isaPlayer((Entity)user)) {
                    return false;
                }
                boolean bl2 = always = SharedGlue.isSame((Block)block, (Block)Blocks.field_150388_bm) || hit.func_235714_a_((ITag)BlockTags.field_219746_E) || hit.func_235714_a_((ITag)RID.Tags.VINES);
                if (!always && user.func_70681_au().nextFloat() > 0.72f) {
                    if (updateStack) {
                        SharedGlue.usedItem((LivingEntity)user, (ItemStack)fertilizer, (Hand)hand);
                    }
                    return true;
                }
                BlockXyz xyz = new BlockXyz((IWorldReader)world, hit, to);
                ItemStack dropped = ItemStacks.modded_create((BlockXyz)xyz, (int)(1 + (user.func_70681_au().nextFloat() < 0.0625f ? 1 : 0)));
                Block.func_180635_a((World)world, (BlockPos)to, (ItemStack)dropped);
                if (updateStack) {
                    SharedGlue.usedItem((LivingEntity)user, (ItemStack)fertilizer, (Hand)hand);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean applyBonemeal(ItemStack fertilizer, World world, BlockPos to) {
        return SharedGlue.isaServerWorld((IWorldReader)world) ? VfpFertilizerItem.applyBonemeal(fertilizer, world, to, (PlayerEntity)FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)world)), Hand.MAIN_HAND) : false;
    }

    public static final void initDispenseBehavior(Item instance) {
        Validate.notNull((Object)instance, (String)"A non-null fertilizer item is required", (Object[])new Object[0]);
        DeferredWorkQueue.runLater(() -> DispenserBlock.func_199774_a((IItemProvider)instance, (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){
            private boolean _dispensed = true;

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                BlockPos blockpos;
                ServerWorld world = source.func_197524_h();
                if (!VfpFertilizerItem.applyBonemeal(stack, (World)world, blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a))) && !BoneMealItem.func_203173_b((ItemStack)stack, (World)world, (BlockPos)blockpos, null)) {
                    this._dispensed = false;
                } else if (SharedGlue.isaServerWorld((IWorldReader)world)) {
                    world.func_217379_c(2005, blockpos, 0);
                }
                return stack;
            }

            protected void func_82485_a(IBlockSource source) {
                if (this._dispensed) {
                    source.func_197524_h().func_217379_c(1000, source.func_180699_d(), 0);
                } else {
                    source.func_197524_h().func_217379_c(1001, source.func_180699_d(), 0);
                }
            }
        }));
    }
}

