/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.api.IDrink;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public abstract class VfpLiquidFood
extends VfpPantryItem
implements IDrink {
    public static final VfpCapacity DEFAULT_STACK_SIZE = VfpCapacity.LIQUID_STACK;
    @Nonnull
    protected final LiquidType _drinkType;

    protected VfpLiquidFood(@Nonnull VfpProfile profile, LikeFood food, @Nonnull LiquidType type, ItemGroup tab) {
        super(profile, food, tab, true);
        this._drinkType = type;
        this.setMaxStackSize(this.getItemMaxStackSize().count());
        this.setContainerItem(this.getNewEmptyContainer());
        this.completeInit(profile);
    }

    protected VfpLiquidFood(@Nonnull VfpProfile profile, LikeFood food, @Nonnull LiquidType type) {
        this(profile, food, type, null);
    }

    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxDrinksStackCapacity(DEFAULT_STACK_SIZE);
    }

    protected abstract Item getNewEmptyContainer();

    @Override
    protected ItemStack onItemConsumedFully(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        return VfpLiquidFood.returnOrDropContainer((ItemStack)remaining, (PlayerEntity)player, (ItemStack)ItemStacks.create((Item)this.getNewEmptyContainer()));
    }

    @Override
    public final IDrink defaultThirstAffect(ItemStack food) {
        return this;
    }

    public final float getThirstQuenched(ItemStack food) {
        return this._drinkType.getThirstQuenched(food);
    }

    public final float getHydrationAdded(ItemStack food) {
        return this._drinkType.getHydrationAdded(food);
    }

    public final float getThirstTriggerChance(ItemStack food, @Nullable LivingEntity drinker) {
        return this._drinkType.getThirstTriggerChance(food, drinker);
    }

    public final float getDamageChanceIfDrunk(ItemStack food, @Nullable LivingEntity drinker) {
        return this._drinkType.getDamageChanceIfDrunk(food, drinker);
    }
}

