/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.PushReaction;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStackDef;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ICraftedStorage;
import org.jwaresoftware.mcmods.lib.api.ILuckAffected;
import org.jwaresoftware.mcmods.lib.impl.block.BlockSupport;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainBlock;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public class VfpPantryBlock
extends VfpPlainBlock
implements ICraftedStorage {
    @Nonnull
    protected final ItemStackDef _constituent;
    @Nullable
    private ItemStack _constituentFinal;

    public VfpPantryBlock(@Nonnull VfpProfile profile, AbstractBlock.Properties bp, @Nonnull ItemStackDef constituent) {
        super(profile, bp);
        Validate.notNull((Object)constituent, (String)"A non-null constituent item is required for a pantry block", (Object[])new Object[0]);
        Validate.isTrue((boolean)constituent.isSingle(), (String)"A pantry block's constituent must be of stacksize ONE", (Object[])new Object[0]);
        this._constituent = constituent.copy();
    }

    public VfpPantryBlock(@Nonnull VfpProfile profile, Block likeBlock, @Nonnull ItemStackDef constituent, SoundType sound) {
        this(profile, AbstractBlock.Properties.func_200950_a((AbstractBlock)likeBlock).func_200947_a(sound), constituent);
    }

    public VfpPantryBlock(@Nonnull VfpProfile profile, Block likeBlock, @Nonnull ItemStackDef constituent) {
        this(profile, likeBlock, constituent, SharedGlue.Block_soundType_Gravel);
    }

    public VfpPantryBlock(@Nonnull VfpProfile profile, Block likeBlock, Item constituent, SoundType sound) {
        this(profile, likeBlock, new ItemStackDef(constituent), sound);
    }

    public VfpPantryBlock(@Nonnull VfpProfile profile, Block likeBlock, Item constituent) {
        this(profile, likeBlock, new ItemStackDef(constituent));
    }

    @Nonnull
    protected final ItemStack constituent() {
        if (this._constituentFinal == null) {
            this._constituentFinal = this._constituent.safeget();
        }
        return this._constituentFinal;
    }

    public ItemStack getItemDropped(BlockState state, Random rng, int fortune) {
        int n;
        VfpCapacity cap = this._profile.capacity();
        int n2 = n = cap != null && cap != VfpCapacity.NONE ? cap.count() : VfpCapacity.STANDARD_BLOCK.count();
        if (fortune > 0 && this instanceof ILuckAffected) {
            if (fortune > 4) {
                fortune = 4;
            }
            n += rng.nextInt(fortune);
        }
        return ItemStacks.copy((ItemStack)this.constituent(), (int)n);
    }

    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return BlockSupport.getBlockDrops((BlockState)state, (LootContext.Builder)builder, (boolean)false);
    }

    public PushReaction func_149656_h(BlockState state) {
        return this.isEffectivelyDense(state) ? PushReaction.NORMAL : PushReaction.DESTROY;
    }

    protected boolean isEffectivelyDense(@Nullable BlockState state) {
        return this._profile.isLiquid() ? false : this._profile.isDense();
    }

    public ICraftedStorage.Type storedType() {
        return ICraftedStorage.Type.ITEM;
    }

    public int quantityStored(ItemStack stack, PlayerEntity player) {
        int m;
        int n = 1;
        ItemStack component = this.constituent();
        if (component.func_77973_b() instanceof ICraftedStorage && (m = ((ICraftedStorage)component.func_77973_b()).quantityStored(component, player)) > 0) {
            n = m;
        }
        m = VfpCapacity.STANDARD_BLOCK.count();
        if (this._profile.capacity() != VfpCapacity.NONE) {
            m = this._profile.capacity().count();
        }
        return n * m * (stack == null ? 1 : ItemStacks.getSize((ItemStack)stack));
    }

    public int quantityStored(BlockState block, PlayerEntity player) {
        return -1;
    }
}

