/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.world.World;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.impl.ItemBase;
import org.jwaresoftware.mcmods.vfp.common.VfpAware;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public class VfpPlainItem
extends ItemBase
implements VfpAware {
    public static final String NBT_PORTION_CAPACITY = "PortionCapacity";
    public static final String NBT_PORTION_TYPE = "PortionType";
    protected final VfpProfile _profile;

    public VfpPlainItem(@Nonnull VfpProfile profile, boolean hide, @Nullable Item.Properties ip) {
        super(profile.fmlid(), hide, ip != null ? ip : VfpUtils.newproperties(VfpUtils.bestTab(profile)));
        Validate.isTrue((boolean)profile.isItem(), (String)"A plain item's VFP type MUST align as an Item", (Object[])new Object[0]);
        this._profile = profile;
    }

    public VfpPlainItem(@Nonnull VfpProfile profile, boolean hide, ItemGroup tab) {
        this(profile, hide, VfpUtils.newproperties(tab));
    }

    public VfpPlainItem(@Nonnull VfpProfile profile, ItemGroup tab) {
        this(profile, false, tab);
    }

    public VfpPlainItem(@Nonnull VfpProfile profile, @Nullable Item.Properties ip) {
        this(profile, false, ip);
    }

    public VfpPlainItem(@Nonnull VfpProfile profile, boolean hide) {
        this(profile, hide, (Item.Properties)null);
    }

    public VfpPlainItem(@Nonnull VfpProfile profile) {
        this(profile, false, (Item.Properties)null);
    }

    public final String itemid_prefix() {
        return this._profile.itemid_prefix();
    }

    @Override
    public final VfpProfile vfplink() {
        return this._profile;
    }

    public VfpPlainItem setUncommon(boolean flag) {
        this.setRarity(Rarity.UNCOMMON);
        return this;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment e) {
        return false;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
        this.onCookedOrCrafted(stack);
    }

    public final <T extends VfpPlainItem> T autoregister(Class<T> of) {
        this.autoregister();
        return (T)((VfpPlainItem)of.cast(this));
    }

    public VfpPlainItem autoregister() {
        VfpUtils.autoregisterItem((Item)this, this._profile);
        return this;
    }
}

