/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraftforge.event.brewing.PotionBrewEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.IniRegistries;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.impl.effects.AttentivenessEffect;
import org.jwaresoftware.mcmods.lib.impl.effects.EnergizedEffect;
import org.jwaresoftware.mcmods.lib.integration.WellnessHelper;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpMarkerPotion;
import org.jwaresoftware.mcmods.vfp.meals.AlwaysFedEffect;
import org.jwaresoftware.mcmods.vfp.tonics.BatSightedEffect;
import org.jwaresoftware.mcmods.vfp.tonics.CarrotVisionEffect;
import org.jwaresoftware.mcmods.vfp.tonics.GuardiansGraceEffect;
import org.jwaresoftware.mcmods.vfp.tonics.KelpedEffect;

public final class VfpPotions {
    public static Effect FOOD_WARMING;
    public static Effect FOOD_COOLING;
    public static Effect WELL_STUFFED;
    public static Effect KELPED;
    public static Effect CARROT_VISION;
    public static Effect GUARDIANS_GRACE;
    public static Effect BAT_SIGHTED;
    public static Potion STRONG_STIMULANT;
    public static Potion WATER_NATIVE;
    public static Potion LONG_WATER_NATIVE;
    public static Potion STRONG_WATER_NATIVE;
    public static Potion WOLF_SPIRIT;
    public static Potion SUPER_WOLF_SPIRIT;
    public static Potion BEAR_SPIRIT;
    public static Potion SUPER_BEAR_SPIRIT;
    public static Potion FOOD_POISONING;
    public static Potion BADD_JUJU;
    public static Potion SUPER_GOOD_JUJU;
    public static Potion SUGAR_BOMBED;
    public static Potion SUGARRGH_BOMBED;
    public static Potion LONG_SUGAR_BOMBED;
    public static Potion UNDYING;
    public static Potion LONG_UNDYING;
    public static Potion VIGOR;
    public static Potion LONG_VIGOR;
    public static Potion VILLAGE_HEXED;
    public static Potion LEVITATION;
    public static Potion LONG_LEVITATION;
    public static Potion SWAMP_ESSENCE;
    public static Potion STRONG_SWAMP_ESSENCE;
    public static Potion GUARDIANS_GRACE_AURA;
    static final HashMap<Potion, Integer> _typeToColorMap;

    public static final Potion newType(String name, EffectInstance ... effects) {
        Potion pt = new Potion("vfp_" + name, effects);
        IniRegistries.autoregisterPotionType((String)"vanillafoodpantry", (Potion)pt, (String)name);
        return pt;
    }

    public static final Potion newInternalType(String name, EffectInstance ... effects) {
        Potion pt = (Potion)new Potion("vfp_" + name, effects).setRegistryName("vanillafoodpantry", name);
        return pt;
    }

    public static final void init(VfpConfig config) {
        FOOD_WARMING = new VfpMarkerPotion("heated_food", true, false, 16753408, false);
        IniRegistries.autoregisterPotion((String)"vanillafoodpantry", (Effect)FOOD_WARMING, (String)"heated_food");
        FOOD_COOLING = new VfpMarkerPotion("cooled_food", true, false, 11063295, false);
        IniRegistries.autoregisterPotion((String)"vanillafoodpantry", (Effect)FOOD_COOLING, (String)"cooled_food");
        WELL_STUFFED = new AlwaysFedEffect("well_stuffed", 14327569, false);
        IniRegistries.autoregisterPotion((String)"vanillafoodpantry", (Effect)WELL_STUFFED, (String)"well_stuffed");
        KELPED = new KelpedEffect("kelped", 16251086, false);
        IniRegistries.autoregisterPotion((String)"vanillafoodpantry", (Effect)KELPED, (String)"kelped");
        GUARDIANS_GRACE = new GuardiansGraceEffect("guardians_grace", 5943204, false);
        IniRegistries.autoregisterPotion((String)"vanillafoodpantry", (Effect)GUARDIANS_GRACE, (String)"guardians_grace");
        BAT_SIGHTED = new BatSightedEffect("bat_sighted", 15396118, false);
        IniRegistries.autoregisterPotion((String)"vanillafoodpantry", (Effect)BAT_SIGHTED, (String)"bat_sighted");
        CARROT_VISION = new CarrotVisionEffect("carrot_vision", 16634444, false);
        IniRegistries.autoregisterPotion((String)"vanillafoodpantry", (Effect)CARROT_VISION, (String)"carrot_vision");
        GUARDIANS_GRACE_AURA = VfpPotions.newInternalType("guardians_grace_aura", Potions.newPotionTypeEffect((Effect)GUARDIANS_GRACE, (int)180, (int)0));
        if (!config.includePotionBrewing()) {
            Potion _EMPTY;
            STRONG_STIMULANT = _EMPTY = SharedGlue.PotionType_empty;
            WATER_NATIVE = _EMPTY;
            LONG_WATER_NATIVE = _EMPTY;
            STRONG_WATER_NATIVE = _EMPTY;
            WOLF_SPIRIT = _EMPTY;
            SUPER_WOLF_SPIRIT = _EMPTY;
            BEAR_SPIRIT = _EMPTY;
            SUPER_BEAR_SPIRIT = _EMPTY;
            BADD_JUJU = _EMPTY;
            SUPER_GOOD_JUJU = _EMPTY;
            UNDYING = _EMPTY;
            LONG_UNDYING = _EMPTY;
            LEVITATION = _EMPTY;
            LONG_LEVITATION = _EMPTY;
            SWAMP_ESSENCE = _EMPTY;
            STRONG_SWAMP_ESSENCE = _EMPTY;
            SUGAR_BOMBED = _EMPTY;
            SUGARRGH_BOMBED = _EMPTY;
            LONG_SUGAR_BOMBED = _EMPTY;
            VILLAGE_HEXED = _EMPTY;
            FOOD_POISONING = VfpPotions.newInternalType("food_poisoning", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_hunger, (int)60, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_nausea, (int)60, (int)0));
        } else {
            FOOD_POISONING = VfpPotions.newType("food_poisoning", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_hunger, (int)60, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_nausea, (int)60, (int)0));
            STRONG_STIMULANT = VfpPotions.newType("strong_stimulant", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_poison, (int)10, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_moveSpeed, (int)180, (int)3));
            WATER_NATIVE = VfpPotions.newType("water_native", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_nightVision, (int)180, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_waterBreathing, (int)180, (int)0));
            LONG_WATER_NATIVE = VfpPotions.newType("long_water_native", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_nightVision, (int)480, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_waterBreathing, (int)480, (int)0));
            STRONG_WATER_NATIVE = VfpPotions.newType("strong_water_native", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_conduitPower, (int)300, (int)0));
            WOLF_SPIRIT = VfpPotions.newType("wolfspirit", Potions.newHiddenPotionTypeEffect((Effect)SharedGlue.Potion_nightVision, (int)180, (int)0), Potions.newHiddenPotionTypeEffect((Effect)SharedGlue.Potion_invisibility, (int)180, (int)0), Potions.newHiddenPotionTypeEffect((Effect)SharedGlue.Potion_moveSpeed, (int)180, (int)1), Potions.newHiddenPotionTypeEffect((Effect)SharedGlue.Potion_jump, (int)180, (int)1), Potions.newHiddenPotionTypeEffect((Effect)SharedGlue.Potion_healthBoost, (int)180, (int)0));
            SUPER_WOLF_SPIRIT = VfpPotions.newType("super_wolfspirit", Potions.newHiddenPotionTypeEffect((Effect)SharedGlue.Potion_nightVision, (int)480, (int)0), Potions.newHiddenPotionTypeEffect((Effect)SharedGlue.Potion_invisibility, (int)480, (int)0), Potions.newHiddenPotionTypeEffect((Effect)SharedGlue.Potion_moveSpeed, (int)480, (int)3), Potions.newHiddenPotionTypeEffect((Effect)SharedGlue.Potion_jump, (int)480, (int)4), Potions.newHiddenPotionTypeEffect((Effect)SharedGlue.Potion_healthBoost, (int)480, (int)1));
            BEAR_SPIRIT = VfpPotions.newType("bearspirit", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_nightVision, (int)240, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_moveSpeed, (int)240, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_strength, (int)240, (int)2), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_absorption, (int)240, (int)1), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_resistance, (int)240, (int)0));
            SUPER_BEAR_SPIRIT = VfpPotions.newType("super_bearspirit", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_nightVision, (int)600, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_moveSpeed, (int)600, (int)1), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_strength, (int)600, (int)2), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_absorption, (int)600, (int)1), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_resistance, (int)600, (int)1));
            BADD_JUJU = VfpPotions.newType("badd_juju", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_badLuck, (int)300, (int)0));
            SUPER_GOOD_JUJU = VfpPotions.newType("super_good_juju", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_luck, (int)480, (int)1));
            VILLAGE_HEXED = VfpPotions.newType("village_hexx", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_badOmen, (int)1200, (int)0));
            UNDYING = VfpPotions.newType("undying", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_resistance, (int)120, (int)4), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_luck, (int)240, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_glowing, (int)120, (int)0));
            LONG_UNDYING = VfpPotions.newType("long_undying", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_resistance, (int)240, (int)4), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_luck, (int)240, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_glowing, (int)240, (int)0));
            LEVITATION = VfpPotions.newType("levitation", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_levitation, (int)90, (int)0));
            LONG_LEVITATION = VfpPotions.newType("long_levitation", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_levitation, (int)240, (int)0));
            SWAMP_ESSENCE = VfpPotions.newType("swamp_essence", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_glowing, (int)90, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_levitation, (int)90, (int)0));
            STRONG_SWAMP_ESSENCE = VfpPotions.newType("strong_swamp_essence", Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_glowing, (int)90, (int)0), Potions.newPotionTypeEffect((Effect)SharedGlue.Potion_levitation, (int)90, (int)2));
            _typeToColorMap.put(FOOD_POISONING, 11510092);
            _typeToColorMap.put(STRONG_STIMULANT, 8171445);
            _typeToColorMap.put(WOLF_SPIRIT, 8344618);
            _typeToColorMap.put(SUPER_WOLF_SPIRIT, 8273408);
            _typeToColorMap.put(WATER_NATIVE, 50898);
            _typeToColorMap.put(LONG_WATER_NATIVE, 42186);
            _typeToColorMap.put(STRONG_WATER_NATIVE, 42186);
            _typeToColorMap.put(BEAR_SPIRIT, 9970776);
            _typeToColorMap.put(SUPER_BEAR_SPIRIT, 9970243);
            _typeToColorMap.put(BADD_JUJU, 0x755455);
            _typeToColorMap.put(SUPER_GOOD_JUJU, 59904);
            _typeToColorMap.put(UNDYING, 0xFFF000);
            _typeToColorMap.put(LONG_UNDYING, 16766976);
            _typeToColorMap.put(SWAMP_ESSENCE, 11653040);
            _typeToColorMap.put(STRONG_SWAMP_ESSENCE, 12576727);
        }
    }

    public static final void initDependentPotions(VfpConfig config) {
        Effect effect = AttentivenessEffect.get();
        VIGOR = VfpPotions.newInternalType("vigor", Potions.newPotionTypeEffect((Effect)effect, (int)120, (int)0));
        LONG_VIGOR = VfpPotions.newInternalType("strong_vigor", Potions.newPotionTypeEffect((Effect)effect, (int)240, (int)0));
        if (config.includePotionBrewing()) {
            effect = EnergizedEffect.get();
            SUGAR_BOMBED = VfpPotions.newType("sugar_bombed", Potions.newPotionTypeEffect((Effect)effect, (int)180, (int)0));
            SUGARRGH_BOMBED = VfpPotions.newType("strong_sugar_bombed", Potions.newPotionTypeEffect((Effect)effect, (int)240, (int)1));
            LONG_SUGAR_BOMBED = VfpPotions.newType("long_sugar_bombed", Potions.newPotionTypeEffect((Effect)effect, (int)480, (int)0));
            _typeToColorMap.put(SUGAR_BOMBED, 8171400);
            _typeToColorMap.put(LONG_SUGAR_BOMBED, 8171400);
            _typeToColorMap.put(SUGARRGH_BOMBED, 8171400);
        }
    }

    public static final void initFinal(VfpConfig config) {
        if (WellnessHelper.isEnabled()) {
            WellnessHelper.initFoodManagement((Effect)FOOD_WARMING, (Effect)FOOD_COOLING, null, null);
        }
    }

    static {
        _typeToColorMap = new HashMap();
    }

    public static final class EventsHandler {
        private EventsHandler() {
        }

        @Nonnull
        public static final EventsHandler init(VfpConfig config) {
            return new EventsHandler();
        }

        @SubscribeEvent
        public void onBrewed(PotionBrewEvent.Post event) {
            BrewEffect.onBrewedSwitchColor((PotionBrewEvent.Post)event, _typeToColorMap);
        }
    }
}

