/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BeehiveBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.jwaresoftware.mcmods.lib.Fluids;
import org.jwaresoftware.mcmods.lib.IniRegistries;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.IModBlock;
import org.jwaresoftware.mcmods.lib.api.IMultiColored;
import org.jwaresoftware.mcmods.lib.api.IRegistriesLoadedListener;
import org.jwaresoftware.mcmods.lib.capability.QualityGrade;
import org.jwaresoftware.mcmods.lib.impl.fluid.UniversalHolderOfFluids;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public final class VfpUtils {
    public static final ItemGroup[] EMPTY_TABS_ARRAY = new ItemGroup[0];
    private static ItemGroup _tabToRuleThemAllInstance;
    private static final LinkedList<Item> _itemsWithColors;
    private static final LinkedList<IRegistriesLoadedListener> _brewingParticipants;
    public static final IntegerProperty BEEHIVE_LEVEL;

    public static void setVfpTabOverride(ItemGroup tab) {
        _tabToRuleThemAllInstance = tab;
    }

    public static final List<ItemGroup> getTabs(VfpProfile profile, VfpVariant variant, ItemGroup ... requiredTabs) {
        ArrayList<ItemGroup> tabs = new ArrayList<ItemGroup>();
        if (profile.isVFP() && _tabToRuleThemAllInstance != null) {
            tabs.add(_tabToRuleThemAllInstance);
        } else {
            ItemGroup tab;
            if (requiredTabs != null) {
                for (ItemGroup tab2 : requiredTabs) {
                    if (tab2 == null || tabs.contains(tab2)) continue;
                    tabs.add(tab2);
                }
            }
            if ((tab = variant.tab()) != null && !tabs.contains(tab)) {
                tabs.add(tab);
            }
        }
        return tabs;
    }

    @Nonnull
    public static final ItemGroup bestTab(VfpProfile profile, @Nullable ItemGroup tab) {
        if (profile.isVFP() && VfpUtils.preferredTab() != null) {
            tab = VfpUtils.preferredTab();
        }
        if (tab == null) {
            tab = profile.isItem() ? SharedGlue.CreativeTabs_misc : (profile.isDense() ? SharedGlue.CreativeTabs_block : SharedGlue.CreativeTabs_misc);
            if (profile.isEdible() && !profile.isHarmfulIfEatenDirectly()) {
                tab = SharedGlue.CreativeTabs_food;
            }
        }
        return tab;
    }

    @Nonnull
    public static final ItemGroup bestTab(VfpProfile profile) {
        return VfpUtils.bestTab(profile, (ItemGroup)null);
    }

    @Nullable
    public static final ItemGroup bestTab(@Nullable ItemGroup tab, @Nullable ItemGroup defaultTab) {
        if (VfpUtils.preferredTab() != null) {
            tab = VfpUtils.preferredTab();
        } else if (tab == null) {
            tab = defaultTab;
        }
        return tab;
    }

    @Nullable
    public static final ItemGroup bestTab(@Nullable ItemGroup defaultTab) {
        return VfpUtils.bestTab((ItemGroup)null, defaultTab);
    }

    public static final ItemGroup preferredTab() {
        return _tabToRuleThemAllInstance;
    }

    public static Item.Properties newproperties(@Nullable ItemGroup tab) {
        return new Item.Properties().func_200916_a(VfpUtils.bestTab(tab));
    }

    public static final <T> T autoregisterItem(Item item, VfpProfile oid) {
        if (oid.isVFP()) {
            VfpObj.itemInstances.add(item);
            if (item instanceof IMultiColored) {
                _itemsWithColors.add(item);
            }
            if (item instanceof IRegistriesLoadedListener) {
                _brewingParticipants.add((IRegistriesLoadedListener)item);
            }
        }
        return (T)IniRegistries.autoregisterItem((String)oid.modid(), (Item)item, (String)oid.fmlid());
    }

    public static final Block autoregisterBlock(Block blok, VfpProfile oid, @Nullable Item.Properties ip) {
        return IniRegistries.autoregisterBlock((String)oid.modid(), (Block)blok, (String)oid.fmlid(), (Item.Properties)ip);
    }

    public static final Block autoregisterBlock(Block blok, VfpProfile oid) {
        Item.Properties ip = null;
        if (blok instanceof IModBlock) {
            if (!((IModBlock)blok).hasNoItemForm()) {
                ip = oid.isVFP() ? VfpUtils.newproperties(SharedGlue.CreativeTabs_misc) : new Item.Properties().func_200916_a(SharedGlue.CreativeTabs_block);
            }
        } else {
            ip = oid.isVFP() ? VfpUtils.newproperties(SharedGlue.CreativeTabs_misc) : new Item.Properties().func_200916_a(SharedGlue.CreativeTabs_block);
        }
        return VfpUtils.autoregisterBlock(blok, oid, ip);
    }

    public static final List<Item> getItemsWithColor() {
        List pending = (List)_itemsWithColors.clone();
        _itemsWithColors.clear();
        return pending;
    }

    public static final List<IRegistriesLoadedListener> getBrewingParticipants() {
        List pending = (List)_brewingParticipants.clone();
        _brewingParticipants.clear();
        return pending;
    }

    public static final int countDrops(List<ItemStack> drops, boolean first, Item ... items) {
        int n = 0;
        for (ItemStack drop : drops) {
            if (drop.func_190926_b()) continue;
            for (Item item : items) {
                if (drop.func_77973_b() != item) continue;
                ++n;
                if (!first) continue;
                return n;
            }
        }
        return n;
    }

    public static final boolean isGoldGrade(ItemStack stack) {
        return QualityGrade.isGoldOrBetter((ItemStack)stack);
    }

    public static final boolean isTypeOfSimpleEmptyContainer(@Nullable Item item) {
        return item == Items.field_151133_ar || item == Items.field_151054_z || item == Items.field_151069_bo || item == VfpObj.Empty_Bucket_Jar_obj || item == VfpObj.Empty_Carton_obj || item == VfpObj.Empty_Jar_obj || item == VfpObj.Empty_Paper_Bag_obj || item == VfpObj.Our_Empty_Bottle_obj || item == VfpObj.Small_Empty_Jar_obj || item == VfpObj.Dark_Empty_Jar_obj;
    }

    public static final boolean isTypeOfUniversalEmptyFluidContainer(ItemStack stack) {
        Item item = stack.func_190926_b() ? null : stack.func_77973_b();
        return item instanceof UniversalHolderOfFluids && Fluids.isNone((FluidStack)((UniversalHolderOfFluids)item).getFluid(stack));
    }

    public static final boolean isFullBeehive(BlockState hit, boolean strict) {
        return hit.func_235714_a_((ITag)BlockTags.field_226151_aa_) && hit.func_235901_b_((Property)BEEHIVE_LEVEL) && (Integer)hit.func_177229_b((Property)BEEHIVE_LEVEL) >= 5 && (!strict || hit.func_177230_c() instanceof BeehiveBlock);
    }

    public static final boolean harvestBeehive(World world, BlockState hit, BlockPos hitpos, boolean strict) {
        boolean full = VfpUtils.isFullBeehive(hit, strict);
        if (full && strict) {
            ((BeehiveBlock)hit.func_177230_c()).func_226876_a_(world, hit, hitpos);
        }
        return full;
    }

    private VfpUtils() {
    }

    static {
        _itemsWithColors = new LinkedList();
        _brewingParticipants = new LinkedList();
        BEEHIVE_LEVEL = BlockStateProperties.field_227036_ao_;
    }
}

