/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpTransientVariant;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;

public interface VfpVariantSet<T extends VfpVariant> {
    public String getName();

    public Collection<T> getAllowedValues();

    public Class<T> getValueClass();

    public String getName(Comparable var1);

    public Optional<T> parseValue(String var1);

    public String typeName();

    public VfpVariant register(int var1, VfpVariant var2);

    public VfpVariant lookup(int var1);

    public boolean isOneOf(ItemStack var1, Object var2);

    public int size();

    public VfpVariant[] variants();

    public Object markerObject();

    public static class ByMapInstanceVType
    extends ByMapInstance {
        public ByMapInstanceVType(VfpProfile typedef, Class<?> marker, String typename) {
            super(typedef, marker, typename);
        }

        @Override
        public Class getValueClass() {
            return VfpVariant.class;
        }
    }

    public static abstract class ByMapInstance
    extends ByMap {
        protected VfpProfile _profile;
        protected final Class<?> _markerObject;

        protected ByMapInstance(VfpProfile typedef, Class<?> marker, String typename) {
            super(typename);
            Validate.notNull(marker, (String)"A non-null marker class (usually multi-x class) is required", (Object[])new Object[0]);
            this._profile = typedef;
            this._markerObject = marker;
        }

        @Override
        public String typeName() {
            return this._profile.fmlid();
        }

        @Override
        public Object markerObject() {
            return this._markerObject;
        }

        @Override
        public boolean isOneOf(ItemStack stack, Object markerObject) {
            return markerObject == this._markerObject || !ItemStacks.isEmpty((ItemStack)stack) && this._markerObject.isInstance(stack.func_77973_b());
        }

        public Class getValueClass() {
            return VfpTransientVariant.class;
        }

        @Override
        protected VfpVariant[] declaredVariants() {
            ArrayList list = new ArrayList(this.values());
            Collections.sort(list);
            return list.toArray(VfpVariant.EMPTY_ARRAY);
        }
    }

    public static abstract class ByMap
    extends HashMap<Integer, VfpVariant>
    implements VfpVariantSet {
        private Map<Integer, VfpVariant> _readonlyView = Collections.unmodifiableMap(this);
        private String _propertyName;
        private Map<String, VfpVariant> _nameToValues = Collections.EMPTY_MAP;

        protected abstract VfpVariant[] declaredVariants();

        protected ByMap() {
        }

        protected ByMap(String propertyName) {
            this._propertyName = propertyName;
        }

        @Override
        public final VfpVariant[] variants() {
            VfpVariant[] enumset = this.declaredVariants();
            VfpVariant[] out = new VfpVariant[enumset.length];
            for (int i = 0; i < enumset.length; ++i) {
                out[i] = enumset[i];
            }
            return out;
        }

        @Override
        public final VfpVariant register(int meta, VfpVariant instance) {
            return this.put(meta, instance);
        }

        @Override
        public final VfpVariant lookup(int meta) {
            return (VfpVariant)this.get(meta);
        }

        @Override
        public String getName() {
            return this._propertyName != null ? this._propertyName : this.typeName();
        }

        public Collection<VfpVariant> getAllowedValues() {
            return this._readonlyView.values();
        }

        public Class<VfpVariant> getValueClass() {
            return VfpVariant.class;
        }

        @Override
        public String getName(Comparable value) {
            return value instanceof VfpVariant ? ((VfpVariant)value).func_176610_l() : "";
        }

        @Override
        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (o.getClass() == this.getClass()) {
                ByMap other = (ByMap)ByMap.class.cast(o);
                return this.getValueClass().equals(other.getValueClass()) && this.getName().equals(other.getName());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return 31 * this.getValueClass().hashCode() + this.getName().hashCode();
        }

        @Nonnull
        protected Map<String, VfpVariant> declaredVariantNames() {
            if (this._nameToValues == Collections.EMPTY_MAP) {
                VfpVariant[] enumset = this.declaredVariants();
                this._nameToValues = new HashMap<String, VfpVariant>();
                for (int i = 0; i < enumset.length; ++i) {
                    this._nameToValues.put(enumset[i].func_176610_l(), enumset[i]);
                }
            }
            return this._nameToValues;
        }

        public Optional<VfpVariant> parseValue(String value) {
            return Optional.ofNullable(this.declaredVariantNames().get(value));
        }
    }
}

