/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.meats;

import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.BrewEffect;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.vfp.common.VfpBrewingItem;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public final class SonarGland
extends VfpBrewingItem {
    private static final int _MAX_STACKSIZE = SharedGlue.VANILLA_MAX_STACK_SIZE();
    private static final int _MAX_USES = 2;
    private static final int _2MINS = 120;

    public SonarGland(boolean brewingEnabled) {
        super((VfpProfile)VfpOid.Bat_Sonar_Sac, (BrewEffect)(brewingEnabled ? BrewEffect.goldenCarrotEffectII : null), SharedGlue.CreativeTabs_misc);
        this.setMaxDamage(2);
        this.inGroup("mobdrops");
        this.autoregister();
    }

    public final int getItemStackLimit(ItemStack gland) {
        return gland.func_77952_i() > 0 ? 1 : _MAX_STACKSIZE;
    }

    public final int getMaxDamage(ItemStack gland) {
        return 2;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ActionResultType result = ActionResultType.PASS;
        ItemStack gland = player.func_184586_b(hand);
        if (gland.func_77973_b() != this || gland.func_190916_E() > 1) {
            result = ActionResultType.FAIL;
        } else if (!player.func_70644_a(VfpPotions.BAT_SIGHTED) || player.func_70660_b(VfpPotions.BAT_SIGHTED).func_76459_b() <= 5) {
            if (SharedGlue.isaClientWorld((IWorldReader)world)) {
                Effects.playSoundFor((World)world, (PlayerEntity)player, (SoundEvent)SoundEvents.field_193789_dh, (float)6.0f, (float)1.0f);
            } else if (Potions.addPotionEffect((LivingEntity)player, (Effect)VfpPotions.BAT_SIGHTED, (int)120, (int)0, (boolean)false, (boolean)false)) {
                Potions.CureProfiles.applyAll((LivingEntity)player, (Map)Potions.CureProfiles.UNCONDITIONALLY, (String[])new String[]{"blindness"});
                int uses = gland.func_77952_i() + 1;
                ItemSupport.noteItemNewDurability((LivingEntity)player, (ItemStack)gland, (int)uses);
                if (SharedGlue.getPlayerInSurvival((PlayerEntity)player)) {
                    if (uses == 1) {
                        ItemStacks.stampUnique((ItemStack)gland, (String)"ECHO");
                    }
                    gland.func_196085_b(uses);
                    if (uses >= gland.func_77958_k()) {
                        gland.func_190918_g(1);
                    }
                }
                this.addUsedStat(player);
                result = ActionResultType.SUCCESS;
            } else {
                Effects.playUseItemFailedSoundFromServer((World)world, (PlayerEntity)player);
                result = ActionResultType.FAIL;
            }
        }
        return new ActionResult(result, (Object)gland);
    }
}

