/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ICurative;
import org.jwaresoftware.mcmods.lib.api.IEssential;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidNonFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public final class BowlOfMilk
extends VfpLiquidNonFood
implements IEssential,
ICurative {
    private final boolean _hasBowl;
    private final boolean _honeyFlag;
    private final LikeFood _stats;

    private BowlOfMilk(VfpOid oid, boolean honey, boolean bowl, LikeFood stats) {
        super((VfpProfile)oid, honey ? LiquidType.HONEY : LiquidType.MILK);
        this._hasBowl = bowl;
        this._stats = stats;
        this._honeyFlag = honey;
        this.finishInit();
        this.autoregister();
    }

    public static final BowlOfMilk plain() {
        return new BowlOfMilk(VfpOid.Bowl_Milk, false, true, LikeFood.milk);
    }

    public static final BowlOfMilk honeymilk() {
        return new BowlOfMilk(VfpOid.Bowl_Honeymilk, true, false, LikeFood.honey_milk);
    }

    public static final BowlOfMilk honey() {
        return new BowlOfMilk(VfpOid.Bowl_Honey, true, true, LikeFood.honey_bottle);
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxSoupsStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected Item getNewEmptyContainer() {
        return this._hasBowl ? Items.field_151054_z : Items.field_190931_a;
    }

    @Override
    protected int getRegularItemUseDuration() {
        return this._hasBowl ? SharedGlue.SHORT_FOOD_CONSUME_DURATION() : SharedGlue.DEFAULT_FOOD_CONSUME_DURATION();
    }

    private boolean honeyOnly() {
        return this._honeyFlag && this._hasBowl;
    }

    public float getNNSaturationModifier() {
        return this._stats.saturationModifier();
    }

    public float getNNHealAmount() {
        return this._stats.healAmount();
    }

    public boolean onCureDirectly(PlayerEntity player, ItemStack milk) {
        ItemStack remaining = ItemStacks.copysplit((ItemStack)milk);
        this.onDrinkDrunk(milk, remaining, player.func_130014_f_(), player);
        return true;
    }

    @Override
    protected void applyPotionEffectsOnDrunk(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        if (!this.honeyOnly()) {
            Potions.addMilkBoostRegenEffect((LivingEntity)player);
        }
        super.applyPotionEffectsOnDrunk(original, remaining, world, player);
    }

    @Override
    protected void onDrinkDrunk(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            if (this.honeyOnly()) {
                Potions.cureBadPotionEffectsWithHoney((LivingEntity)player, (boolean)true, (boolean)false);
            } else {
                Potions.cureBadPotionEffectsWithMilk((LivingEntity)player, (boolean)this._honeyFlag, (boolean)this._honeyFlag, (boolean)false);
            }
        }
        player.func_71024_bL().func_75122_a(this._stats.healAmount(), this._stats.saturationModifier());
        super.onDrinkDrunk(original, remaining, world, player);
    }
}

