/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Tooltips;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.lib.impl.client.TemperatureItemProperty;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;

public final class CreamSoup
extends VfpLiquidMultiItem
implements IVariant,
IReheatable,
IItemPropertyExtender {
    private static final int CREAM_SOUP_COLOR = 16775636;
    private static final List<Ingredient> VARIANT_FLAVORS = new ArrayList<Ingredient>(23);
    private static CreamSoup[] INSTANCES;

    public static final synchronized boolean register(Ingredient flavor) {
        return CreamSoup.register(flavor, VARIANT_FLAVORS, "cream soups");
    }

    public static final synchronized boolean register(FoodPowder.Type flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null food powder is required for cream soups", (Object[])new Object[0]);
        String name = flavor.name_lowercased();
        return CreamSoup.register(FoodPowder.toIngredient(flavor, FoodPowder.Usage.SOUP_FLAVOR, name), VARIANT_FLAVORS, "cream soups");
    }

    CreamSoup(VfpVariant variant) {
        super((VfpProfile)VfpOid.CreamSoup, variant, LiquidType.SOUP);
        Potions.addMilkBasedRegenEffect((Item)this);
        this.setAlwaysEdible();
        this.autoregister();
    }

    public String oid() {
        return VfpOid.CreamSoup.fmlid();
    }

    @Override
    protected Item getNewEmptyContainer() {
        return Items.field_151054_z;
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxSoupsStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected Integer getColorFromIngredient(Ingredient ingredient, int renderPass) {
        Integer colorValue = super.getColorFromIngredient(ingredient, renderPass);
        if (colorValue == null) {
            colorValue = 16775636;
        }
        return colorValue;
    }

    @Nonnull
    private Ingredient ingredientFrom() {
        return this._variant.datadata(Ingredient.class);
    }

    public boolean canPlayerHeat(ItemStack stack) {
        return true;
    }

    @Override
    protected void onFoodEaten(ItemStack eaten, ItemStack remaining, World world, PlayerEntity player) {
        if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            Potions.CureProfiles.applyForMilk((LivingEntity)player);
        }
        super.onFoodEaten(eaten, remaining, world, player);
    }

    @Override
    public float getSaturationModifier(ItemStack soup) {
        float baseAmount = super.getSaturationModifier(soup);
        return this.computeSaturationModifierForWarmedFood(soup, baseAmount, 1.5f, false);
    }

    @Override
    public void onCookedOrCrafted(ItemStack soup) {
        ITemperatureChangeable.UsedEffect e = this.onCreateCheckBonusTemperature(soup);
        super.onCookedOrCrafted(soup);
        if (ITemperatureChangeable.UsedEffect.HEATED.equals((Object)e)) {
            this.setHeated(soup);
        }
    }

    @Override
    public void func_77622_d(ItemStack soup, @Nullable World world, @Nullable PlayerEntity player) {
        super.func_77622_d(soup, world, player);
        if (this.isHeated(soup) && player != null) {
            player.func_195066_a(VfpObj.Heated_Food_stat);
        }
    }

    public void func_77663_a(ItemStack soup, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(soup, world, holder, slotindex, selected);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerPropertyOverrides() {
        TemperatureItemProperty.addHeatable((Item)this);
    }

    public String varid() {
        return this.getVariant().fmlid();
    }

    public List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(INSTANCES.length + 2);
        for (int i = 0; i < INSTANCES.length; ++i) {
            all.add(ItemStacks.create((Item)INSTANCES[i]));
        }
        return all;
    }

    @Override
    public boolean isHiddenByDefault() {
        return VfpConfig.getInstance().showAllItemsInUI() ? false : !this.ingredientFrom().isEnabled();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack soup, World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        if (this.isShowingUiTips(soup) && !soup.func_77942_o()) {
            String summary = "tooltip_summ.item.vfp.creamsoup";
            Tooltips.addDocTipSharedSummary((ItemStack)soup, tooltip, (String)summary);
            this.addDebugInformation(soup, tooltip, flags);
        } else {
            super.func_77624_a(soup, world, tooltip, flags);
        }
    }

    static final void makeObjects() {
        if (INSTANCES == null && !VARIANT_FLAVORS.isEmpty()) {
            int N = VARIANT_FLAVORS.size();
            INSTANCES = new CreamSoup[N];
            for (int i = 0; i < N; ++i) {
                Ingredient ingredient = VARIANT_FLAVORS.get(i);
                String rid = VfpOid.CreamSoup.fmlid() + "_" + ingredient.name();
                CreamSoup.INSTANCES[i] = new CreamSoup(new VfpVariant(i, rid, LikeFood.cream_soup, ingredient, null));
            }
        }
    }

    static final void setRecipeRewards() {
        if (INSTANCES != null) {
            for (int i = 0; i < INSTANCES.length; ++i) {
                ItemStack a_cream_soup = new ItemStack((IItemProvider)INSTANCES[i]);
                REHEATABLES.add(a_cream_soup.func_77946_l());
                VfpRewards.addRewardingCraftItem(a_cream_soup, LikeFood.cream_soup.craftExperience());
            }
        }
    }
}

