/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.api.ICurative;
import org.jwaresoftware.mcmods.lib.api.IEssential;
import org.jwaresoftware.mcmods.lib.api.ITiny;
import org.jwaresoftware.mcmods.lib.api.NutritionNote;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPantryItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;

public final class MilkPortion
extends VfpPantryItem
implements IEssential,
ICurative,
ITiny {
    private final boolean _vegan;

    MilkPortion(VfpProfile profile, boolean vegan) {
        super(profile, LikeFood.water, null);
        this.setAlwaysEdible();
        this.setHiddenByDefault(vegan);
        Potions.addMilkBasedRegenEffect((Item)this, (int)this.getPotionEffectDurationSecs(true), (int)1);
        this._vegan = vegan;
        this.autoregister();
    }

    public static final MilkPortion regular() {
        return new MilkPortion(VfpOid.Portion_Milk, false);
    }

    public static final MilkPortion vegan() {
        return new MilkPortion(VfpOid.Portion_Milk_Vegan, true);
    }

    public boolean onCureDirectly(PlayerEntity player, ItemStack milk) {
        ItemStack remaining = ItemStacks.copysplit((ItemStack)milk);
        this.onFoodEaten(milk, remaining, player.func_130014_f_(), player);
        return true;
    }

    @Override
    protected int getPotionEffectDurationSecs(boolean good) {
        return good ? 3 : super.getPotionEffectDurationSecs(good);
    }

    public long getNNCheckList(ItemStack milk) {
        return this._vegan ? NutritionNote.VEGAN.bit() : 0L;
    }
}

