/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.milk;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.Validate;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.LiquidType;
import org.jwaresoftware.mcmods.lib.Potions;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.ICurative;
import org.jwaresoftware.mcmods.lib.api.IEssential;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.api.IVariant;
import org.jwaresoftware.mcmods.lib.capability.ITemperatureChangeable;
import org.jwaresoftware.mcmods.lib.impl.client.TemperatureItemProperty;
import org.jwaresoftware.mcmods.vfp.agents.FoodPowder;
import org.jwaresoftware.mcmods.vfp.common.IReheatable;
import org.jwaresoftware.mcmods.vfp.common.Ingredient;
import org.jwaresoftware.mcmods.vfp.common.LikeFood;
import org.jwaresoftware.mcmods.vfp.common.VfpCapacity;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpLiquidMultiItem;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPotions;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpVariant;
import org.jwaresoftware.mcmods.vfp.runtime.VfpRewards;

public final class TeaDrink
extends VfpLiquidMultiItem
implements IVariant,
IReheatable,
IEssential,
ICurative,
IItemPropertyExtender {
    private static final int GENERIC_TEADRINK_COLOR = 6585650;
    private static int _BUSH_TEA = -1;
    private static final List<Ingredient> VARIANT_FLAVORS = new ArrayList<Ingredient>(13);
    private static final Map<Ingredient, Integer> VARIANT_COLORS = new Hashtable<Ingredient, Integer>();
    private static TeaDrink[] INSTANCES;
    private static final Map<String, Boolean> _SIMPLE_TEA;
    private static final Map<String, Boolean> _COMBAT_TEA;

    public static final synchronized boolean register(Ingredient flavor, int colorValue) {
        boolean registered = TeaDrink.register(flavor, VARIANT_FLAVORS, "tea drinks");
        if (registered && colorValue > 0) {
            VARIANT_COLORS.put(flavor, colorValue);
        }
        return registered;
    }

    public static final synchronized boolean register(FoodPowder.Type flavor) {
        Validate.notNull((Object)flavor, (String)"A non-null flavor is required for a tea drink", (Object[])new Object[0]);
        String name = flavor.name_lowercased();
        return TeaDrink.register(FoodPowder.toIngredient(flavor, FoodPowder.Usage.DRINK_FLAVOR, name), -1);
    }

    TeaDrink(VfpVariant variant) {
        super((VfpProfile)VfpOid.TeaDrink, variant, LiquidType.TEA);
        this.autoregister();
    }

    public String oid() {
        return VfpOid.TeaDrink.fmlid();
    }

    @Override
    protected Item getNewEmptyContainer() {
        return VfpObj.Our_Empty_Bottle_obj;
    }

    @Override
    protected VfpCapacity getItemMaxStackSize() {
        return VfpConfig.getInstance().maxDrinksStackCapacity(super.getItemMaxStackSize());
    }

    @Override
    protected Integer getColorFromIngredient(Ingredient ingredient, int renderPass) {
        Integer colorValue = VARIANT_COLORS.get(ingredient);
        if (colorValue == null && (colorValue = super.getColorFromIngredient(ingredient, renderPass)) == null) {
            colorValue = 6585650;
        }
        return colorValue;
    }

    public String varid() {
        return this.getVariant().fmlid();
    }

    public List<ItemStack> copyOfAllVariantMembers() {
        ArrayList<ItemStack> all = new ArrayList<ItemStack>(INSTANCES.length + 2);
        for (int i = 0; i < INSTANCES.length; ++i) {
            all.add(new ItemStack((IItemProvider)INSTANCES[i]));
        }
        return all;
    }

    @Nonnull
    private final Ingredient ingredientFrom() {
        return this._variant.datadata(Ingredient.class);
    }

    private static boolean isMilky(Ingredient ingredient) {
        return ingredient.name().contains("milky");
    }

    private static boolean isConifer(Ingredient ingredient) {
        return ingredient.name().contains("spruce");
    }

    private static boolean isCurative(Ingredient ingredient) {
        return TeaDrink.isMilky(ingredient) || TeaDrink.isConifer(ingredient);
    }

    private boolean isCurative(ItemStack stack) {
        return TeaDrink.isCurative(this.ingredientFrom());
    }

    public boolean isCureAvailable(@Nonnull PlayerEntity player, ItemStack drink) {
        return this.canConsume(drink, player.func_130014_f_(), player);
    }

    public boolean onCureDirectly(PlayerEntity player, ItemStack drink) {
        ItemStack remaining = ItemStacks.copysplit((ItemStack)drink);
        this.onFoodEaten(drink, remaining, player.func_130014_f_(), player);
        return true;
    }

    @Override
    protected boolean canConsume(ItemStack drink, World world, PlayerEntity player) {
        return this.isCurative(drink) || super.canConsume(drink, world, player);
    }

    @Override
    protected void onFoodEaten(ItemStack eaten, ItemStack remaining, World world, PlayerEntity player) {
        if (SharedGlue.isaServerWorld((IWorldReader)world) && this.isCurative(eaten)) {
            boolean combatant = TeaDrink.isConifer(this.ingredientFrom());
            Potions.CureProfiles.applyForMilk((LivingEntity)player, combatant ? _COMBAT_TEA : _SIMPLE_TEA);
        }
        super.onFoodEaten(eaten, remaining, world, player);
    }

    @Override
    protected void applyPotionEffectsOnConsumed(ItemStack original, ItemStack remaining, World world, PlayerEntity player) {
        super.applyPotionEffectsOnConsumed(original, remaining, world, player);
        if (this.isHeated(original) && !VfpConfig.manageTemperature() && !this.isRejuvenating(original)) {
            Potion what = VfpPotions.VIGOR;
            Ingredient ingredient = ((TeaDrink)original.func_77973_b()).ingredientFrom();
            if (TeaDrink.isMilky(ingredient)) {
                what = VfpPotions.LONG_VIGOR;
            }
            Potions.addPotionEffects((LivingEntity)player, (Potion)what);
        }
    }

    @Override
    public float getSaturationModifier(ItemStack drink) {
        float baseAmount = super.getSaturationModifier(drink);
        return this.computeSaturationModifierForWarmedFood(drink, baseAmount, 1.25f, true);
    }

    @Override
    public int getTemperatureModifier(ItemStack drink) {
        Ingredient ingredient = this.ingredientFrom();
        int change = 1;
        boolean warming = this.getTemperatureChangeCapability(drink).isHeated(drink);
        boolean milky = TeaDrink.isMilky(ingredient);
        if (warming && milky) {
            ++change;
        } else if (!warming && !milky) {
            ++change;
        }
        return change;
    }

    public int getCoolDuration(ItemStack drink) {
        return 480;
    }

    public int getBonusTemperatureTimeLeftForApply(ItemStack drink, int min) {
        if (this.getTemperatureModifier(drink) < 1) {
            return 0;
        }
        if (min <= 0) {
            min = 90;
        }
        return Math.max(min, this.getBonusTemperatureTimeLeft(drink));
    }

    public boolean canPlayerHeat(ItemStack stack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerPropertyOverrides() {
        TemperatureItemProperty.addBoth((Item)this);
    }

    @Override
    public void onCookedOrCrafted(ItemStack drink) {
        ITemperatureChangeable.UsedEffect e = ITemperatureChangeable.UsedEffect.UNCHANGED;
        if (this.getTemperatureModifier(drink) > 0) {
            e = this.onCreateCheckBonusTemperature(drink);
        }
        super.onCookedOrCrafted(drink);
        if (ITemperatureChangeable.UsedEffect.HEATED.equals((Object)e)) {
            this.setHeated(drink);
        } else if (ITemperatureChangeable.UsedEffect.COOLED.equals((Object)e)) {
            this.setCooled(drink);
        }
    }

    @Override
    public void func_77622_d(ItemStack drink, @Nullable World world, @Nullable PlayerEntity player) {
        super.func_77622_d(drink, world, player);
        if (this.isHeated(drink) && player != null) {
            player.func_195066_a(VfpObj.Heated_Food_stat);
        }
    }

    public void func_77663_a(ItemStack drink, World world, Entity holder, int slotindex, boolean selected) {
        this.onUpdateTickBonusTemperature(drink, world, holder, slotindex, selected);
    }

    static final void makeObjects() {
        if (INSTANCES == null && VARIANT_FLAVORS.size() > 0) {
            int N = VARIANT_FLAVORS.size();
            INSTANCES = new TeaDrink[N];
            for (int i = 0; i < N; ++i) {
                Ingredient ingredient = VARIANT_FLAVORS.get(i);
                String rid = VfpOid.TeaDrink.fmlid() + "_" + ingredient.name();
                boolean milky = TeaDrink.isMilky(ingredient);
                TeaDrink.INSTANCES[i] = new TeaDrink(new VfpVariant(i, rid, milky ? LikeFood.milky_bush_tea : LikeFood.bush_tea, ingredient, null));
                if (FoodPowder.findType(ingredient.name()) != FoodPowder.Type.BUSHTEA) continue;
                _BUSH_TEA = i;
            }
        }
    }

    static final void setRecipeRewards() {
        if (INSTANCES != null) {
            for (int i = 0; i < INSTANCES.length; ++i) {
                Ingredient ingredient = VARIANT_FLAVORS.get(i);
                ItemStack a_tea_drink = new ItemStack((IItemProvider)INSTANCES[i]);
                REHEATABLES.add(a_tea_drink.func_77946_l());
                if (TeaDrink.isConifer(ingredient)) {
                    VfpRewards.addRewardingCraftItem(a_tea_drink, VfpOid.TeaDrink.craftingXp());
                    continue;
                }
                VfpRewards.addRewardingCraftItem(a_tea_drink, LikeFood.bush_tea.craftExperience());
            }
        }
    }

    public static final ItemStack bush(int amount) {
        return _BUSH_TEA >= 0 ? new ItemStack((IItemProvider)INSTANCES[_BUSH_TEA]) : ItemStack.field_190927_a;
    }

    static {
        _SIMPLE_TEA = Potions.CureProfiles.newopts(m -> {
            m.put("forced", false);
            m.put("combatant", false);
            m.put("boosted", false);
        });
        _COMBAT_TEA = Potions.CureProfiles.newopts(m -> {
            m.put("forced", false);
            m.put("combatant", true);
            m.put("boosted", false);
        });
    }
}

