/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Stats;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBiomeReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.RID;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.api.NutritionNote;
import org.jwaresoftware.mcmods.lib.impl.ItemSupport;
import org.jwaresoftware.mcmods.lib.impl.item.NutritionProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpConfig;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;

public final class FluidSourceInteractionHandler {
    private static final int _UNKNOWN = -1;
    private static final int _BIT_MEASURE = 1;
    private static final int _MUSHROOM = 2;
    private static final int _KELP = 3;

    private int getWhatHeld(ItemStack held) {
        int type = -1;
        Item item = held.func_77973_b();
        if (!ItemStacks.isEmpty((ItemStack)held) && item != VfpObj.Fungi_Purged_obj && item != VfpObj.Washed_Kelp_obj) {
            if (item == VfpObj.Bit_Pipette_obj) {
                type = 1;
            } else if (RID.matches((ItemStack)held, (String)"foods/raw_mushrooms")) {
                type = 2;
            } else if (RID.matches((ItemStack)held, (String)"foods/raw_kelp")) {
                type = 3;
            }
        }
        return type;
    }

    @SubscribeEvent
    public void onRightClickFluidSource(PlayerInteractEvent.RightClickBlock event) {
        BlockPos blockpos;
        BlockState hit;
        RayTraceResult rtr;
        World world = event.getWorld();
        boolean ss = SharedGlue.isaServerWorld((IWorldReader)world);
        PlayerEntity player = event.getPlayer();
        boolean sneaking = SharedGlue.isEntitySneaking((Entity)player);
        ItemStack held = player.func_184586_b(event.getHand());
        int what = this.getWhatHeld(held);
        if (what != -1 && (rtr = ItemSupport.rayTraceFor((World)world, (PlayerEntity)player, (RayTraceContext.FluidMode)RayTraceContext.FluidMode.SOURCE_ONLY)).func_216346_c() == RayTraceResult.Type.BLOCK && (hit = world.func_180495_p(blockpos = ((BlockRayTraceResult)rtr).func_216350_a())).func_185904_a() == SharedGlue.Material_water) {
            ItemStack generated = null;
            if (!sneaking && what == 1 && !VfpConfig.getInstance().useTreatedWaterRecipes()) {
                generated = new ItemStack((IItemProvider)VfpObj.Water_Portion_obj);
                if (ss) {
                    player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)held.func_77973_b()));
                }
                if (player.field_71071_by.func_70441_a(generated.func_77946_l())) {
                    Effects.playBottleOfWaterScoopedUp((World)world, (PlayerEntity)player);
                } else {
                    generated = null;
                }
            } else if (sneaking && (what == 2 || what == 3)) {
                RegistryKey biome;
                if (VfpConfig.getInstance().useTreatedWaterRecipes() && (BiomeDictionary.hasType((RegistryKey)(biome = Locations.biomeKeyFor((IBiomeReader)world, (BlockPos)blockpos)), (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || BiomeDictionary.hasType((RegistryKey)biome, (BiomeDictionary.Type)BiomeDictionary.Type.BEACH))) {
                    return;
                }
                generated = new ItemStack((IItemProvider)(what == 3 ? VfpObj.Washed_Kelp_obj : VfpObj.Fungi_Purged_obj));
                NutritionProfile.applyIfAbsent((ItemStack)generated, (long)NutritionNote.VEGGIES.bit());
                if (!player.field_71071_by.func_70441_a(generated.func_77946_l())) {
                    player.func_71019_a(generated, false);
                }
                Effects.playBottleOfWaterScoopedUp((World)world, (PlayerEntity)player);
                if (SharedGlue.getPlayerInSurvival((PlayerEntity)player)) {
                    SharedGlue.consumeItemFromStack((PlayerEntity)player, (ItemStack)held, (Hand)event.getHand(), (boolean)false);
                }
            }
            if (generated != null) {
                ItemSupport.noteItemCraftedNontraditionalMeans((PlayerEntity)player, (World)world, generated);
                player.func_184609_a(event.getHand());
                SharedGlue.refreshPlayerHUD((PlayerEntity)player);
                event.setCanceled(true);
            }
        }
    }
}

