/*
 * Decompiled with CFR 0.152.
 */
package org.jwaresoftware.mcmods.vfp.misc;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemModelsProperties;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jwaresoftware.mcmods.lib.Effects;
import org.jwaresoftware.mcmods.lib.Instructions;
import org.jwaresoftware.mcmods.lib.ItemStacks;
import org.jwaresoftware.mcmods.lib.Locations;
import org.jwaresoftware.mcmods.lib.SharedGlue;
import org.jwaresoftware.mcmods.lib.Strings;
import org.jwaresoftware.mcmods.lib.advancements.AdvancementPredicate;
import org.jwaresoftware.mcmods.lib.api.IItemPropertyExtender;
import org.jwaresoftware.mcmods.lib.impl.Flag;
import org.jwaresoftware.mcmods.vfp.ModInfo;
import org.jwaresoftware.mcmods.vfp.VanillaFoodPantry;
import org.jwaresoftware.mcmods.vfp.common.VfpObj;
import org.jwaresoftware.mcmods.vfp.common.VfpOid;
import org.jwaresoftware.mcmods.vfp.common.VfpPlainItem;
import org.jwaresoftware.mcmods.vfp.common.VfpProfile;
import org.jwaresoftware.mcmods.vfp.common.VfpUtils;

public final class InkPearlMirror
extends VfpPlainItem
implements IItemPropertyExtender {
    private static final double _H_SHIFT = 0.5;
    private static final ResourceLocation NOMADS_SKY_ADVANCEMENT = ModInfo.r("mod/nomadsky");
    private final boolean _dimension_bound;
    private final boolean _use_bound;

    private InkPearlMirror(VfpProfile oid, boolean interdimensional, boolean reusable, boolean ultimate, @Nullable Item.Properties ip) {
        super(oid, true, ip);
        this._dimension_bound = !interdimensional;
        boolean bl = this._use_bound = !reusable;
        this._rarity = ultimate ? Rarity.EPIC : (interdimensional && reusable ? Rarity.RARE : (interdimensional ? Rarity.UNCOMMON : null));
        this.autoregister();
    }

    private InkPearlMirror(VfpProfile oid, boolean interdimensional, boolean reusable) {
        this(oid, interdimensional, reusable, false, null);
    }

    public static final void makeObjects() {
        VfpObj.Base_Ink_Pearl_Mirror_obj = new InkPearlMirror((VfpProfile)VfpOid.Lesser_Ink_Pearl_Mirror, false, false);
        new InkPearlMirror((VfpProfile)VfpOid.Ink_Pearl_Mirror, true, false);
        new InkPearlMirror((VfpProfile)VfpOid.Greater_Ink_Pearl_Mirror, true, true);
        new InkPearlMirror(VfpOid.Ultimate_Ink_Pearl_Mirror, true, true, true, VfpUtils.newproperties(VfpUtils.bestTab(VfpOid.Ultimate_Ink_Pearl_Mirror)).func_234689_a_());
    }

    public final int getItemStackLimit(ItemStack mirror) {
        return this._use_bound ? (this._dimension_bound ? 4 : 8) : 1;
    }

    @Override
    public void func_77622_d(ItemStack mirror, World world, PlayerEntity player) {
        super.func_77622_d(mirror, world, player);
        if (SharedGlue.isaRealPlayer((Entity)player)) {
            Instructions.setOwner((ItemStack)mirror, (PlayerEntity)player, (boolean)false);
        }
    }

    static final boolean isAlternate(ItemStack stack) {
        boolean is = false;
        if (!stack.func_190926_b() && stack.func_77973_b() instanceof InkPearlMirror) {
            InkPearlMirror mirror = (InkPearlMirror)stack.func_77973_b();
            is = !mirror._dimension_bound && !mirror._use_bound && ItemStacks.hasFlag((ItemStack)stack, (String)"alternate", (boolean)false);
        }
        return is;
    }

    private boolean canUse(World world, PlayerEntity player, ItemStack mirror) {
        return SharedGlue.isaRealPlayer((Entity)player) && Instructions.isOwnerOrUnowned((ItemStack)mirror, (Entity)player);
    }

    private boolean canFire(ServerPlayerEntity player, ItemStack mirror) {
        return this._use_bound ? true : !player.func_184811_cZ().func_185141_a(mirror.func_77973_b());
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ActionResultType result = ActionResultType.PASS;
        ItemStack mirror = player.func_184586_b(hand);
        if (mirror.func_77973_b() != this || !this.canUse(world, player, mirror)) {
            result = ActionResultType.FAIL;
            VanillaFoodPantry.runtime.sendPlayerMessage(player, true, (ITextComponent)new TranslationTextComponent(Strings.Templates.NotPermittedToUseItem));
        } else if (SharedGlue.isaServerWorld((IWorldReader)world)) {
            ServerPlayerEntity splayer = (ServerPlayerEntity)player;
            Flag used = Flag.of((boolean)false);
            if (SharedGlue.getPlayerInCreative((PlayerEntity)player) || SharedGlue.isaOpPlayer((PlayerEntity)player) || AdvancementPredicate.isDone((ResourceLocation)NOMADS_SKY_ADVANCEMENT, (PlayerEntity)player)) {
                Locations.getSpawnPoint((ServerPlayerEntity)splayer, (boolean)false).ifPresent(destination -> {
                    if ((!this._dimension_bound || destination.dim == world.func_234923_W_()) && this.canFire(splayer, mirror)) {
                        ServerWorld destworld = (ServerWorld)destination.serverworld().get();
                        used.setTrue();
                        splayer.func_184210_p();
                        splayer.func_200619_a(destworld, (double)destination.pos.func_177958_n() + 0.5, (double)destination.pos.func_177956_o(), (double)destination.pos.func_177952_p() + 0.5, splayer.field_70177_z, splayer.field_70125_A);
                        splayer.field_70143_R = 0.0f;
                        Effects.playSound((World)destworld, (PlayerEntity)player, (SoundEvent)SoundEvents.field_187544_ad, (float)2.0f, (float)1.0f);
                    }
                });
            }
            if (used.isTrue()) {
                if (SharedGlue.getPlayerInSurvival((PlayerEntity)player) && this._use_bound) {
                    mirror.func_190918_g(1);
                }
                this.addUsedStat(player);
                result = ActionResultType.SUCCESS;
            } else {
                Effects.playUseItemFailedSoundFromServer((World)world, (PlayerEntity)player);
                VanillaFoodPantry.runtime.sendPlayerMessage(player, true, (ITextComponent)new TranslationTextComponent("msg.vfp.ink_mirror.cannot.use"));
                result = ActionResultType.FAIL;
            }
        }
        return new ActionResult(result, (Object)mirror);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerPropertyOverrides() {
        ItemModelsProperties.func_239418_a_((Item)this, (ResourceLocation)new ResourceLocation("skin"), (stack, world, entity) -> InkPearlMirror.isAlternate(stack) ? 1.0f : 0.0f);
    }
}

